/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.datarange;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeEnum;
import kd.fi.er.mobile.datarange.IDateRange;
import kd.fi.er.mobile.util.CastUtils;
import kd.fi.er.mobile.util.JsonUtils;

public abstract class UseSingleDateRangeMobPlugin
extends AbstractMobFormPlugin {
    private static final String ACTIONID_DATERANGE = "ACTIONID_DATERANGE";
    private static final String CTRL_DATE_SPAN_PANEL = "date_range_panel";
    private static final String CTRL_DATE_SPAN_LABEL = "date_span_panel_label";
    protected static final String CACHE_DATE_RANGE = "CACHE_DATE_RANGE_0";

    protected abstract void dateRangeChange(IDateRange var1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_DATE_SPAN_PANEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDateRangePanel();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CTRL_DATE_SPAN_PANEL.contains(key)) {
            this.showDateSpanSelectModalPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ACTIONID_DATERANGE.contains(actionId) && closedCallBackEvent.getReturnData() != null) {
            String dateRange = (String)CastUtils.cast((Object)closedCallBackEvent.getReturnData());
            DateRange range = this.changeDateRange(dateRange);
            this.cacheDateRange(dateRange);
            this.dateRangeChange((IDateRange)range);
        }
    }

    protected DateRange changeDateRange(String dateRange) {
        DateRange range = (DateRange)JsonUtils.fromJson((String)dateRange, DateRange.class);
        Label dateSpanLabel = (Label)this.getView().getControl(CTRL_DATE_SPAN_LABEL);
        dateSpanLabel.setText(range.getSpanDesc());
        return range;
    }

    protected void initDateRangePanel() {
        DateRange dateRange = this.getDateRange();
        Label dateSpanLabel = (Label)this.getView().getControl(CTRL_DATE_SPAN_LABEL);
        dateSpanLabel.setText(dateRange.getSpanDesc());
    }

    protected DateRange getInitDateRange() {
        return DateRangeEnum.CURRENT_MONTH.toDateRange();
    }

    protected void showDateSpanSelectModalPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("em_m_daterange_select");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setCustParam(Collections.singletonMap("position", "bottom"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_DATERANGE));
        parameter.setCustomParam("dateRange", (Object)this.getDateRangeStr());
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected IPageCache getSaveDatePagecache() {
        return this.getView().getPageCache();
    }

    protected void cacheDateRange(String dateRangeStr) {
        this.getSaveDatePagecache().put(this.getCacheKey(), dateRangeStr);
        this.getSaveDatePagecache().saveChanges();
    }

    public DateRange getDateRange() {
        String dateRangeJson = this.getSaveDatePagecache().get(this.getCacheKey());
        if (dateRangeJson == null) {
            dateRangeJson = (String)this.getView().getFormShowParameter().getCustomParam("dateRange");
            if (dateRangeJson == null) {
                return this.getInitDateRange();
            }
            this.cacheDateRange(dateRangeJson);
        }
        return (DateRange)JsonUtils.fromJson((String)dateRangeJson, DateRange.class);
    }

    protected String getDateRangeStr() {
        String dateRangeJson = this.getSaveDatePagecache().get(this.getCacheKey());
        if (dateRangeJson == null) {
            return JsonUtils.toJson((Object)this.getInitDateRange());
        }
        return dateRangeJson;
    }

    protected String getCacheKey() {
        return CACHE_DATE_RANGE;
    }
}

