/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Label;

public class PageUtils {
    public static IFormView getTargetPageView(IFormView view, String targetId) {
        for (IFormView targetView = view; targetView != null; targetView = targetView.getParentView()) {
            if (!StringUtils.equals((CharSequence)targetId, (CharSequence)targetView.getEntityId())) continue;
            return targetView;
        }
        return null;
    }

    public static void showTip(IFormView view, String title, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("confirmType", ConfirmTypes.Default.getValue());
        map.put("button_type", MessageBoxOptions.None.getValue());
        map.put("title", title);
        map.put("msg", msg);
        ((AbstractFormView)view).getClientProxy().addAction("showConfirm", map);
    }

    public static void jump403(IFormView view, String callbackClassName) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("em_m_error_403");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack(callbackClassName, "actionid_page403"));
        StyleCss value = new StyleCss();
        value.setHeight("100%");
        showParameter.getOpenStyle().setInlineStyleCss(value);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void setLabel(IFormView formView, String labelKey, BigDecimal ratio) {
        PageUtils.setLabel(formView, labelKey, ratio, false);
    }

    public static void setLabel(IFormView formView, String labelKey, BigDecimal ratio, boolean inverseColor) {
        Label label = (Label)formView.getControl(labelKey);
        if (ratio != null) {
            BigDecimal setScale = ratio.multiply(new BigDecimal("100")).setScale(0, 4);
            String text = setScale + "%";
            if (setScale.compareTo(BigDecimal.ZERO) > 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", inverseColor ? "#1BA854" : "#FB2323");
                formView.updateControlMetadata(labelKey, ctrl);
                text = "+" + text;
            } else if (setScale.compareTo(BigDecimal.ZERO) < 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", inverseColor ? "#FB2323" : "#1BA854");
                formView.updateControlMetadata(labelKey, ctrl);
            } else {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", "#666666");
                formView.updateControlMetadata(labelKey, ctrl);
            }
            label.setText(text);
        } else {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", "#666666");
            formView.updateControlMetadata(labelKey, ctrl);
            label.setText("-");
        }
    }
}

