/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.formplugin.analyse.AbstractListTemplatePlugin;
import kd.fi.er.mobile.service.analyse.IListDataProcess;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.data.TransferData;

public abstract class AbstractChartListTemplatePlugin<T extends TransferData, P extends IListDataProcess<T>>
extends AbstractListTemplatePlugin<T, P> {
    protected static final String SERIES_TYPE_LINE = "LineSeries";
    protected static final String SERIES_TYPE_BAR = "BarSeries";
    protected static final String CTRL_CHART_AP = "echartap";

    protected abstract Series createSeries(Chart var1, ListDataModel var2);

    @Override
    protected void setListData(ListDataModel data) {
        this.setChart(data);
    }

    protected void setChart(ListDataModel data) {
        List<ItemModel> models = data.getDatas().stream().limit(data.getChartLimit()).collect(Collectors.toList());
        if (this.allEmpty(models)) {
            this.setPropDataTag(1);
            return;
        }
        Chart chart = this.getChart();
        this.setChartMargin(chart, data.getSeriesType());
        this.setLegend(chart, data);
        this.setTooltip(chart, data.getTooltipFormatter());
        this.setXAxis(chart, data.getxName(), models, data.getSeriesType());
        this.setYAxis(chart, data.getyName(), data.getyAxisLineFormatter(), models);
        Series series = this.createSeries(chart, data);
        series.setPropValue("data", this.getSeriesData(models));
        chart.refresh();
    }

    protected Object getSeriesData(List<ItemModel> models) {
        return models.stream().map(ItemModel::getValue).collect(Collectors.toList());
    }

    protected boolean allEmpty(List<ItemModel> models) {
        for (ItemModel model : models) {
            if (model.getValue() == null || model.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    protected Chart getChart() {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        return chart;
    }

    protected void setChartMargin(Chart chart, String seriesType) {
        this.setChartMargin(chart);
    }

    protected void setChartMargin(Chart chart) {
        chart.setMargin(Position.left, "5%");
        chart.setMargin(Position.top, "15%");
        chart.setMargin(Position.right, "6%");
        chart.setMargin(Position.bottom, "6%");
    }

    protected void setLegend(Chart chart, ListDataModel data) {
        chart.setShowLegend(false);
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    protected void setTooltip(Chart chart, String tooltipFormatter) {
        if (tooltipFormatter == null) {
            chart.setShowTooltip(false);
        } else {
            chart.setShowTooltip(true);
            chart.addTooltip("trigger", (Object)"axis");
            if (tooltipFormatter.equals("")) {
                tooltipFormatter = "function(item) { if(item[0].data===null){ return '-'; }else{ return item[0].data.text; }}";
            }
            chart.addTooltip("formatter", (Object)tooltipFormatter);
            chart.addFuncPath(M.arraylist((Object[])new Object[]{"tooltip", "formatter"}));
        }
    }

    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items) {
        return this.setXAxis(chart, xName, items, SERIES_TYPE_BAR);
    }

    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items, String seriesType) {
        Axis axis = chart.createXAxis(xName, AxisType.category);
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", (Object)0).kv("rotate", (Object)-30).kv("color", (Object)"#999999"));
        axis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        axis.setPropValue("axisLine", (Object)M.map().kv("show", (Object)Boolean.FALSE).kv("lineStyle", map -> map.kv("color", (Object)"#999").kv("width", (Object)1)));
        List collect = items.stream().map(result -> M.map().kv("value", this.disposeXaxisValue(result.getItemname(), seriesType)).kv("textStyle", (Object)M.map((String)"fontSize", (Object)12))).collect(Collectors.toList());
        axis.setPropValue("data", collect);
        return axis;
    }

    protected Object disposeXaxisValue(String value) {
        return this.disposeXaxisValue(value, SERIES_TYPE_BAR);
    }

    protected Object disposeXaxisValue(String value, String seriesType) {
        return value;
    }

    protected BigDecimal getFixMaxValue(List<ItemModel> items) {
        double maxV = items.stream().mapToDouble(value -> value.getValue() == null ? 0.0 : value.getValue().doubleValue()).max().orElse(1.0);
        if (maxV <= 0.4) {
            return new BigDecimal("0.4");
        }
        return null;
    }

    protected Axis setYAxis(Chart chart, String yName, String yAxisLineFormatter, List<ItemModel> models) {
        Axis yAxis = chart.createYAxis(yName, AxisType.value);
        BigDecimal fixMaxValue = this.getFixMaxValue(models);
        if (fixMaxValue != null) {
            yAxis.setPropValue("max", (Object)fixMaxValue);
            yAxis.setPropValue("interval", (Object)fixMaxValue.divide(new BigDecimal(4), 1, 4));
        }
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("align", (Object)"left").list("padding", new Object[]{0, 0, 0, -10}));
        yAxis.setPropValue("type", (Object)"value");
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("formatter", (Object)yAxisLineFormatter));
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"yAxis", 0, "axisLabel", "formatter"}));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", (Object)"dashed").kv("color", (Object)"#e8e8e8")));
        yAxis.setPropValue("axisLine", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        yAxis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        return yAxis;
    }

    protected void setSeriesProp(Series series, ListDataModel data) {
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"rgba(10,154,255,1)")));
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("show", (Object)Boolean.FALSE)));
    }
}

