/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.exception.ErMobiException;
import kd.fi.er.mobile.exception.ErMobiNoExchangeRateException;
import kd.fi.er.mobile.formplugin.analyse.AbstractTemplatePlugin;
import kd.fi.er.mobile.service.analyse.IListDataProcess;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.data.TransferData;
import kd.fi.er.mobile.util.CommonUtils;

public abstract class AbstractListTemplatePlugin<T extends TransferData, P extends IListDataProcess<T>>
extends AbstractTemplatePlugin<T, P> {
    protected static final String CTRL_ENTRY_KEY_LIST = "entryentity";
    protected static final String ENTRY_ITEM_NAME = "itemname";
    protected static final String ENTRY_ITEM_VALUE = "itemvalue";
    protected static final String ENTRY_ITEM_VALUE1 = "itemvalue1";
    protected static final String ENTRY_ITEM_VALUE2 = "itemvalue2";

    protected abstract void setListData(ListDataModel var1);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object transferData = this.getTransferData();
        this.initView(transferData);
        AmountHelper.cacheAmountConvert((AmountConvertDTO)transferData.getCardParameter().getConvertDTO());
        ListDataModel data = this.loadListData(transferData);
        this.setListPanel(data);
        this.setListData(data);
    }

    protected void initView(T param) {
    }

    protected ListDataModel loadListData(T transferData) {
        IListDataProcess process = (IListDataProcess)this.getDataProcess(transferData.getProcessClassName());
        try {
            ListDataModel data = process.getListData(transferData);
            if (data.getDatas().isEmpty() || data.getDataTag() == 0) {
                this.setPropDataTag(0, data.getNoDataTip());
            }
            return data;
        }
        catch (ErMobiNoExchangeRateException ex) {
            this.setPropDataTag(0, CommonUtils.createNoExchangeRateTips((List)ex.getAbsentCurrencies()));
        }
        catch (ErMobiException ex) {
            this.setPropDataTag(0, ex.getMessage());
        }
        return new ListDataModel();
    }

    protected void setListPanel(ListDataModel dataModel) {
        List datas = dataModel.getDatas();
        IDataModel model = this.getModel();
        model.deleteEntryData(CTRL_ENTRY_KEY_LIST);
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(CTRL_ENTRY_KEY_LIST, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(CTRL_ENTRY_KEY_LIST);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            DynamicProperty itemvalue = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE);
            DynamicProperty itemvalue1 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE1);
            DynamicProperty itemvalue2 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE2);
            DynamicProperty groupby = dynamicObjects.getDynamicObjectType().getProperty("groupby");
            DynamicProperty groupid = dynamicObjects.getDynamicObjectType().getProperty("groupid");
            DynamicProperty havechildren = dynamicObjects.getDynamicObjectType().getProperty("havechildren");
            DynamicProperty havemore = dynamicObjects.getDynamicObjectType().getProperty("havemore");
            for (int i = 0; i < size; ++i) {
                ItemModel item = (ItemModel)datas.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemname.setValueFast((Object)entry, (Object)item.getItemname());
                itemvalue.setValueFast((Object)entry, (Object)item.getItemvalue());
                itemvalue1.setValueFast((Object)entry, (Object)item.getItemvalue1());
                itemvalue2.setValueFast((Object)entry, (Object)item.getItemvalue2());
                groupid.setValueFast((Object)entry, (Object)item.getGroupid());
                groupby.setValueFast((Object)entry, (Object)dataModel.getGroupby());
                havechildren.setValueFast((Object)entry, (Object)item.getHaveChildren());
                havemore.setValueFast((Object)entry, (Object)item.getHaveMore());
            }
            model.endInit();
        }
        this.getView().updateView(CTRL_ENTRY_KEY_LIST);
    }
}

