/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.formplugin.analyse.AbstractTemplatePlugin;
import kd.fi.er.mobile.service.analyse.ListDataProcess;
import kd.fi.er.mobile.service.analyse.data.TransferData;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataVO;
import kd.fi.er.mobile.vo.IChartTextFormatter;
import kd.fi.er.mobile.vo.RightSeriesVO;

public class CusChartListTemplatePlugin
extends AbstractTemplatePlugin<TransferData, ListDataProcess> {
    public static final String FORMID = "em_m_analyse_cuschart";
    protected static final String CTRL_CHART_AP = "echartap";
    protected static final String CTRL_ENTRY_KEY_LIST = "entryentity";
    protected static final String ENTRY_ITEM_NAME = "itemname";
    protected static final String ENTRY_ITEM_VALUE = "itemvalue";
    protected static final String ENTRY_ITEM_VALUE1 = "itemvalue1";
    protected static final String ENTRY_ITEM_VALUE2 = "itemvalue2";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object tData = this.getTransferData();
        ListDataProcess process = (ListDataProcess)this.getDataProcess(tData.getProcessClassName());
        DataChartListVO data = process.getListData(tData);
        this.setData(data);
        this.setListPanel(data);
    }

    protected void setData(DataChartListVO data) {
        List<DataVO> chartDatas;
        Object tData = this.getTransferData();
        ListDataProcess process = (ListDataProcess)this.getDataProcess(tData);
        if (process.allEmpty(chartDatas = data.getDatas().stream().limit(data.getChartLimit()).collect(Collectors.toList()))) {
            this.setPropDataTag(1);
            return;
        }
        this.setChart(data, chartDatas);
    }

    protected void setChart(DataChartListVO data, List<DataVO> chartDatas) {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        this.setChartMargin(chart);
        this.setLegend(chart);
        this.setTooltip(chart, data.getTooltipFormatter());
        this.setXAxis(chart, chartDatas);
        this.createLeftSeries(chart, data, chartDatas);
        this.createRightSeries(chart, data, chartDatas);
        chart.refresh();
    }

    private void createLeftSeries(Chart chart, DataChartListVO data, List<DataVO> models) {
        BarSeries series = chart.createBarSeries(data.getSeriesName());
        series.setPropValue("yAxisIndex", (Object)0);
        series.setBarWidth("18");
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#505BF9")));
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("show", (Object)Boolean.FALSE)));
        IChartTextFormatter formatter = data.getFormatter();
        ArrayList list = new ArrayList(models.size());
        for (DataVO vo : models) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            if (formatter != null) {
                map2.put("text", formatter.formatTip(vo));
            }
            map2.put("value", vo.getValue());
            list.add(map2);
        }
        series.setPropValue("data", list);
        this.setYAxis(chart, data.getyName());
    }

    private void createRightSeries(Chart chart, DataChartListVO data, List<DataVO> models) {
        RightSeriesVO seriesVo = data.getRightSeries();
        if (seriesVo != null) {
            LineSeries series = chart.createLineSeries(seriesVo.getSeriesName());
            series.setPropValue("yAxisIndex", (Object)1);
            series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#FFC13F")));
            List list = models.stream().map(DataVO::getValue2).collect(Collectors.toList());
            series.setPropValue("data", list);
            this.setYAxis(chart, seriesVo.getyName());
        }
    }

    protected void setChartMargin(Chart chart) {
        chart.setMargin(Position.top, "60px");
        chart.setMargin(Position.right, "20px");
    }

    protected void setLegend(Chart chart) {
        chart.setShowLegend(true);
        chart.setLegendPropValue("left", (Object)"0%");
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    protected void setTooltip(Chart chart, String formatter) {
        if (formatter == null) {
            chart.setShowTooltip(false);
        } else {
            chart.setShowTooltip(true);
            chart.addTooltip("trigger", (Object)"axis");
            chart.addTooltip("formatter", (Object)formatter);
            chart.addFuncPath(M.arraylist((Object[])new Object[]{"tooltip", "formatter"}));
        }
    }

    protected void setXAxis(Chart chart, List<DataVO> list) {
        Axis axis = chart.createXAxis("", AxisType.category);
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", (Object)0).kv("rotate", (Object)-30).kv("color", (Object)"#999999"));
        axis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        axis.setPropValue("axisLine", (Object)M.map().kv("show", (Object)Boolean.FALSE).kv("lineStyle", map -> map.kv("color", (Object)"#999").kv("width", (Object)1)));
        List collect = list.stream().map(result -> M.map().kv("value", (Object)result.getItemname()).kv("textStyle", (Object)M.map((String)"fontSize", (Object)12))).collect(Collectors.toList());
        axis.setPropValue("data", collect);
    }

    protected void setYAxis(Chart chart, String yName) {
        Axis yAxis = chart.createYAxis(yName, AxisType.value);
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("align", (Object)"left").list("padding", new Object[]{0, 0, 0, -10}));
        yAxis.setPropValue("type", (Object)"value");
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", (Object)"dashed").kv("color", (Object)"#e8e8e8")));
        yAxis.setPropValue("axisLine", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        yAxis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
    }

    protected void setListPanel(DataChartListVO data) {
        List datas = data.getDatas();
        IDataModel model = this.getModel();
        model.deleteEntryData(CTRL_ENTRY_KEY_LIST);
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(CTRL_ENTRY_KEY_LIST, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(CTRL_ENTRY_KEY_LIST);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            DynamicProperty itemvalue = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE);
            DynamicProperty itemvalue1 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE1);
            DynamicProperty itemvalue2 = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_VALUE2);
            DynamicProperty groupid = dynamicObjects.getDynamicObjectType().getProperty("groupid");
            for (int i = 0; i < size; ++i) {
                DataVO vo = (DataVO)datas.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemname.setValueFast((Object)entry, (Object)vo.getItemname());
                itemvalue.setValueFast((Object)entry, (Object)vo.getItemvalue());
                itemvalue1.setValueFast((Object)entry, (Object)vo.getItemvalue1());
                itemvalue2.setValueFast((Object)entry, (Object)vo.getItemvalue2());
                groupid.setValueFast((Object)entry, (Object)vo.getItemId());
            }
            model.endInit();
        }
        this.getView().updateView(CTRL_ENTRY_KEY_LIST);
    }
}

