/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.analyse.AbstractTemplatePlugin;
import kd.fi.er.mobile.service.analyse.TabNextListDataProcess;
import kd.fi.er.mobile.service.analyse.data.HeadDataModel;
import kd.fi.er.mobile.service.analyse.data.NextListTransferData;
import kd.fi.er.mobile.service.analyse.data.TabContainerData;
import kd.fi.er.mobile.util.JsonUtils;

public class DynamicTabTemplatePlugin
extends AbstractTemplatePlugin<NextListTransferData, TabNextListDataProcess> {
    public static final String FORMID = "em_m_analyse_tab";
    private static final String CONDITION_ORG = "orgcondition";
    private static final String CONDITION_TIME_RANGE = "timerangecondition";
    protected static final String CTRL_COMBOFIELD = "combofield";
    protected static final String CTRL_TAB_AP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        tab.addTabSelectListener(evt -> this.buildContainer(this.getTabs(), evt.getTabKey()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        NextListTransferData transferData = (NextListTransferData)this.getTransferData();
        this.initFilterView(transferData.getCardParameter());
        TabNextListDataProcess process = (TabNextListDataProcess)this.getDataProcess(transferData);
        List tabs = process.getTabs();
        this.buildTabs(tabs);
        this.loadData(process, transferData);
        this.buildContainer(tabs, null, transferData);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (CTRL_COMBOFIELD.equals(propertyName)) {
            Object value = this.getModel().getValue(CTRL_COMBOFIELD);
            this.changedFilter(value.toString());
        }
    }

    private void initFilterView(ParameterCardDTO parameter) {
        ((Label)this.getView().getControl(CONDITION_ORG)).setText(parameter.getOrgLabelText());
        ((Label)this.getView().getControl(CONDITION_TIME_RANGE)).setText(parameter.getDateRange().getSpanDesc());
    }

    protected void loadData(TabNextListDataProcess process, NextListTransferData transferData) {
        HeadDataModel data = process.getHeadData(transferData);
        Label labelname1 = (Label)this.getView().getControl("labelname1");
        Label labelvalue1 = (Label)this.getView().getControl("labelvalue1");
        labelname1.setText(data.getName1());
        labelvalue1.setText(data.getValue1());
        ComboEdit combo = (ComboEdit)this.getControl(CTRL_COMBOFIELD);
        Map comboMap = process.getComboItems();
        combo.setComboItems(this.revertComboItems(comboMap));
        this.getModel().setValue(CTRL_COMBOFIELD, (Object)transferData.getFilter());
    }

    private List<ComboItem> revertComboItems(Map<String, LocaleString> comboMap) {
        return comboMap.entrySet().stream().map(entry -> {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption((LocaleString)entry.getValue());
            return item;
        }).collect(Collectors.toList());
    }

    private void changedFilter(String filter) {
        NextListTransferData transferData = (NextListTransferData)this.getTransferData();
        transferData.setFilter(filter);
        this.cacheTransferData(transferData);
        TabNextListDataProcess process = (TabNextListDataProcess)this.getDataProcess(transferData);
        this.loadData(process, transferData);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        this.buildContainer(process.getTabs(), tab.getCurrentTab(), transferData);
    }

    private void buildTabs(List<TabContainerData> tabs) {
        List tabControls = tabs.stream().map(tab -> {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(tab.getKey());
            tabPageAp.setName(new LocaleString(tab.getName()));
            return tabPageAp.createControl();
        }).collect(Collectors.toList());
        Tab tabAp = (Tab)this.getView().getControl(CTRL_TAB_AP);
        tabAp.addControls(tabControls);
    }

    private void buildContainer(List<TabContainerData> tabs, String tabKey) {
        this.buildContainer(tabs, tabKey, (NextListTransferData)this.getTransferData());
    }

    private void buildContainer(List<TabContainerData> tabs, String tabKey, NextListTransferData param) {
        TabContainerData tab = null;
        if (tabKey == null) {
            tab = tabs.get(0);
        } else {
            for (TabContainerData tabContainerData : tabs) {
                if (!tabKey.equals(tabContainerData.getKey())) continue;
                tab = tabContainerData;
                break;
            }
        }
        Container containerAp = (Container)this.getView().getControl("containerap");
        String formId = this.getView().getPageCache().get("setTargetKey");
        if (formId != null) {
            containerAp.deleteControls(new String[]{formId});
        }
        FlexPanelAp flex = new FlexPanelAp();
        assert (tab != null);
        flex.setKey(tab.getFormId());
        containerAp.addControls(Collections.singletonList(flex.createControl()));
        this.getView().getPageCache().put("setTargetKey", tab.getFormId());
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(tab.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(tab.getFormId());
        param.setKey(tab.getKey());
        showParameter.setCustomParam("transfer_key", (Object)JsonUtils.toJson((Object)param));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static void jumpMeBy(IFormView formView, String caption, NextListTransferData transferData) {
        IFormView targetPageView;
        if (StringUtils.isBlank((CharSequence)caption) && (targetPageView = PageUtils.getTargetPageView(formView, FORMID)) != null) {
            caption = targetPageView.getFormShowParameter().getCaption();
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(caption);
        parameter.setCustomParam("transfer_key", (Object)JsonUtils.toJson((Object)transferData));
        formView.showForm((FormShowParameter)parameter);
    }

    public List<TabContainerData> getTabs() {
        return ((TabNextListDataProcess)this.getDataProcess(this.getTransferData())).getTabs();
    }
}

