/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.analyse.AbstractTemplatePlugin;
import kd.fi.er.mobile.service.analyse.DynamicListGroupDataProcess;
import kd.fi.er.mobile.service.analyse.data.DynamicGroupTransferData;
import kd.fi.er.mobile.service.analyse.data.HeadDataModel;
import kd.fi.er.mobile.util.InvokeUtil;
import kd.fi.er.mobile.util.JsonUtils;

public class DynamicTemplateFormPlugin
extends AbstractTemplatePlugin<DynamicGroupTransferData, DynamicListGroupDataProcess>
implements RowClickEventListener {
    public static final String FORMID = "em_m_template_dynamicana";
    private static final String TRANSFER_KEY = "transfer_key";
    protected static final String CTRL_TAB_AP = "tabap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicGroupTransferData transferData = this.getTransferData();
        this.initialHeadPanel(transferData);
        this.buildContainer();
    }

    protected void initialHeadPanel(DynamicGroupTransferData transferData) {
        DynamicListGroupDataProcess process = (DynamicListGroupDataProcess)InvokeUtil.getInstance((String)transferData.getProcessClassName());
        HeadDataModel headData = process.getTemplateHeadData(transferData);
        this.setHeadView(headData);
    }

    protected void setHeadView(HeadDataModel headData) {
        Label labelname1 = (Label)this.getView().getControl("labelname1");
        Label labelvalue1 = (Label)this.getView().getControl("labelvalue1");
        Label labelname2 = (Label)this.getView().getControl("labelname2");
        Label labelvalue2 = (Label)this.getView().getControl("labelvalue2");
        labelname1.setText(headData.getName1());
        labelvalue1.setText(headData.getValue1());
        labelname2.setText(headData.getName2());
        labelvalue2.setText(headData.getValue2());
    }

    private void buildContainer() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(TRANSFER_KEY);
        DynamicGroupTransferData param = (DynamicGroupTransferData)JsonUtils.fromJson((String)str, DynamicGroupTransferData.class);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("em_m_analyse_echart");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("dynamic_analyse_panel");
        showParameter.setCustomParam(TRANSFER_KEY, (Object)JsonUtils.toJson((Object)param));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public DynamicGroupTransferData getTransferData() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(TRANSFER_KEY);
        return (DynamicGroupTransferData)JsonUtils.fromJson((String)str, DynamicGroupTransferData.class);
    }

    public static void jumpMeBy(IFormView formView, String caption, DynamicGroupTransferData transferData) {
        IFormView targetPageView;
        if (caption == null && (targetPageView = PageUtils.getTargetPageView(formView, FORMID)) != null) {
            caption = targetPageView.getFormShowParameter().getCaption();
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(caption);
        parameter.setCustomParam(TRANSFER_KEY, (Object)JsonUtils.toJson((Object)transferData));
        parameter.setCustomParam("unionparameter", (Object)JsonUtils.toJson((Object)transferData.getCardParameter()));
        formView.showForm((FormShowParameter)parameter);
    }
}

