/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.formplugin.analyse.AbstractChartListTemplatePlugin;
import kd.fi.er.mobile.formplugin.analyse.DynamicTemplateFormPlugin;
import kd.fi.er.mobile.formplugin.analyse.SelectListModalPlugin;
import kd.fi.er.mobile.service.analyse.DynamicListGroupDataProcess;
import kd.fi.er.mobile.service.analyse.data.DynamicGroupTransferData;
import kd.fi.er.mobile.service.analyse.data.GroupDataModel;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.data.SelectItemData;
import kd.fi.er.mobile.service.analyse.enums.BaseGroupDataEnum;
import kd.fi.er.mobile.util.CastUtils;
import kd.fi.er.mobile.util.CommonUtils;

public class EChartDynamicNextListTemplatePlugin
extends AbstractChartListTemplatePlugin<DynamicGroupTransferData, DynamicListGroupDataProcess>
implements RowClickEventListener {
    public static final String FORMID = "em_m_analyse_echart";
    protected static final String CTRL_LABELAPTITLE = "labelaptitle";
    protected static final String CTRL_COMBOFIELD = "combofield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    protected ListDataModel loadListData(DynamicGroupTransferData transferData) {
        ListDataModel data = super.loadListData(transferData);
        this.setItemHaveMore(data, transferData);
        return data;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (CTRL_COMBOFIELD.equals(propertyName)) {
            Object value = this.getModel().getValue(CTRL_COMBOFIELD);
            DynamicGroupTransferData transferData = (DynamicGroupTransferData)this.getTransferData();
            transferData.getGroupbys().set(transferData.getGroupbys().size() - 1, GroupDataModel.buildOf((String)String.valueOf(value)));
            this.cacheTransferData(transferData);
            ListDataModel data = this.loadListData(transferData);
            this.setListPanel(data);
            this.setListData(data);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex);
            String groupby = dynamicObject.getString("groupby");
            Long groupid = dynamicObject.getLong("groupid");
            boolean havechildren = dynamicObject.getBoolean("havechildren");
            int havemore = dynamicObject.getInt("havemore");
            if (havemore == 1) {
                this.jumpNext(groupby, groupid, havechildren);
            }
        }
    }

    @Override
    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items, String seriesType) {
        Axis axis = super.setXAxis(chart, xName, items, "BarSeries");
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", (Object)0).kv("color", (Object)"#999999").kv("formatter", (Object)" function(value){ return value.split('##').join(\"\\n\"); }"));
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"xAxis", 0, "axisLabel", "formatter"}));
        return axis;
    }

    @Override
    protected Object disposeXaxisValue(String value, String seriesType) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return CommonUtils.joinLines((String)value);
    }

    @Override
    protected void initView(DynamicGroupTransferData transferData) {
        List groupBys = transferData.getGroupBysStr();
        List<BaseGroupDataEnum> groupDataEnums = this.selectSameLevelSwitchList(groupBys);
        List comboItems = groupDataEnums.stream().map(groupData -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(groupData.getName()));
            comboItem.setValue(groupData.getCode());
            return comboItem;
        }).collect(Collectors.toList());
        if (comboItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl(CTRL_COMBOFIELD);
            combo.setComboItems(comboItems);
            this.getModel().setValue(CTRL_COMBOFIELD, groupBys.get(groupBys.size() - 1));
            this.getView().updateView(CTRL_COMBOFIELD);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_COMBOFIELD});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectlist".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            SelectItemData data = (SelectItemData)CastUtils.cast((Object)closedCallBackEvent.getReturnData());
            DynamicGroupTransferData transferData = (DynamicGroupTransferData)this.getTransferData();
            GroupDataModel lastGroupDataModel = transferData.lastGroupby();
            Map extra = data.getExtra();
            lastGroupDataModel.setGroupId(Long.valueOf(String.valueOf(extra.get("groupid"))));
            transferData.getGroupbys().add(GroupDataModel.buildOf((String)data.getId()));
            transferData.setConcludeParent(((Boolean)extra.get("isConcludeParent")).booleanValue());
            DynamicTemplateFormPlugin.jumpMeBy(this.getView(), "", transferData);
        }
    }

    private List<BaseGroupDataEnum> selectSameLevelSwitchList(List<String> groupBys) {
        HashSet<String> historyGroupSet = new HashSet<String>(groupBys);
        historyGroupSet.remove(groupBys.get(groupBys.size() - 1));
        return Arrays.stream(BaseGroupDataEnum.values()).filter(groupData -> !historyGroupSet.contains(groupData.getCode())).collect(Collectors.toList());
    }

    private List<BaseGroupDataEnum> selectNextLevelSwitchList(List<String> groupBys, BaseGroupDataEnum currentGroupDataEnum) {
        List<Object> groupDataEnums = this.selectSameLevelSwitchList(groupBys);
        if (!currentGroupDataEnum.isMultiply()) {
            groupDataEnums = groupDataEnums.stream().filter(groupData -> !currentGroupDataEnum.getCode().equals(groupData.getCode())).collect(Collectors.toList());
        }
        return groupDataEnums;
    }

    private void setItemHaveMore(ListDataModel data, DynamicGroupTransferData transferData) {
        List datas = data.getDatas();
        List groupBys = transferData.getGroupBysStr();
        for (ItemModel itemModel : datas) {
            List<BaseGroupDataEnum> groupDataEnums = this.selectSameLevelSwitchList(groupBys);
            if (itemModel.getGroupid() == -1L) {
                itemModel.setHaveMore(0);
                continue;
            }
            if (groupDataEnums.size() == 1 && !itemModel.getHaveChildren()) {
                itemModel.setHaveMore(0);
                continue;
            }
            itemModel.setHaveMore(1);
        }
    }

    @Override
    protected void setChart(ListDataModel data) {
        Label labelTitle = (Label)this.getView().getControl(CTRL_LABELAPTITLE);
        labelTitle.setText(data.getChartTitle());
        super.setChart(data);
    }

    @Override
    protected Series createSeries(Chart chart, ListDataModel data) {
        BarSeries series = chart.createBarSeries(data.getSeriesName());
        this.setSeriesProp((Series)series, data);
        series.setBarWidth("18");
        return series;
    }

    protected void jumpNext(String currentGroupBy, Long currentGroupId, boolean havechildren) {
        BaseGroupDataEnum currentGroupDataEnum;
        DynamicGroupTransferData transferData = (DynamicGroupTransferData)this.getTransferData();
        List groupBys = transferData.getGroupBysStr();
        List<BaseGroupDataEnum> groupDataEnums = this.selectNextLevelSwitchList(groupBys, currentGroupDataEnum = BaseGroupDataEnum.getEnumByCode((String)currentGroupBy));
        if (groupDataEnums.size() == 1) {
            if (havechildren) {
                GroupDataModel lastGroupDataModel = transferData.lastGroupby();
                lastGroupDataModel.setGroupId(currentGroupId);
                transferData.getGroupbys().add(GroupDataModel.buildOf((String)currentGroupBy));
                transferData.setConcludeParent(false);
            } else if (!currentGroupDataEnum.isMultiply()) {
                String anotherGroupCode = groupDataEnums.get(0).getCode();
                GroupDataModel lastGroupDataModel = transferData.lastGroupby();
                lastGroupDataModel.setGroupId(currentGroupId);
                transferData.getGroupbys().add(GroupDataModel.buildOf((String)anotherGroupCode));
            }
            DynamicTemplateFormPlugin.jumpMeBy(this.getView(), "", transferData);
        } else {
            this.showSelectNextLitView(currentGroupBy, currentGroupId, havechildren, groupDataEnums);
        }
    }

    private void showSelectNextLitView(String currentGroupBy, Long currentGroupId, boolean havechildren, List<BaseGroupDataEnum> groupDataEnums) {
        List<SelectItemData> collect = groupDataEnums.stream().map(groupData -> {
            SelectItemData item = new SelectItemData();
            item.setId(groupData.getCode());
            item.getExtra().put("groupby", currentGroupBy);
            item.getExtra().put("groupid", currentGroupId);
            if (groupData.getCode().equals(currentGroupBy) && groupData.isMultiply()) {
                item.setName(String.format(ResManager.loadKDString((String)"\u6309\u4e0b\u7ea7%s\u5c55\u5f00", (String)"EChartDynamicNextListTemplatePlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), groupData.getName()));
                item.getExtra().put("havechildren", havechildren);
                item.getExtra().put("isConcludeParent", Boolean.FALSE);
            } else {
                item.setName(String.format(ResManager.loadKDString((String)"\u6309%s\u5c55\u5f00", (String)"EChartDynamicNextListTemplatePlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), groupData.getName()));
                item.getExtra().put("havechildren", Boolean.TRUE);
                item.getExtra().put("isConcludeParent", Boolean.TRUE);
            }
            return item;
        }).collect(Collectors.toList());
        SelectListModalPlugin.jumpMeBy((AbstractFormPlugin)this, "selectlist", collect);
    }

    @Override
    protected Object getSeriesData(List<ItemModel> models) {
        return models.stream().map(ItemModel::getSignAmount).collect(Collectors.toList());
    }
}

