/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.formplugin.analyse.AbstractChartListTemplatePlugin;
import kd.fi.er.mobile.formplugin.analyse.DynamicTabTemplatePlugin;
import kd.fi.er.mobile.service.analyse.NextListDataProcess;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.data.NextListTransferData;
import kd.fi.er.mobile.util.CommonUtils;

public class EChartNextListTemplatePlugin
extends AbstractChartListTemplatePlugin<NextListTransferData, NextListDataProcess>
implements RowClickEventListener {
    public static final String FORMID = "em_m_analyse_cuschart";
    protected static final String CTRL_LABELAPTITLE = "labelaptitle";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex);
            String groupby = dynamicObject.getString("groupby");
            Long groupid = dynamicObject.getLong("groupid");
            int havemore = dynamicObject.getInt("havemore");
            if (havemore == 1) {
                this.jumpNext(groupby, groupid);
            }
        }
    }

    protected void jumpNext(String groupby, Long groubyId) {
        NextListTransferData transferData = (NextListTransferData)this.getTransferData();
        transferData.setLastGroupById(groubyId);
        DynamicTabTemplatePlugin.jumpMeBy(this.getView(), null, transferData);
    }

    @Override
    protected void setChart(ListDataModel data) {
        Label labelTitle = (Label)this.getView().getControl(CTRL_LABELAPTITLE);
        labelTitle.setText(data.getChartTitle());
        super.setChart(data);
    }

    @Override
    protected Object getSeriesData(List<ItemModel> models) {
        return models.stream().map(ItemModel::getSignAmount).collect(Collectors.toList());
    }

    @Override
    protected void setChartMargin(Chart chart, String seriesType) {
        if ("LineSeries".equals(seriesType)) {
            chart.setMargin(Position.left, "5%");
            chart.setMargin(Position.top, "15%");
            chart.setMargin(Position.right, "10%");
            chart.setMargin(Position.bottom, "6%");
        } else {
            super.setChartMargin(chart, seriesType);
        }
    }

    @Override
    protected Axis setXAxis(Chart chart, String xName, List<ItemModel> items, String seriesType) {
        if ("LineSeries".equals(seriesType)) {
            Axis axis = super.setXAxis(chart, xName, items, "LineSeries");
            axis.setPropValue("inverse", (Object)Boolean.TRUE);
            return axis;
        }
        Axis axis = super.setXAxis(chart, xName, items, "BarSeries");
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", (Object)0).kv("color", (Object)"#999999").kv("formatter", (Object)" function(value){ return value.split('##').join(\"\\n\"); }"));
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"xAxis", 0, "axisLabel", "formatter"}));
        return axis;
    }

    @Override
    protected Object disposeXaxisValue(String value, String seriesType) {
        if ("LineSeries".equals(seriesType)) {
            return value;
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return CommonUtils.joinLines((String)value);
    }

    @Override
    protected Series createSeries(Chart chart, ListDataModel data) {
        if ("LineSeries".equals(data.getSeriesType())) {
            return this.createLineSeries(chart, data);
        }
        BarSeries series = chart.createBarSeries(data.getSeriesName());
        this.setSeriesProp((Series)series, data);
        series.setBarWidth("18");
        return series;
    }

    private Series createLineSeries(Chart chart, ListDataModel data) {
        LineSeries series = chart.createLineSeries(data.getSeriesName());
        this.setSeriesProp((Series)series, data);
        series.setPropValue("symbolSize", (Object)6);
        series.setPropValue("lineStyle", (Object)M.map().kv("normal", map -> map.kv("width", (Object)1).kv("color", (Object)"#276FF5")));
        return series;
    }
}

