/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.analyse.AbstractTemplatePlugin;
import kd.fi.er.mobile.service.analyse.TabListDataProcess;
import kd.fi.er.mobile.service.analyse.data.TabContainerData;
import kd.fi.er.mobile.service.analyse.data.TransferData;
import kd.fi.er.mobile.util.JsonUtils;

public class MultiTabTemplatePlugin
extends AbstractTemplatePlugin<TransferData, TabListDataProcess> {
    public static final String FORMID = "em_m_analyse_multitab";
    protected static final String CTRL_TAB_AP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        tab.addTabSelectListener(evt -> this.buildContainer(this.getTabs(), evt.getTabKey()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object transferData = this.getTransferData();
        TabListDataProcess process = (TabListDataProcess)this.getDataProcess(transferData);
        List tabs = process.getTabs();
        this.buildTabs(tabs);
        this.buildContainer(tabs, transferData.getKey(), (TransferData)transferData);
    }

    private void buildTabs(List<TabContainerData> tabs) {
        List tabControls = tabs.stream().map(tab -> {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(tab.getKey());
            tabPageAp.setName(new LocaleString(tab.getName()));
            return tabPageAp.createControl();
        }).collect(Collectors.toList());
        Tab tabAp = (Tab)this.getView().getControl(CTRL_TAB_AP);
        tabAp.addControls(tabControls);
    }

    private void buildContainer(List<TabContainerData> tabs, String tabKey) {
        this.buildContainer(tabs, tabKey, (TransferData)this.getTransferData());
    }

    private void buildContainer(List<TabContainerData> tabs, String tabKey, TransferData tData) {
        TabContainerData tab = null;
        if (tabKey == null) {
            tab = tabs.get(0);
        } else {
            for (TabContainerData tabContainerData : tabs) {
                if (!tabKey.equals(tabContainerData.getKey())) continue;
                tab = tabContainerData;
                break;
            }
        }
        Container containerAp = (Container)this.getView().getControl("containerap");
        String formId = this.getView().getPageCache().get("setTargetKey");
        if (formId != null) {
            containerAp.deleteControls(new String[]{formId});
        }
        FlexPanelAp flex = new FlexPanelAp();
        assert (tab != null);
        flex.setKey(tab.getFormId());
        containerAp.addControls(Collections.singletonList(flex.createControl()));
        this.getView().getPageCache().put("setTargetKey", tab.getFormId());
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(tab.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(tab.getFormId());
        tData.setKey(tab.getKey());
        showParameter.setCustomParam("transfer_key", (Object)JsonUtils.toJson((Object)tData));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static void jumpMeBy(IFormView formView, String caption, TransferData transferData) {
        IFormView targetPageView;
        if (StringUtils.isBlank((CharSequence)caption) && (targetPageView = PageUtils.getTargetPageView(formView, FORMID)) != null) {
            caption = targetPageView.getFormShowParameter().getCaption();
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(caption);
        parameter.setCustomParam("transfer_key", (Object)JsonUtils.toJson((Object)transferData));
        formView.showForm((FormShowParameter)parameter);
    }

    public List<TabContainerData> getTabs() {
        return ((TabListDataProcess)this.getDataProcess(this.getTransferData())).getTabs();
    }
}

