/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.analyse;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.mobile.service.analyse.data.SelectItemData;
import kd.fi.er.mobile.util.JsonUtils;

public class SelectListModalPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public static final String FORMID = "em_m_selectlist_modal";
    public static final String KEY_PARAMS = "selectlistdata";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTRY_ITEM_NAME = "itemname";
    private static final String ENTRY_ITEM_ID = "itemid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String str = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMS);
        List list = JsonUtils.fromJsonToList((String)str, SelectItemData.class);
        this.setListPanel(list);
    }

    protected void setListPanel(List<?> datas) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(ENTRYENTITY);
            DynamicProperty itemid = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_ID);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            for (int i = 0; i < size; ++i) {
                SelectItemData item = (SelectItemData)datas.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemid.setValueFast((Object)entry, (Object)item.getId());
                itemname.setValueFast((Object)entry, (Object)item.getName());
            }
            model.endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ENTRYENTITY.equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currIndex);
            String id = dynamicObject.getString(ENTRY_ITEM_ID);
            String str = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMS);
            List list = JsonUtils.fromJsonToList((String)str, SelectItemData.class);
            for (SelectItemData o : list) {
                if (!o.getId().equals(id)) continue;
                boolean havechildren = (Boolean)o.getExtra().get("havechildren");
                if (havechildren) {
                    this.getView().returnDataToParent((Object)o);
                    continue;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u662f\u672b\u7ea7\u8282\u70b9\uff0c\u65e0\u6cd5\u5f80\u4e0b\u5c55\u5f00", (String)"SelectListModalPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }

    public static void jumpMeBy(AbstractFormPlugin plugin, String actionId, List<SelectItemData> datas) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(KEY_PARAMS, (Object)JsonUtils.toJson(datas));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm((FormShowParameter)parameter);
    }
}

