/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.index;

import java.util.EventObject;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.fi.er.mobile.common.UserParameterHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.enums.ISubject;
import kd.fi.er.mobile.enums.IndexTabImageEnum;
import kd.fi.er.mobile.enums.SubjectEnum;
import kd.fi.er.mobile.formplugin.index.IndexSelectCardPlugin;
import kd.fi.er.mobile.formplugin.template.FilterTemplatePlugin;
import kd.fi.er.mobile.service.my.UserSettingDAO;

public class IndexPlugin
extends FilterTemplatePlugin {
    public static final String FORMID = "em_m_index";
    protected static final String CTRL_BTN_OVERALL = "btnoverall";
    protected static final String CTRL_BTN_TRADER = "btntrader";
    protected static final String CTRL_BTN_INDEX = "btnindex";
    protected static final String CTRL_BTN_PERSONAL = "btnpersonal";
    protected static final String CTRL_BTN_MY = "btnmy";
    protected static final String CTRL_TAB_AP = "tabap";
    protected static final String CTRL_TAB_CARDS = "tabcards";
    protected static final String CTRL_TAB_PERSONAL = "tabpersonal";
    protected static final String CTRL_TAB_MY = "tabmy";
    protected static final String CTRL_FLEX_CUSTOMCARD = "flexpanelapcustomcard";
    protected static final String CTRL_BTN_CUSTOMCARD = "btn_custom_card";
    private static final String CALLBACKID_CUSTOM_CARD = "actionid_custom_card";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_OVERALL, CTRL_BTN_TRADER, CTRL_BTN_INDEX, CTRL_BTN_PERSONAL, CTRL_BTN_MY, CTRL_BTN_CUSTOMCARD});
    }

    @Override
    public boolean checkIndexFormRight() {
        return true;
    }

    @Override
    public void initBuildCard() {
        IndexTabImageEnum selectTab = this.getSelectTab();
        this.switchTabTo(selectTab.name(), true);
    }

    @Override
    protected boolean skipCheck() {
        return true;
    }

    @Override
    protected boolean isIndex() {
        IndexTabImageEnum selectTab = this.getCacheSelectTab();
        return IndexTabImageEnum.INDEX.name().equals(selectTab.name());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        this.bottomTabClick(evt);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && CALLBACKID_CUSTOM_CARD.equals(actionId) && "refresh".equals(returnData)) {
            this.buildCard(UserParameterHelper.getCustomCard());
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getCallBackId().equals("exitCallback")) {
            this.switchTabToPersonal();
        } else {
            super.confirmCallBack(messageBoxClosedEvent);
        }
    }

    @Override
    public void refreshData() {
        IndexTabImageEnum selectTab = this.getSelectTab();
        if (IndexTabImageEnum.PERSONAL.name().equals(selectTab.name())) {
            Control control = this.getControl(CTRL_TAB_PERSONAL);
            control.getView().invokeOperation("refresh");
        } else if (IndexTabImageEnum.MY.name().equals(selectTab.name())) {
            Control control = this.getControl(CTRL_TAB_MY);
            control.getView().invokeOperation("refresh");
        } else {
            this.rebuildCard();
        }
        this.setRefreshSuccess();
    }

    public void switchTabTo(String name, boolean forceRefresh) {
        if (IndexTabImageEnum.PERSONAL.name().equals(name)) {
            this.switchTabToPersonal();
            return;
        }
        if (super.checkIndexFormRight()) {
            if (IndexTabImageEnum.MY.name().equals(name)) {
                this.switchTabToMy();
                return;
            }
            if (this.getOrgIds().isEmpty()) {
                this.showMessageAndExit(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IndexPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (IndexTabImageEnum.OVERALL.name().equals(name)) {
                this.switchTabToSubject(IndexTabImageEnum.OVERALL, forceRefresh);
            } else if (IndexTabImageEnum.TRADER.name().equals(name)) {
                this.switchTabToSubject(IndexTabImageEnum.TRADER, forceRefresh);
            } else if (IndexTabImageEnum.INDEX.name().equals(name)) {
                this.switchTabToSubject(IndexTabImageEnum.INDEX, forceRefresh);
            }
        } else {
            this.switchTabToPersonal();
        }
    }

    public void switchTabToSubject(IndexTabImageEnum tabImageEnum, boolean forceRefresh) {
        if (this.changeTab(tabImageEnum) || forceRefresh) {
            this.switchTabToCards(this.subjectValueof(tabImageEnum.name()));
        }
    }

    public ISubject subjectValueof(String name) {
        return SubjectEnum.valueOf((String)name);
    }

    private void switchTabToPersonal() {
        this.changeTab(IndexTabImageEnum.PERSONAL);
        this.activeTab(CTRL_TAB_PERSONAL);
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("em_m_index_personal");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CTRL_TAB_PERSONAL);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void switchTabToMy() {
        this.changeTab(IndexTabImageEnum.MY);
        this.activeTab(CTRL_TAB_MY);
        MobileBillShowParameter parameter = new MobileBillShowParameter();
        parameter.setFormId("em_m_mine");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CTRL_TAB_MY);
        parameter.setPkId((Object)UserSettingDAO.getCurrUserSetting().getLong("id"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void switchTabToCards(ISubject subject) {
        this.changeDateRange(this.getDateRangeStr());
        this.activeTab(CTRL_TAB_CARDS);
        if (subject.equals(SubjectEnum.INDEX)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CTRL_FLEX_CUSTOMCARD});
            this.buildCard(UserParameterHelper.getCustomCard());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_FLEX_CUSTOMCARD});
            this.buildCard(subject.getFormIds());
        }
    }

    private boolean changeTab(IndexTabImageEnum tabImg) {
        IndexTabImageEnum selectTab = this.getCacheSelectTab();
        if (selectTab.name().equals(tabImg.name())) {
            return false;
        }
        Image oldimage = (Image)this.getControl(selectTab.getCtrlKey());
        oldimage.setUrl(selectTab.getNormalImg());
        this.getView().updateControlMetadata(selectTab.getCtrlTextKey(), M.map((String)"fc", (Object)"#666666"));
        Image image = (Image)this.getControl(tabImg.getCtrlKey());
        image.setUrl(tabImg.getSelectedImg());
        this.getView().updateControlMetadata(tabImg.getCtrlTextKey(), M.map((String)"fc", (Object)"#276FF5"));
        this.cacheSelectTab(tabImg.name());
        return true;
    }

    private IndexTabImageEnum getSelectTab() {
        String selectTab = this.getPageCache().get("selectTab");
        if (selectTab == null) {
            String pTab = (String)this.getView().getFormShowParameter().getCustomParam("INDEX_PARAMETER_TAB");
            if (pTab != null) {
                return IndexTabImageEnum.valueOf(pTab);
            }
            return IndexTabImageEnum.INDEX;
        }
        return IndexTabImageEnum.valueOf(selectTab);
    }

    private IndexTabImageEnum getCacheSelectTab() {
        String selectTab = this.getPageCache().get("selectTab");
        if (selectTab == null) {
            return IndexTabImageEnum.INDEX;
        }
        return IndexTabImageEnum.valueOf(selectTab);
    }

    private void cacheSelectTab(String name) {
        this.getPageCache().put("selectTab", name);
    }

    private void activeTab(String tabKey) {
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        String currentTab = tab.getCurrentTab();
        if (!StringUtils.equals((CharSequence)tabKey, (CharSequence)currentTab)) {
            tab.activeTab(tabKey);
        }
    }

    public void bottomTabClick(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_custom_card": {
                this.btnCustomCard();
                break;
            }
            case "btnoverall": {
                this.switchTabTo(IndexTabImageEnum.OVERALL.name(), false);
                break;
            }
            case "btntrader": {
                this.switchTabTo(IndexTabImageEnum.TRADER.name(), false);
                break;
            }
            case "btnindex": {
                this.switchTabTo(IndexTabImageEnum.INDEX.name(), false);
                break;
            }
            case "btnpersonal": {
                this.switchTabTo(IndexTabImageEnum.PERSONAL.name(), false);
                break;
            }
            case "btnmy": {
                this.switchTabTo(IndexTabImageEnum.MY.name(), false);
            }
        }
    }

    protected void btnCustomCard() {
        IndexSelectCardPlugin.jumpMeBy(this, CALLBACKID_CUSTOM_CARD);
    }

    public static void backToIndex(IFormView view) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)showParameter);
    }
}

