/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.overall.ApplyprojectbillProgressDataHelper;
import kd.fi.er.mobile.vo.DynamicObjectCollectionVO;

public class ApplyprojectbillProgressPlugin
extends CardTemplatePlugin {
    public static final Log logger = LogFactory.getLog(ApplyprojectbillProgressPlugin.class);
    private static final String CTRL_PRE_PROGRESS = "progressbarap";
    private static final String LABEL_PRE_TITLE = "labelaptitle";
    private static final String LABEL_PRE_TOTAL = "labelaptotal";
    private static final String LABEL_PRE_NOAPPLY = "labelapnoapply";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u7acb\u9879\u5355\u62a5\u9500\u8fdb\u5ea6", (String)"ApplyprojectbillProgressPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u4e3b\u8981\u7acb\u9879\u5355\u62a5\u9500\u8fdb\u5ea6", (String)"ApplyprojectbillProgressPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        DynamicObjectCollectionVO dynamicObjectCollectionVO = ApplyprojectbillProgressDataHelper.loadData((ParameterCardDTO)dto);
        this.setNoData(dynamicObjectCollectionVO.getDynamicObjects().size());
        this.setPanelData(dynamicObjectCollectionVO);
    }

    @Override
    protected void btnDetail() {
        super.btnDetail();
        this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"ApplyprojectbillProgressPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
    }

    private void setPanelData(DynamicObjectCollectionVO vo) {
        DynamicObjectCollection dynamicObjects = vo.getDynamicObjects();
        int size = Math.min(3, dynamicObjects.size());
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            ProgressBar progressBar = (ProgressBar)this.getControl(CTRL_PRE_PROGRESS + i);
            Label title = (Label)this.getControl(LABEL_PRE_TITLE + i);
            Label total = (Label)this.getControl(LABEL_PRE_TOTAL + i);
            Label noapply = (Label)this.getControl(LABEL_PRE_NOAPPLY + i);
            title.setText(dynamicObject.getString("projectnamedesc"));
            Long currency = dynamicObject.getLong("currency");
            BigDecimal acapproveamount = dynamicObject.getBigDecimal("acapproveamount");
            BigDecimal balanceamount = dynamicObject.getBigDecimal("balanceamount");
            SignAmount totalAmount = AmountHelper.getSignAmount((Long)currency, (BigDecimal)acapproveamount);
            SignAmount noApplyAmount = AmountHelper.getSignAmount((Long)currency, (BigDecimal)balanceamount);
            total.setText(totalAmount.getText());
            noapply.setText(noApplyAmount.getText());
            int value = totalAmount.getValue().subtract(noApplyAmount.getValue()).multiply(new BigDecimal("100")).divide(totalAmount.getValue(), 0, 4).intValue();
            progressBar.setPercent(value);
        }
    }
}

