/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeEnum;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.UnitEnum;
import kd.fi.er.mobile.formplugin.overall.ExpenseTrendDetailPlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.overall.ExpenseTrendDataHelper;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;
import kd.fi.er.mobile.vo.IData;

public class ExpenseTrendPlugin
extends CardTemplatePlugin {
    private static final String CTRL_CHART_AP = "trendchart";
    protected static final String CTRL_RG_GROUP_DATETYPE = "radiogroupfield";
    private static final String GROUP_TYPE_MONTH = "month";
    private static final String GROUP_TYPE_YEAR = "year";
    protected static final String GROUP_DATE_TYPE = "groupDateType";
    protected static final String CTRL_FLEX_TIPS = "flexpanelaptiput";
    private static final String CTRL_LABELED_TIPS = "labelaptiput";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u8d39\u7528\u8d8b\u52bf\u5206\u5e03", (String)"ExpenseTrendPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"\u67e5\u770b\u8d39\u7528\u8d8b\u52bf\u5206\u5e03", (String)"ExpenseTrendPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    protected void btnDetail() {
        String groupDateType = (String)this.getModel().getValue(CTRL_RG_GROUP_DATETYPE);
        ExpenseTrendDetailPlugin.jumpMeBy(this.getView(), ResManager.loadKDString((String)"\u8d39\u7528\u8d8b\u52bf", (String)"ExpenseTrendPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), this.getParameterJson(), groupDateType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (CTRL_RG_GROUP_DATETYPE.equals(propName)) {
            this.callNoExchangeRate(() -> this.changedGroupDateType(this.getParameter()));
        }
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        String groupDateType = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_DATE_TYPE);
        if (GROUP_TYPE_YEAR.equals(groupDateType)) {
            this.getModel().setValue(CTRL_RG_GROUP_DATETYPE, (Object)GROUP_TYPE_YEAR);
        } else {
            this.getModel().setValue(CTRL_RG_GROUP_DATETYPE, (Object)GROUP_TYPE_MONTH);
        }
        this.changedGroupDateType(dto);
    }

    protected void rangeDate(DateRange dateRange, String groupDateType) {
        LocalDate startDate = GROUP_TYPE_YEAR.equals(groupDateType) ? LocalDate.now().minusYears(6L).with(TemporalAdjusters.firstDayOfYear()) : LocalDate.now().minusMonths(6L).with(TemporalAdjusters.firstDayOfMonth());
        dateRange.setSpanType(DateRangeEnum.CUSTOM.getNumber());
        dateRange.setSpanDesc(DateRangeEnum.CUSTOM.getName());
        dateRange.setStartDate(startDate);
        dateRange.setEndDate(null);
    }

    protected void changedGroupDateType(ParameterCardDTO dto) {
        String groupDateType = (String)this.getModel().getValue(CTRL_RG_GROUP_DATETYPE);
        this.rangeDate(dto.getDateRange(), groupDateType);
        String datePattern = this.getGroupDatePattern(groupDateType);
        DataListVO listVO = ExpenseTrendDataHelper.loadData((ParameterCardDTO)dto, (String)datePattern);
        this.setDataVo(listVO);
    }

    private String getGroupDatePattern(String groupDateType) {
        if (GROUP_TYPE_YEAR.equals(groupDateType)) {
            return "yyyy";
        }
        return "yyyy-MM";
    }

    protected void setDataVo(DataListVO data) {
        this.validData(data.getDatas());
        this.setChart(data);
        this.setPanelList(data);
    }

    protected void validData(List<DataVO> datas) {
        List<DataVO> models = datas.stream().limit(6L).collect(Collectors.toList());
        if (this.allEmpty(models)) {
            this.setNoData(0, this.getNoDataTip());
        } else {
            this.setNoData(1);
        }
    }

    private void setChart(DataListVO data) {
        List<DataVO> models = data.getDatas().stream().limit(6L).collect(Collectors.toList());
        this.setTipsLabel(models);
        Chart chart = this.getChart();
        this.setChartMargin(chart);
        this.setLegend(chart);
        this.setTooltip(chart);
        this.setXAxis(chart, models);
        this.createBarSeries(chart, data, models);
        this.createLineSeries(chart, models);
        chart.refresh();
    }

    protected String getNoDataTip() {
        String groupDateType = (String)this.getModel().getValue(CTRL_RG_GROUP_DATETYPE);
        if (GROUP_TYPE_YEAR.equals(groupDateType)) {
            return ResManager.loadKDString((String)"\u8fc7\u53bb6\u5e74\u672a\u53d1\u751f\u8d39\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"ExpenseTrendPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8fc7\u53bb6\u6708\u672a\u53d1\u751f\u8d39\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"ExpenseTrendPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
    }

    protected boolean allEmpty(List<DataVO> models) {
        for (DataVO model : models) {
            if (model.getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
            return false;
        }
        return true;
    }

    private void createBarSeries(Chart chart, DataListVO data, List<DataVO> models) {
        BarSeries series = chart.createBarSeries(ResManager.loadKDString((String)"\u8d39\u7528\u91d1\u989d", (String)"ExpenseTrendPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        series.setPropValue("yAxisIndex", (Object)0);
        series.setBarWidth("18");
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#505BF9")));
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("show", (Object)Boolean.FALSE)));
        double max = BusinessDataHelper.getDataVoMax(models);
        UnitEnum maxUnitEnum = AmountHelper.get().getUnitEnum(max);
        for (IData iData : models) {
            iData.getSignAmount().revertToMaxUnit(maxUnitEnum);
        }
        List list = models.stream().map(DataVO::getSignAmount).collect(Collectors.toList());
        series.setPropValue("data", list);
        this.setYAxis(chart, maxUnitEnum.getDesc());
    }

    private void createLineSeries(Chart chart, List<DataVO> models) {
        LineSeries series = chart.createLineSeries(ResManager.loadKDString((String)"\u589e\u957f\u7387", (String)"ExpenseTrendPlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        series.setPropValue("yAxisIndex", (Object)1);
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#FFC13F")));
        List list = models.stream().map(DataVO::getIncrease).collect(Collectors.toList());
        series.setPropValue("data", list);
        this.setYAxis(chart, ResManager.loadKDString((String)"\u589e\u957f\u7387(%)", (String)"ExpenseTrendPlugin_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
    }

    protected void setTipsLabel(List<DataVO> models) {
        String content = models.stream().filter(vo -> vo.getValue().compareTo(BigDecimal.ZERO) == 0).map(DataVO::getItemname).sorted().collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)content)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CTRL_FLEX_TIPS});
            Label label_tip = (Label)this.getControl(CTRL_LABELED_TIPS);
            label_tip.setText(String.format(ResManager.loadKDString((String)"%s\u672a\u53d1\u751f\u8d39\u7528", (String)"ExpenseTrendPlugin_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), content));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_FLEX_TIPS});
        }
    }

    protected Chart getChart() {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        return chart;
    }

    protected void setChartMargin(Chart chart) {
        chart.setMargin(Position.top, "60px");
    }

    protected void setLegend(Chart chart) {
        chart.setShowLegend(true);
        chart.setLegendPropValue("left", (Object)"0%");
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
    }

    protected void setTooltip(Chart chart) {
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"axis");
        String text1 = ResManager.loadKDString((String)"\u8d39\u7528\u91d1\u989d", (String)"ExpenseTrendPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        String text2 = ResManager.loadKDString((String)"\u589e\u957f\u7387", (String)"ExpenseTrendPlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        String tooltipFormatter = "function(i) { var content = '" + text1 + "' + i[0].data.text + '<br />';  if(i[1].value===undefined){ content += '" + text2 + ": -'; }else{ content += '" + text2 + ": ' +  i[1].value +'%'; } return content;}";
        chart.addTooltip("formatter", (Object)tooltipFormatter);
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"tooltip", "formatter"}));
    }

    protected void setXAxis(Chart chart, List<DataVO> list) {
        Axis axis = chart.createXAxis("", AxisType.category);
        axis.setPropValue("inverse", (Object)Boolean.TRUE);
        axis.setPropValue("axisLabel", (Object)M.map().kv("interval", (Object)0).kv("rotate", (Object)-30).kv("color", (Object)"#999999"));
        axis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        axis.setPropValue("axisLine", (Object)M.map().kv("show", (Object)Boolean.FALSE).kv("lineStyle", map -> map.kv("color", (Object)"#999").kv("width", (Object)1)));
        List collect = list.stream().map(result -> M.map().kv("value", (Object)result.getItemname()).kv("textStyle", (Object)M.map((String)"fontSize", (Object)12))).collect(Collectors.toList());
        axis.setPropValue("data", collect);
    }

    protected void setYAxis(Chart chart, String yName) {
        Axis yAxis = chart.createYAxis(yName, AxisType.value);
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("align", (Object)"right").list("padding", new Object[]{0, -15, 0, 0}));
        yAxis.setPropValue("type", (Object)"value");
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", (Object)"dashed").kv("color", (Object)"#e8e8e8")));
        yAxis.setPropValue("axisLine", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        yAxis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
    }

    protected void setPanelList(DataListVO data) {
    }
}

