/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.overall.MainExpenseDataHelper;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataVO;

public class MainExpenseFormPlugin
extends CardTemplatePlugin {
    private static final String FROM_ID = "em_m_main_expense";
    private static final int[] SIZES = new int[]{70, 55, 55, 50, 50, 40, 40, 35, 35, 10};
    private static final int[] LOCATIONS = new int[]{5, 6, 4, 7, 3, 8, 2, 9, 1, 10};
    private static final String[] COLORS = new String[]{"#281198", "#CD393B", "#5BC071", "#AA206C", "#FC93D7", "#F91121", "#EF7F88", "#1E49DB", "#CDD89C", "#8C53BC"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DataChartListVO dataChartListVO = (DataChartListVO)ThreadCache.get((Object)FROM_ID);
        if (dataChartListVO == null || dataChartListVO.getDatas().isEmpty()) {
            return;
        }
        this.setPanelData(dataChartListVO);
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        DataChartListVO dataChartListVO = MainExpenseDataHelper.loadData((ParameterCardDTO)parameterDTO);
        List datas = dataChartListVO.getDatas();
        if (datas == null || datas.isEmpty()) {
            this.setNoData(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u671f\u95f4\u672a\u53d1\u751f\u8d39\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"MainExpenseFormPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        } else {
            ThreadCache.put((Object)FROM_ID, (Object)dataChartListVO);
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u4e3b\u8981\u8d39\u7528\u5206\u5e03\u60c5\u51b5", (String)"MainExpenseFormPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("title", CardEnum.MAIN_EXPENSES.getCaption());
        args.put("content", content);
        args.put("cellContent", content);
    }

    private void setPanelData(DataChartListVO dataChartListVO) {
        this.createScatterChart(dataChartListVO);
    }

    private void createScatterChart(DataChartListVO dataChartListVO) {
        List dataVOList = dataChartListVO.getDatas();
        HashMap<String, Object> chartData = new HashMap<String, Object>();
        List<Map<String, Object>> seriesData = this.processChartData(dataVOList);
        HashMap<String, String> gridMap = new HashMap<String, String>();
        gridMap.put("top", "10%");
        gridMap.put("right", "8%");
        gridMap.put("bottom", "8%");
        chartData.put("grid", gridMap);
        HashMap<String, Object> yAxisMap = new HashMap<String, Object>();
        yAxisMap.put("name", "y");
        yAxisMap.put("max", 10);
        yAxisMap.put("show", false);
        chartData.put("yAxis", yAxisMap);
        HashMap<String, Object> xAxisMap = new HashMap<String, Object>();
        xAxisMap.put("name", "x");
        xAxisMap.put("max", 10);
        xAxisMap.put("show", false);
        chartData.put("xAxis", xAxisMap);
        String amountStr = ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d\uff1a", (String)"MainExpenseFormPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        String countStr = ResManager.loadKDString((String)"\u62a5\u9500\u7b14\u6570\uff1a", (String)"MainExpenseFormPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        HashMap<String, Object> tooltipMap = new HashMap<String, Object>();
        tooltipMap.put("show", Boolean.TRUE);
        tooltipMap.put("position", "inside");
        tooltipMap.put("trigger", "item");
        tooltipMap.put("formatter", "function(i) {return  i.data.name + '<br />" + amountStr + "' + i.data.amountText + '<br />" + countStr + "' + i.data.countText;}");
        chartData.put("tooltip", tooltipMap);
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        labelMap.put("show", true);
        labelMap.put("color", "#000000");
        labelMap.put("formatter", "function (i) {return i.data.name;}");
        HashMap<String, Object> seriesMap = new HashMap<String, Object>();
        seriesMap.put("type", "scatter");
        seriesMap.put("data", seriesData);
        seriesMap.put("label", Collections.singletonMap("normal", labelMap));
        seriesMap.put("symbolSize", "function (data) {return data[2];}");
        chartData.put("series", seriesMap);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        ArrayList<String> seriesFuncPath = new ArrayList<String>();
        seriesFuncPath.add("series");
        seriesFuncPath.add("symbolSize");
        ArrayList<String> labelFuncPath = new ArrayList<String>();
        labelFuncPath.add("series");
        labelFuncPath.add("label");
        labelFuncPath.add("normal");
        labelFuncPath.add("formatter");
        chartData.put("functions", new Object[]{toolTipFuncPath, seriesFuncPath, labelFuncPath});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty("scatterchart", "data", chartData);
    }

    private List<Map<String, Object>> processChartData(List<DataVO> dataVOList) {
        Map itemMap;
        int i;
        List<Object> seriesData = new ArrayList(dataVOList.size());
        for (DataVO dataVO : dataVOList) {
            HashMap<String, Object> itemMap2 = new HashMap<String, Object>(10);
            itemMap2.put("name", dataVO.getItemname());
            itemMap2.put("amount", dataVO.getValue());
            itemMap2.put("count", dataVO.getCount());
            itemMap2.put("amountText", dataVO.getItemvalue());
            itemMap2.put("countText", dataVO.getItemvalue1());
            seriesData.add(itemMap2);
        }
        seriesData = seriesData.stream().sorted((m1, m2) -> -((BigDecimal)m1.get("amount")).compareTo((BigDecimal)m2.get("amount"))).collect(Collectors.toList());
        for (i = 0; i < seriesData.size(); ++i) {
            itemMap = (Map)seriesData.get(i);
            itemMap.put("xAxis", LOCATIONS[i]);
            itemMap.put("size", SIZES[i]);
            itemMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", COLORS[i])));
        }
        seriesData = seriesData.stream().sorted(Comparator.comparingLong(m -> (Long)m.get("count"))).collect(Collectors.toList());
        for (i = 0; i < seriesData.size(); ++i) {
            itemMap = (Map)seriesData.get(i);
            itemMap.put("yAxis", LOCATIONS[i]);
            itemMap.put("value", new Object[]{itemMap.get("xAxis"), itemMap.get("yAxis"), itemMap.get("size")});
        }
        return seriesData;
    }
}

