/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.UserParameterHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.LoanEnum;
import kd.fi.er.mobile.formplugin.template.AbstractDetailTemplatelugin;
import kd.fi.er.mobile.service.overall.NotRepaidLoanDataHelper;
import kd.fi.er.mobile.vo.RepaidLoanVO;

public class NotRepaidLoanDetailPlugin
extends AbstractDetailTemplatelugin {
    public static final String FORMID = "em_m_repaidloan_d_card";
    private static final String BTN_ALERT = "buttonalert";
    private static final String CTRL_TAB_AP = "tabap";
    private static final String KEY_ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ALERT});
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        tab.addTabSelectListener(evt -> this.switchTab(evt.getTabKey()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)BTN_ALERT, (CharSequence)key)) {
            this.btnAlert();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)BTN_ALERT) && MessageBoxResult.Yes.equals((Object)result)) {
            this.batchSendMessage();
        }
    }

    public void switchTab(String tabKey) {
        ParameterCardDTO dto = this.getParameter();
        this.loadDataByTabKey(tabKey, dto);
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        String currentTabKey = this.getCurrentTab();
        this.loadDataByTabKey(currentTabKey, dto);
    }

    private void loadDataByTabKey(String tabKey, ParameterCardDTO dto) {
        this.setAlertBtn(dto);
        List datas = NotRepaidLoanDataHelper.loadDataList((String)tabKey, (ParameterCardDTO)dto);
        if (datas.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ALERT});
            this.setNoData(0, this.getTipMessage());
        } else {
            this.setNoData(1);
        }
        this.setDataList(datas);
    }

    private String getTipMessage() {
        String currentTab = this.getCurrentTab();
        if (StringUtils.equals((CharSequence)currentTab, (CharSequence)LoanEnum.EXPIRED.getNumber())) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u5230\u671f\u7684\u672a\u8fd8\u5458\u5de5\u501f\u6b3e", (String)"NotRepaidLoanDetailPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)currentTab, (CharSequence)LoanEnum.DUE_SOON.getNumber())) {
            Integer dueValue = UserParameterHelper.getDueDate();
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728%s\u5929\u5185\u5230\u671f\u7684\u672a\u8fd8\u5458\u5de5\u501f\u6b3e", (String)"NotRepaidLoanDetailPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), dueValue);
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u672a\u5230\u671f\u7684\u672a\u8fd8\u5458\u5de5\u501f\u6b3e", (String)"NotRepaidLoanDetailPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
    }

    private void btnAlert() {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(BTN_ALERT, (IFormPlugin)this);
        this.getView().showConfirm(this.getAlertMessage(), MessageBoxOptions.OKCancel, listener);
    }

    private String getAlertMessage() {
        String currentTab = this.getCurrentTab();
        if (StringUtils.equals((CharSequence)currentTab, (CharSequence)LoanEnum.EXPIRED.getNumber())) {
            return ResManager.loadKDString((String)"\u662f\u5426\u5411\u5df2\u5230\u671f\u7684\u501f\u6b3e\u4eba\u53d1\u8d77\u6d88\u606f\u63d0\u9192\uff1f", (String)"NotRepaidLoanDetailPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)currentTab, (CharSequence)LoanEnum.DUE_SOON.getNumber())) {
            return ResManager.loadKDString((String)"\u662f\u5426\u5411\u5373\u5c06\u5230\u671f\u7684\u501f\u6b3e\u4eba\u53d1\u8d77\u6d88\u606f\u63d0\u9192\uff1f", (String)"NotRepaidLoanDetailPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void setAlertBtn(ParameterCardDTO dto) {
        String currentTab = this.getCurrentTab();
        if (StringUtils.equals((CharSequence)currentTab, (CharSequence)LoanEnum.NOT_DUE.getNumber())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ALERT});
            return;
        }
        Long shareUserid = dto.getShareUserid();
        Long userId = RequestContext.get().getCurrUserId();
        if (shareUserid != null && !shareUserid.equals(userId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ALERT});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ALERT});
    }

    private void batchSendMessage() {
        String expireSlot = this.getCurrentTab();
        boolean sendMessage = NotRepaidLoanDataHelper.batchSendMessage((String)expireSlot, (ParameterCardDTO)this.getParameter());
        if (sendMessage) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63d0\u9192\u53d1\u9001\u6210\u529f", (String)"NotRepaidLoanDetailPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63d0\u9192\u53d1\u9001\u5931\u8d25", (String)"NotRepaidLoanDetailPlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
    }

    private void setDataList(List<RepaidLoanVO> datas) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(KEY_ENTRY, "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(KEY_ENTRY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(KEY_ENTRY);
            DynamicProperty avatar = dynamicObjects.getDynamicObjectType().getProperty("avatar");
            DynamicProperty name = dynamicObjects.getDynamicObjectType().getProperty("name");
            DynamicProperty billNo = dynamicObjects.getDynamicObjectType().getProperty("billno");
            DynamicProperty dueDate = dynamicObjects.getDynamicObjectType().getProperty("duedate");
            DynamicProperty expenseAmount = dynamicObjects.getDynamicObjectType().getProperty("currexpenseamount");
            AmountHandler handler = AmountHelper.get();
            for (int i = 0; i < datas.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                RepaidLoanVO vo = datas.get(i);
                name.setValueFast((Object)dynamicObject, (Object)vo.getName());
                avatar.setValueFast((Object)dynamicObject, (Object)vo.getAvatar());
                billNo.setValueFast((Object)dynamicObject, (Object)vo.getBillNo());
                dueDate.setValueFast((Object)dynamicObject, (Object)vo.getRepaymentdate());
                expenseAmount.setValueFast((Object)dynamicObject, (Object)handler.getSignAmount(vo.getAmount()).getText());
            }
            model.endInit();
        }
        this.getView().updateView(KEY_ENTRY);
    }

    private String getCurrentTab() {
        return ((Tab)this.getControl(CTRL_TAB_AP)).getCurrentTab();
    }

    public static void jumpMeBy(IFormView formView, String parameterJson) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("unionparameter", (Object)parameterJson);
        formView.showForm((FormShowParameter)parameter);
    }
}

