/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.mobile.common.UserParameterHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.formplugin.overall.DueDateSettingPlugin;
import kd.fi.er.mobile.formplugin.overall.NotRepaidLoanDetailPlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.overall.NotRepaidLoanDataHelper;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataVO;

public class NotRepaidLoanPlugin
extends CardTemplatePlugin {
    private static final String BTN_CONFIG = "labelap_config";
    private static final String CTRL_PIECHART = "piechartap";
    private static final String ACTIONID_CONFIG = "actionid_config";
    private static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u5458\u5de5\u672a\u8fd8\u501f\u6b3e", (String)"NotRepaidLoanPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5230\u671f\u672a\u8fd8\u501f\u6b3e\u603b\u989d\uff1a%s", (String)"NotRepaidLoanPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    protected void onlyRead() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CONFIG});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIG});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)BTN_CONFIG, (CharSequence)optKey)) {
            DueDateSettingPlugin.jumpMeBy((AbstractFormPlugin)this, ACTIONID_CONFIG);
        }
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.refreshData(parameterDTO, UserParameterHelper.getDueDate());
    }

    @Override
    protected void btnDetail() {
        NotRepaidLoanDetailPlugin.jumpMeBy(this.getView(), this.getParameterJson());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (ACTIONID_CONFIG.equals(event.getActionId()) && event.getReturnData() != null) {
            String dueDate = event.getReturnData().toString();
            this.refreshData(this.getParameter(), Integer.parseInt(dueDate));
        }
    }

    private void refreshData(ParameterCardDTO dto, Integer dueDate) {
        DataChartListVO data = NotRepaidLoanDataHelper.loadData((ParameterCardDTO)dto, (Integer)dueDate);
        SignAmount totalAmount = data.getTotalAmount();
        this.setShareValue(data.getShareValue());
        if (totalAmount.getValue().compareTo(BigDecimal.ZERO) == 0) {
            this.setNoData(0);
        } else {
            this.setPanelData(data);
        }
    }

    private void setPanelData(DataChartListVO data) {
        this.setChart(data);
        this.createLegend(data);
        this.getView().updateView();
    }

    private void createLegend(DataChartListVO data) {
        List datas = data.getDatas();
        this.setNoData(datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            DataVO dataVO = (DataVO)datas.get(i);
            ((Label)this.getControl("pieitemqplabeln" + i)).setText(dataVO.getItemname());
            ((Label)this.getControl("pieitemqplabelv" + i)).setText(dataVO.getItemvalue());
        }
    }

    private void setChart(DataChartListVO data) {
        List datas = data.getDatas();
        SignAmount totalAmount = data.getTotalAmount();
        PieChart chart = this.initPieChart();
        PieSeries series = chart.createPieSeries("repaidloan");
        ArrayList<M> objects = new ArrayList<M>(datas.size());
        int i = 0;
        while (i < datas.size()) {
            DataVO dataVO = (DataVO)datas.get(i);
            int finalI = i++;
            objects.add(M.map().kv("name", (Object)dataVO.getItemname()).kv("value", (Object)dataVO.getValue()).kv("itemStyle", map -> map.kv("normal", (Object)M.map((String)"color", (Object)COLORS_PIECHARTS[finalI % 3]))));
        }
        series.setPropValue("data", objects);
        String text = ResManager.loadKDString((String)"\u603b\u989d", (String)"NotRepaidLoanPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", (Object)("[ '{a|" + text + "}', '{b|" + totalAmount.getText() + "}' ].join('\\n')")).kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", (Object)"#212121").kv("fontSize", (Object)"12")).kv("b", map2 -> map2.kv("color", (Object)"#276FF5").kv("fontSize", (Object)"12").kv("lineHeight", (Object)"20"))).kv("position", (Object)"center")).kv("show", (Object)Boolean.TRUE));
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.TRUE);
        series.addFuncPath(M.arraylist((Object[])new Object[]{"label", "normal", "formatter"}));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    private PieChart initPieChart() {
        PieChart pieChart = (PieChart)this.getControl(CTRL_PIECHART);
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        return pieChart;
    }
}

