/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateSpanWrapper;
import kd.fi.er.mobile.datarange.IDateRange;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.TotalExpenseCardDTO;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.formplugin.analyse.DynamicTemplateFormPlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.analyse.data.DynamicGroupTransferData;
import kd.fi.er.mobile.service.analyse.data.GroupDataModel;
import kd.fi.er.mobile.service.overall.TotalExpenseAnalysisDataProcessImpl;
import kd.fi.er.mobile.service.overall.TotalExpenseDataHelperService;

public class TotalExpenseFormPlugin
extends CardTemplatePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_detail"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_detail".contains(key)) {
            DynamicGroupTransferData transferData = new DynamicGroupTransferData();
            List groupBys = transferData.getGroupbys();
            groupBys.add(GroupDataModel.buildOf((String)"orgid"));
            transferData.setCardParameter(this.getParameter());
            transferData.setProcessClassName(TotalExpenseAnalysisDataProcessImpl.class.getName());
            DynamicTemplateFormPlugin.jumpMeBy(this.getView(), ResManager.loadKDString((String)"\u8d39\u7528\u5206\u5e03", (String)"TotalExpenseFormPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), transferData);
        }
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        Map billsMap = TotalExpenseDataHelperService.getAllBillsWithPermission((ParameterCardDTO)parameterDTO);
        TotalExpenseCardDTO compareTotalAmountAndCount = this.getTotalAmountAndCount(billsMap);
        BigDecimal currentTotalAmount = compareTotalAmountAndCount.getTotalAmount();
        int count = compareTotalAmountAndCount.getCount();
        if (count == 0) {
            this.setNoData(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u671f\u95f4\u672a\u53d1\u751f\u8d39\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"TotalExpenseFormPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setNoData(1);
        ((Label)this.getControl("reimbursement_amount")).setText(AmountHelper.getSignAmount((BigDecimal)currentTotalAmount).getText());
        ((Label)this.getControl("bill_number")).setText(count + "");
        this.getPageCache().put("CACHE_SHARE_VALUE", AmountHelper.text((BigDecimal)currentTotalAmount));
        DateSpanWrapper dateSpanWrapper = new DateSpanWrapper((IDateRange)parameterDTO.getDateRange());
        if (dateSpanWrapper.getDateType() == 1) {
            BigDecimal previousValue = this.getPreviousValue(parameterDTO, currentTotalAmount);
            this.setLabel("previous_value", previousValue, true);
            BigDecimal linkedValue = this.getLinkedValue(parameterDTO, currentTotalAmount);
            this.setLabel("linked_value", linkedValue, true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"previous_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"linked_panel"});
        } else if (dateSpanWrapper.getDateType() == 2) {
            BigDecimal linkedValue = this.getLinkedValue(parameterDTO, currentTotalAmount);
            this.setLabel("linked_value", linkedValue, true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"previous_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"linked_panel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"previous_panel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"linked_panel"});
        }
    }

    private BigDecimal getPreviousValue(ParameterCardDTO parameterDTO, BigDecimal currentTotalAmount) {
        DateSpanWrapper dateSpanWrapper = new DateSpanWrapper((IDateRange)parameterDTO.getDateRange());
        ParameterCardDTO previousParameterDTO = this.getCompareParameterDTO(parameterDTO.getOrgIds(), dateSpanWrapper.getPreviousStartDate(), dateSpanWrapper.getPreviousEndDate());
        Map compareBillsMap = TotalExpenseDataHelperService.getAllBillsWithPermission((ParameterCardDTO)previousParameterDTO);
        TotalExpenseCardDTO compareTotalAmountAndCount = this.getTotalAmountAndCount(compareBillsMap);
        return TotalExpenseDataHelperService.compareRatio((BigDecimal)currentTotalAmount, (BigDecimal)compareTotalAmountAndCount.getTotalAmount());
    }

    private BigDecimal getLinkedValue(ParameterCardDTO parameterDTO, BigDecimal currentTotalAmount) {
        DateSpanWrapper dateSpanWrapper = new DateSpanWrapper((IDateRange)parameterDTO.getDateRange());
        ParameterCardDTO previousParameterDTO = this.getCompareParameterDTO(parameterDTO.getOrgIds(), dateSpanWrapper.getLinkStartDate(), dateSpanWrapper.getLinkEndDate());
        Map compareBillsMap = TotalExpenseDataHelperService.getAllBillsWithPermission((ParameterCardDTO)previousParameterDTO);
        TotalExpenseCardDTO compareTotalAmountAndCount = this.getTotalAmountAndCount(compareBillsMap);
        return TotalExpenseDataHelperService.compareRatio((BigDecimal)currentTotalAmount, (BigDecimal)compareTotalAmountAndCount.getTotalAmount());
    }

    private ParameterCardDTO getCompareParameterDTO(List<Long> orgIds, LocalDate startDate, LocalDate endDate) {
        DateRange compareDateRange = new DateRange("", "", startDate, endDate);
        ParameterCardDTO compareParameterDTO = new ParameterCardDTO();
        compareParameterDTO.setOrgIds(orgIds);
        compareParameterDTO.setDateRange(compareDateRange);
        return compareParameterDTO;
    }

    private TotalExpenseCardDTO getTotalAmountAndCount(Map<String, DynamicObjectCollection> billsMap) {
        TotalExpenseCardDTO totalExpenseCardDTO = new TotalExpenseCardDTO();
        AmountHandler amountHandler = AmountHelper.get();
        BigDecimal currentTotalAmount = BigDecimal.ZERO;
        HashSet ids = new HashSet();
        for (DynamicObjectCollection bills : billsMap.values()) {
            BigDecimal amountsOfBillType = bills.stream().map(dy -> amountHandler.convertByCurrency(dy.getLong("currency"), dy.getBigDecimal("approveamount"))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            currentTotalAmount = currentTotalAmount.add(amountsOfBillType);
            ids.addAll(bills.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        }
        totalExpenseCardDTO.setTotalAmount(currentTotalAmount);
        totalExpenseCardDTO.setCount(ids.size());
        return totalExpenseCardDTO;
    }

    private void setLabel(String labelKey, BigDecimal ratio, boolean isColorReverse) {
        Label label_rate_tb = (Label)this.getView().getControl(labelKey);
        if (ratio != null) {
            BigDecimal ratio2 = ratio.multiply(new BigDecimal(100)).setScale(0, 4);
            String text = null;
            if (ratio2.compareTo(BigDecimal.ZERO) > 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                if (isColorReverse) {
                    ctrl.put("fc", "#FB2323");
                } else {
                    ctrl.put("fc", "#1BA854");
                }
                this.getView().updateControlMetadata(labelKey, ctrl);
                text = ratio2 + "% \u2191";
            } else if (ratio2.compareTo(BigDecimal.ZERO) < 0) {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                if (isColorReverse) {
                    ctrl.put("fc", "#1BA854");
                } else {
                    ctrl.put("fc", "#FB2323");
                }
                this.getView().updateControlMetadata(labelKey, ctrl);
                text = ratio2 + "% \u2193";
            } else {
                HashMap<String, String> ctrl = new HashMap<String, String>();
                ctrl.put("fc", "#666666");
                this.getView().updateControlMetadata(labelKey, ctrl);
                text = ratio2 + "%";
            }
            label_rate_tb.setText(text);
        } else {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", "#666666");
            this.getView().updateControlMetadata(labelKey, ctrl);
            label_rate_tb.setText("-");
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        String shareValue = this.getPageCache().get("CACHE_SHARE_VALUE");
        args.put("title", CardEnum.TOTAL_EXPENSES.getCaption() + "\uff1a" + (shareValue == null ? "\uffe50" : shareValue));
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8d39\u7528\u603b\u989d\u53ca\u5206\u5e03", (String)"TotalExpenseFormPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }
}

