/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.overall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.overall.TotalExpenseDataHelper;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataVO;

public class TotalExpenseNewFormPlugin
extends CardTemplatePlugin {
    private static final String CTRL_PIECHART = "piechartap";
    private static final String FEE_TOTAL_TIPS = "feetotaltips";
    private static final String APPROVALING_TIPS = "approvalingtips";
    private static final String TO_BE_PAID_TIPS = "tobepaidtips";
    private static final String COMPLETED_TIPS = "completedtips";
    private static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FEE_TOTAL_TIPS, APPROVALING_TIPS, TO_BE_PAID_TIPS, COMPLETED_TIPS});
    }

    @Override
    public void click(EventObject evt) {
        IFormView view;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)FEE_TOTAL_TIPS, (CharSequence)key)) {
            view = this.getView();
            PageUtils.showTip(view, ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d", (String)"TotalExpenseNewFormPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c47\u603b\u7edf\u8ba1\u8d39\u7528\u62a5\u9500\u5355\u3001\u5dee\u65c5\u62a5\u9500\u5355\u3001\u5bf9\u516c\u8d39\u7528\u62a5\u9500\u5355\u7684\u6838\u5b9a\u91d1\u989d", (String)"TotalExpenseNewFormPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)APPROVALING_TIPS, (CharSequence)key)) {
            view = this.getView();
            PageUtils.showTip(view, ResManager.loadKDString((String)"\u5ba1\u6279\u4e2d", (String)"TotalExpenseNewFormPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d\u5305\u62ec\uff1a\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u3001\u5ba1\u6838\u4e2d\u72b6\u6001\u7684\u5355\u636e", (String)"TotalExpenseNewFormPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)TO_BE_PAID_TIPS, (CharSequence)key)) {
            view = this.getView();
            PageUtils.showTip(view, ResManager.loadKDString((String)"\u5f85\u652f\u4ed8", (String)"TotalExpenseNewFormPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f85\u652f\u4ed8\u5305\u62ec\uff1a\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u4ed8\u91d1\u989d\u5927\u4e8e0\u7684\u5355\u636e\u3001\u7b49\u5f85\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e", (String)"TotalExpenseNewFormPlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)COMPLETED_TIPS, (CharSequence)key)) {
            view = this.getView();
            PageUtils.showTip(view, ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TotalExpenseNewFormPlugin_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u5305\u62ec\uff1a\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u4ed8\u91d1\u989d\u7b49\u4e8e0\u7684\u5355\u636e\u3001\u5df2\u4ed8\u6b3e\u7684\u5355\u636e\u3001\u5173\u95ed\u72b6\u6001\u7684\u5355\u636e", (String)"TotalExpenseNewFormPlugin_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        DataChartListVO dataChartListVO = TotalExpenseDataHelper.loadData((ParameterCardDTO)parameterDTO);
        String shareValue = dataChartListVO.getShareValue();
        this.setShareValue(shareValue);
        SignAmount totalAmount = dataChartListVO.getTotalAmount();
        if (totalAmount.getValue().compareTo(BigDecimal.ZERO) == 0) {
            this.setNoData(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u671f\u95f4\u672a\u53d1\u751f\u8d39\u7528\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"TotalExpenseNewFormPlugin_11", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        } else {
            this.setPanelData(dataChartListVO);
        }
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        String shareValue = this.getPageCache().get("CACHE_SHARE_VALUE");
        args.put("title", CardEnum.TOTAL_EXPENSES.getCaption() + "\uff1a" + (shareValue == null ? "\uffe50" : shareValue));
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8d39\u7528\u603b\u989d\u53ca\u5206\u5e03", (String)"TotalExpenseNewFormPlugin_9", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    private void setPanelData(DataChartListVO datas) {
        this.createLegend(datas);
        this.createPieChart(datas);
        this.getView().updateView();
    }

    private void createLegend(DataChartListVO data) {
        List datas = data.getDatas();
        datas.forEach(dataVO -> {
            String feeStatus = dataVO.getItemname();
            String percentText = dataVO.getItemvalue();
            String amountText = dataVO.getItemvalue1();
            if (StringUtils.equals((CharSequence)"A", (CharSequence)feeStatus)) {
                ((Label)this.getControl("pieitemqplabeln0")).setText(percentText);
                ((Label)this.getControl("pieitemqplabelv0")).setText(amountText);
            } else if (StringUtils.equals((CharSequence)"B", (CharSequence)feeStatus)) {
                ((Label)this.getControl("pieitemqplabeln1")).setText(percentText);
                ((Label)this.getControl("pieitemqplabelv1")).setText(amountText);
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)feeStatus)) {
                ((Label)this.getControl("pieitemqplabeln2")).setText(percentText);
                ((Label)this.getControl("pieitemqplabelv2")).setText(amountText);
            }
        });
    }

    private void createPieChart(DataChartListVO data) {
        List datas = data.getDatas();
        SignAmount totalAmount = data.getTotalAmount();
        PieChart chart = this.initPieChart();
        PieSeries series = chart.createPieSeries("repaidloan");
        ArrayList<M> objects = new ArrayList<M>(datas.size());
        int i = 0;
        while (i < datas.size()) {
            DataVO dataVO = (DataVO)datas.get(i);
            int finalI = i++;
            objects.add(M.map().kv("name", (Object)dataVO.getItemname()).kv("value", (Object)dataVO.getValue()).kv("itemStyle", map -> map.kv("normal", (Object)M.map((String)"color", (Object)COLORS_PIECHARTS[finalI % 3]))));
        }
        series.setPropValue("data", objects);
        String text = ResManager.loadKDString((String)"\u603b\u989d", (String)"TotalExpenseNewFormPlugin_10", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", (Object)("[ '{a|" + text + "}', '{b|" + totalAmount.getText() + "}' ].join('\\n')")).kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", (Object)"#212121").kv("fontSize", (Object)"12")).kv("b", map2 -> map2.kv("color", (Object)"#276FF5").kv("fontSize", (Object)"12").kv("lineHeight", (Object)"20"))).kv("position", (Object)"center")).kv("show", (Object)Boolean.TRUE));
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.TRUE);
        series.addFuncPath(M.arraylist((Object[])new Object[]{"label", "normal", "formatter"}));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    private PieChart initPieChart() {
        PieChart pieChart = (PieChart)this.getControl(CTRL_PIECHART);
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        return pieChart;
    }
}

