/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.personal;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeEnum;
import kd.fi.er.mobile.datarange.IDateRange;
import kd.fi.er.mobile.datarange.UseSingleDateRangeMobPlugin;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.SubjectEnum;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.util.JsonUtils;

public class IndexPersonalPlugin
extends UseSingleDateRangeMobPlugin {
    public static final Log logger = LogFactory.getLog(IndexPersonalPlugin.class);
    public static final String FORMID = "em_m_index_personal";
    protected static final String CTRL_CARD_COMTAINER = "cardcontainer";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildCard(this.getFormIds());
    }

    @Override
    protected void dateRangeChange(IDateRange dateRange) {
        this.rebuildCard();
    }

    @Override
    protected DateRange getInitDateRange() {
        DateRange dateRange = new DateRange();
        dateRange.setSpanType(DateRangeEnum.CUSTOM.getNumber());
        dateRange.setStartDate(LocalDate.now().minusMonths(5L).with(TemporalAdjusters.firstDayOfMonth()));
        dateRange.setEndDate(LocalDate.now().with(TemporalAdjusters.lastDayOfMonth()));
        return DateRangeEnum.fillDateRange((IDateRange)dateRange);
    }

    @Override
    protected IPageCache getSaveDatePagecache() {
        IFormView indexView = PageUtils.getTargetPageView(this.getView(), "em_m_index");
        if (indexView != null) {
            return indexView.getPageCache();
        }
        return super.getSaveDatePagecache();
    }

    @Override
    protected String getCacheKey() {
        return "em_m_index_personalCACHE_DATE_RANGE_0";
    }

    protected void buildCard(String cards) {
        this.buildCard(cards, JsonUtils.toJson((Object)this.getParameterCardDTO()));
    }

    protected void buildCard(String cards, String parameterDto) {
        Container cardcontainer = (Container)this.getView().getControl(CTRL_CARD_COMTAINER);
        if (StringUtils.isNotEmpty((CharSequence)cards)) {
            String[] cardsArr = cards.split(",");
            cardcontainer.deleteControls(cardsArr);
            FlexPanelAp flex = new FlexPanelAp();
            flex.setGrow(0);
            flex.setShrink(0);
            flex.setRadius("8px");
            for (String formId : cardsArr) {
                flex.setKey(formId);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.addControls(list);
                this.addCard(formId, parameterDto);
            }
        }
    }

    protected void addCard(String formId, String parameterDto) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(formId);
        showParameter.setCustomParam("unionparameter", (Object)parameterDto);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void rebuildCard() {
        this.buildCard(this.getFormIds());
    }

    protected String getFormIds() {
        return SubjectEnum.PERSONAL.getFormIds();
    }

    protected ParameterCardDTO getParameterCardDTO() {
        ParameterCardDTO cardDTO = new ParameterCardDTO();
        cardDTO.setDateRange(this.getDateRange());
        return cardDTO;
    }
}

