/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.personal;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.template.AbstractDetailTemplatelugin;
import kd.fi.er.mobile.service.personal.PersonNotRepaidLoanDataHelper;
import kd.fi.er.mobile.vo.RepaidLoanVO;

public class PersonNotRepaidLoanDetailPlugin
extends AbstractDetailTemplatelugin
implements RowClickEventListener {
    private static final String KEY_ENTRY = "entryentity";
    private static final String FORMID = "em_m_per_notpaid_detail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl(KEY_ENTRY);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.initializeDataList(parameterDTO);
    }

    private void initializeDataList(ParameterCardDTO parameterDTO) {
        List repaidLoanVOS = PersonNotRepaidLoanDataHelper.loadData((ParameterCardDTO)parameterDTO).stream().filter(dto -> dto.getAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repaidLoanVOS)) {
            this.setNoData(0);
            return;
        }
        this.setNoData(1);
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(KEY_ENTRY, "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        int size = repaidLoanVOS.size();
        model.beginInit();
        model.batchCreateNewEntryRow(KEY_ENTRY, size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty avatar = dynamicObjects.getDynamicObjectType().getProperty("avatar");
        DynamicProperty name = dynamicObjects.getDynamicObjectType().getProperty("name");
        DynamicProperty billEntity = dynamicObjects.getDynamicObjectType().getProperty("billEntity");
        DynamicProperty mobBillEntity = dynamicObjects.getDynamicObjectType().getProperty("mobBillEntity");
        DynamicProperty itemleft1 = dynamicObjects.getDynamicObjectType().getProperty("itemleft1");
        DynamicProperty itemleft2 = dynamicObjects.getDynamicObjectType().getProperty("itemleft2");
        DynamicProperty itemright1 = dynamicObjects.getDynamicObjectType().getProperty("itemright1");
        AmountHandler handler = AmountHelper.get();
        for (int i = 0; i < repaidLoanVOS.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            RepaidLoanVO vo = (RepaidLoanVO)repaidLoanVOS.get(i);
            name.setValueFast((Object)dynamicObject, (Object)vo.getName());
            billEntity.setValueFast((Object)dynamicObject, (Object)vo.getBillEntity());
            mobBillEntity.setValueFast((Object)dynamicObject, (Object)vo.getMobBillEntity());
            avatar.setValueFast((Object)dynamicObject, (Object)vo.getAvatar());
            itemleft1.setValueFast((Object)dynamicObject, (Object)vo.getBillNo());
            itemleft2.setValueFast((Object)dynamicObject, (Object)vo.getRepaymentdate());
            itemright1.setValueFast((Object)dynamicObject, (Object)handler.getSignAmount(vo.getAmount()).getText());
        }
        model.endInit();
        this.getView().updateView(KEY_ENTRY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_ENTRY.equals(key) && this.getParameter().getShareUserid() == null) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(KEY_ENTRY).get(currIndex);
            String billno = dynamicObject.getString("itemleft1");
            String billEntity = dynamicObject.getString("billEntity");
            String mobBillEntity = dynamicObject.getString("mobBillEntity");
            List pks = QueryServiceHelper.queryPrimaryKeys((String)billEntity, (QFilter[])new QFilter("billno", "in", (Object)billno).toArray(), null, (int)1);
            if (!pks.isEmpty()) {
                Object pkId = pks.get(0);
                MobileBillShowParameter parameter = new MobileBillShowParameter();
                parameter.setFormId(mobBillEntity);
                parameter.setPkId(pkId);
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public static void jumpMeBy(IFormView formView, String parameterJson) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("unionparameter", (Object)parameterJson);
        formView.showForm((FormShowParameter)parameter);
    }
}

