/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.personal;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.personal.PersonNotRepaidLoanDetailPlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.personal.PersonNotRepaidLoanDataHelper;
import kd.fi.er.mobile.vo.RepaidLoanVO;

public class PersonNotRepaidLoanPlugin
extends CardTemplatePlugin {
    @Override
    protected boolean canAddHome() {
        return false;
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.initializeCard(parameterDTO);
    }

    private void initializeCard(ParameterCardDTO parameterDTO) {
        RepaidLoanVO repaidLoanVO;
        List repaidLoanVOS = PersonNotRepaidLoanDataHelper.loadData((ParameterCardDTO)parameterDTO);
        if (CollectionUtils.isEmpty((Collection)repaidLoanVOS)) {
            this.setNoData(0, ResManager.loadKDString((String)"\u5f53\u524d\u672a\u53d1\u751f\u501f\u6b3e", (String)"PersonNotRepaidLoanPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        List filterRepaidLoanVOS = repaidLoanVOS.stream().filter(dto -> dto.getAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (filterRepaidLoanVOS.size() == 0) {
            this.setNoData(0, ResManager.loadKDString((String)"\u5f53\u524d\u7684\u501f\u6b3e\u5747\u5df2\u8fd8\u6b3e\u6216\u6838\u9500", (String)"PersonNotRepaidLoanPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setNoData(1);
        AmountHandler handler = AmountHelper.get((AmountConvertDTO)parameterDTO.getConvertDTO());
        BigDecimal totalNotRepaidAmount = filterRepaidLoanVOS.stream().map(RepaidLoanVO::getAmount).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO);
        Label totalAmountLabel = (Label)this.getControl("total_amount");
        totalAmountLabel.setText(handler.getSignAmount(totalNotRepaidAmount).getText());
        Label totalCountLabel = (Label)this.getControl("total_count");
        totalCountLabel.setText(String.format(ResManager.loadKDString((String)"%s\u7b14", (String)"PersonNotRepaidLoanPlugin_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), filterRepaidLoanVOS.size()));
        BigDecimal recentlyAmount = BigDecimal.ZERO;
        String recentlyDateStr = ((RepaidLoanVO)filterRepaidLoanVOS.get(0)).getRepaymentdate();
        Iterator iterator = filterRepaidLoanVOS.iterator();
        while (iterator.hasNext() && recentlyDateStr.equals((repaidLoanVO = (RepaidLoanVO)iterator.next()).getRepaymentdate())) {
            recentlyAmount = recentlyAmount.add(repaidLoanVO.getAmount());
        }
        Label recentlyAmountLabel = (Label)this.getControl("recently_amount");
        recentlyAmountLabel.setText(handler.getSignAmount(recentlyAmount).getText());
        Label recentlyDate = (Label)this.getControl("recently_date");
        recentlyDate.setText(String.format(ResManager.loadKDString((String)"\u5230\u671f\u65e5\uff1a%s", (String)"PersonNotRepaidLoanPlugin_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), recentlyDateStr));
    }

    @Override
    protected void btnDetail() {
        PersonNotRepaidLoanDetailPlugin.jumpMeBy(this.getView(), this.getParameterJson());
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u6211\u7684\u672a\u8fd8\u501f\u6b3e", (String)"PersonNotRepaidLoanPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u6211\u7684\u672a\u8fd8\u501f\u6b3e", (String)"PersonNotRepaidLoanPlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }
}

