/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.personal;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.template.DetailTemplatelugin;
import kd.fi.er.mobile.service.personal.PersonalExpenseDetailDataHelper;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;

public class PersonalExpenseDetailPlugin
extends DetailTemplatelugin
implements RowClickEventListener {
    public static final String FORMID = "em_m_personal_expense_d";
    private static final String LABEL_COUNT = "labelcount";
    private static final String LABEL_AMOUNT = "labelamount";
    protected static final String CTRL_TAB_AP = "tabap";
    private static final String KEY_ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        tab.addTabSelectListener(evt -> this.switchTab(evt.getTabKey()));
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY);
        entryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent event) {
                String fieldName = event.getFieldName();
                if ("name".equals(fieldName)) {
                    DynamicObjectCollection dynamicObjects = PersonalExpenseDetailPlugin.this.getModel().getEntryEntity(PersonalExpenseDetailPlugin.KEY_ENTRY);
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(event.getRowIndex());
                    PersonalExpenseDetailPlugin.this.jumpWorkFlowDetail(dynamicObject.getLong("pkid"));
                }
            }
        });
        CardEntry entryentity = (CardEntry)this.getControl(KEY_ENTRY);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    private void jumpWorkFlowDetail(Object pkId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("em_m_workflow_detail");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6838\u4fe1\u606f\u8be6\u60c5", (String)"PersonalExpenseDetailPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("bussinessKey", (Object)(pkId + ""));
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        String currentTabKey = this.getCurrentTab();
        this.loadDataByTabKey(currentTabKey, dto);
    }

    private String getCurrentTab() {
        return ((Tab)this.getControl(CTRL_TAB_AP)).getCurrentTab();
    }

    public void switchTab(String tabKey) {
        ParameterCardDTO dto = this.getParameter();
        this.loadDataByTabKey(tabKey, dto);
    }

    private void loadDataByTabKey(String tabKey, ParameterCardDTO dto) {
        DataListVO data = PersonalExpenseDetailDataHelper.loadListData((String)tabKey, (ParameterCardDTO)dto);
        String countStr = data.getExt("countStr") + "";
        String amountStr = data.getExt("totalAmountStr") + "";
        this.setHeaderLabel(countStr, amountStr);
        this.getModel().setValue("tabkey", (Object)tabKey);
        this.setDataList(data.getDatas());
    }

    private void setHeaderLabel(String countStr, String amountStr) {
        Label label_count = (Label)this.getControl(LABEL_COUNT);
        Label label_amount = (Label)this.getControl(LABEL_AMOUNT);
        label_count.setText(countStr);
        label_amount.setText(amountStr);
    }

    private void setDataList(List<DataVO> datas) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(KEY_ENTRY, "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(KEY_ENTRY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(KEY_ENTRY);
            DynamicProperty pkid = dynamicObjects.getDynamicObjectType().getProperty("pkid");
            DynamicProperty itemleft1 = dynamicObjects.getDynamicObjectType().getProperty("itemleft1");
            DynamicProperty itemleft2 = dynamicObjects.getDynamicObjectType().getProperty("itemleft2");
            DynamicProperty avatar = dynamicObjects.getDynamicObjectType().getProperty("avatar");
            DynamicProperty name = dynamicObjects.getDynamicObjectType().getProperty("name");
            DynamicProperty billtype = dynamicObjects.getDynamicObjectType().getProperty("billtype");
            DynamicProperty itemright1 = dynamicObjects.getDynamicObjectType().getProperty("itemright1");
            DynamicProperty itemright2 = dynamicObjects.getDynamicObjectType().getProperty("itemright2");
            for (int i = 0; i < datas.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DataVO vo = datas.get(i);
                pkid.setValueFast((Object)dynamicObject, (Object)vo.getItemId());
                billtype.setValueFast((Object)dynamicObject, vo.getExt("billtype"));
                itemleft1.setValueFast((Object)dynamicObject, (Object)vo.getItemname());
                itemleft2.setValueFast((Object)dynamicObject, (Object)vo.getItemvalue1());
                avatar.setValueFast((Object)dynamicObject, (Object)vo.getItempre1());
                name.setValueFast((Object)dynamicObject, (Object)vo.getItempre2());
                itemright1.setValueFast((Object)dynamicObject, (Object)vo.getItemvalue());
                itemright2.setValueFast((Object)dynamicObject, (Object)vo.getItemvalue2());
            }
            model.endInit();
        }
        this.getView().updateView(KEY_ENTRY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_ENTRY.equals(key) && this.getParameter().getShareUserid() == null) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(KEY_ENTRY).get(currIndex);
            String pkid = dynamicObject.getString("pkid");
            String billtype = dynamicObject.getString("billtype");
            if (StringUtils.isNotEmpty((CharSequence)pkid) && StringUtils.isNotEmpty((CharSequence)billtype)) {
                String formId;
                if ("er_dailyreimbursebill".equals(billtype)) {
                    formId = "er_dailyreimbursebill_mob";
                } else if ("er_tripreimbursebill".equals(billtype)) {
                    formId = "er_tripreimbursebill_mob";
                } else {
                    return;
                }
                MobileBillShowParameter parameter = new MobileBillShowParameter();
                parameter.setFormId(formId);
                parameter.setPkId((Object)pkid);
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public static void jumpMeBy(IFormView formView, String parameterJson) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("unionparameter", (Object)parameterJson);
        formView.showForm((FormShowParameter)parameter);
    }
}

