/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.personal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.personal.PersonalExpenseDetailPlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.personal.PersonalExpenseDataHelper;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;

public class PersonalExpensePlugin
extends CardTemplatePlugin {
    private static final String CTRL_TITLE_TIPS = "titletips";
    private static final String CTRL_PIECHART = "piechartap";
    private static final String CTRL_LABEL_TIPS1 = "labeltip1";
    private static final String[] COLORS_PIECHARTS = new String[]{"#276FF5", "#26C9C3", "#95DE64", "#FFC53D"};

    @Override
    protected boolean canAddHome() {
        return false;
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u6211\u7684\u4e2a\u4eba\u8d39\u7528", (String)"PersonalExpensePlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = this.getShareContent(ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u6211\u7684\u62a5\u9500\u8fdb\u5ea6", (String)"PersonalExpensePlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_TITLE_TIPS});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_TITLE_TIPS, (CharSequence)key)) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u6211\u7684\u4e2a\u4eba\u8d39\u7528", (String)"PersonalExpensePlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u4eba\u7533\u8bf7\u4e14\u672c\u4eba\u6536\u6b3e\u7684\u8d39\u7528\u62a5\u9500\u5355\u3001\u5dee\u65c5\u62a5\u9500\u5355", (String)"PersonalExpensePlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.refreshData(parameterDTO);
    }

    @Override
    protected void btnDetail() {
        PersonalExpenseDetailPlugin.jumpMeBy(this.getView(), this.getParameterJson());
    }

    private void refreshData(ParameterCardDTO dto) {
        DataChartListVO data = PersonalExpenseDataHelper.loadData((ParameterCardDTO)dto);
        SignAmount totalAmount = data.getTotalAmount();
        this.setShareValue(data.getShareValue());
        if (totalAmount.getValue().compareTo(BigDecimal.ZERO) == 0) {
            this.setNoData(0);
        } else {
            this.setNoData(1);
            this.setPanelData(data);
            this.setTipsLabel((DataListVO)data);
        }
    }

    protected void setTipsLabel(DataListVO data) {
        String tips1 = data.getSuggest();
        if (StringUtils.isNotEmpty((CharSequence)tips1)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CTRL_LABEL_TIPS1});
            Label label_tip1 = (Label)this.getControl(CTRL_LABEL_TIPS1);
            label_tip1.setText(tips1);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_LABEL_TIPS1});
        }
    }

    private void setPanelData(DataChartListVO data) {
        this.setChart(data);
        this.createLegend(data);
        this.getView().updateView();
    }

    private void createLegend(DataChartListVO data) {
        List datas = data.getDatas();
        this.setNoData(datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            DataVO dataVO = (DataVO)datas.get(i);
            ((Label)this.getControl("pieitemqplabeln" + i)).setText(dataVO.getItemname());
            ((Label)this.getControl("pieitemqplabelv" + i)).setText(dataVO.getItemvalue());
        }
    }

    private void setChart(DataChartListVO data) {
        List datas = data.getDatas();
        SignAmount totalAmount = data.getTotalAmount();
        PieChart chart = this.initPieChart();
        PieSeries series = chart.createPieSeries("repaidloan");
        ArrayList<M> objects = new ArrayList<M>(datas.size());
        int i = 0;
        while (i < datas.size()) {
            DataVO dataVO = (DataVO)datas.get(i);
            int finalI = i++;
            objects.add(M.map().kv("name", (Object)dataVO.getItemname()).kv("value", (Object)dataVO.getValue()).kv("itemStyle", map -> map.kv("normal", (Object)M.map((String)"color", (Object)COLORS_PIECHARTS[finalI % 3]))));
        }
        series.setPropValue("data", objects);
        String text = ResManager.loadKDString((String)"\u603b\u989d", (String)"PersonalExpensePlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("formatter", (Object)("[ '{a|" + text + "}', '{b|" + totalAmount.getText() + "}' ].join('\\n')")).kv("rich", map1 -> map1.kv("a", map2 -> map2.kv("color", (Object)"#212121").kv("fontSize", (Object)"12")).kv("b", map2 -> map2.kv("color", (Object)"#276FF5").kv("fontSize", (Object)"12").kv("lineHeight", (Object)"20"))).kv("position", (Object)"center")).kv("show", (Object)Boolean.TRUE));
        series.setPropValue("avoidLabelOverlap", (Object)Boolean.FALSE);
        series.setPropValue("silent", (Object)Boolean.TRUE);
        series.addFuncPath(M.arraylist((Object[])new Object[]{"label", "normal", "formatter"}));
        series.setRadius("48%", "80%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
    }

    private PieChart initPieChart() {
        PieChart pieChart = (PieChart)this.getControl(CTRL_PIECHART);
        pieChart.clearData();
        pieChart.setShowTooltip(false);
        pieChart.setShowLegend(false);
        return pieChart;
    }
}

