/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.setting;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.service.setting.CardSettingBussinessHelper;
import kd.fi.er.mobile.service.setting.ExtendSettingBussinessHelper;
import kd.fi.er.mobile.util.JsonUtils;

public class ExtendBillSettingPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    public static final String FORMID = "em_m_setting_extendbill";
    private static final String BTN_REFRESH_FIELD_MAP = "refreshtarget";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_REFRESH_FIELD_MAP});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setStandardEntity();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshConfigMap();
    }

    private void setStandardEntity() {
        Set<String> standardEntitys = CardSettingBussinessHelper.getStandardConfigMaps().keySet();
        List<ComboItem> comboItems = ExtendBillSettingPlugin.revertComboItems(standardEntitys);
        ComboEdit combo = (ComboEdit)this.getControl("standardentity");
        combo.setComboItems(comboItems);
    }

    protected static List<ComboItem> revertComboItems(Collection<String> standardEntitys) {
        return standardEntitys.stream().map(entity -> new ComboItem(new LocaleString(entity), entity)).collect(Collectors.toList());
    }

    private ConfigMap getExtendsConfigMap() {
        Object value = this.getModel().getValue("extendconfig");
        if (StringUtils.isNotBlank((Object)value)) {
            return (ConfigMap)JsonUtils.fromJson((String)value.toString(), ConfigMap.class);
        }
        return new ConfigMap();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)dataEntity.get("configmap");
            ConfigMap configMap = new ConfigMap();
            configMap.setEntity((String)this.getModel().getValue("mapentity"));
            configMap.setStanderdEntity((String)this.getModel().getValue("standardentity"));
            for (DynamicObject dynamicObject : dynamicObjects) {
                configMap.put((Object)dynamicObject.getString("standardfield"), (Object)dynamicObject.getString("mapfield"));
            }
            this.getModel().setValue("extendconfig", (Object)JsonUtils.toJson((Object)configMap));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.refreshConfigMap();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_REFRESH_FIELD_MAP.equals(key)) {
            this.refreshConfigMap();
        }
    }

    private void refreshConfigMap() {
        String standardentity;
        IDataModel model = this.getModel();
        if (model.getEntryRowEntity("configmap", 0) != null) {
            model.deleteEntryData("configmap");
        }
        if (StringUtils.isNotBlank((CharSequence)(standardentity = (String)model.getValue("standardentity")))) {
            ConfigMap configMap = ExtendSettingBussinessHelper.getStandardConfigMap((String)standardentity);
            configMap.putAll((Map)this.getExtendsConfigMap());
            Set entries = configMap.mapEntrySet();
            for (Map.Entry entry : entries) {
                int newEntryRow = model.createNewEntryRow("configmap");
                model.setValue("standardfield", entry.getKey(), newEntryRow);
                model.setValue("mapfield", entry.getValue(), newEntryRow);
            }
        }
    }
}

