/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.CustomCtrlPropHelper;
import kd.fi.er.mobile.common.SystemParameterHelper;
import kd.fi.er.mobile.common.UserParameterHelper;
import kd.fi.er.mobile.common.UserShareLogDao;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.ShareParameterCardDTO;
import kd.fi.er.mobile.exception.ErMobiException;
import kd.fi.er.mobile.exception.ErMobiNoExchangeRateException;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.util.JsonUtils;

public abstract class CardTemplatePlugin
extends AbstractMobFormPlugin {
    public static final Log logger = LogFactory.getLog(CardTemplatePlugin.class);
    private static final String CONTROLID_CC_POPOVER = "cc_icon_popover";
    private static final String RUN_ON_PLATFORM = "RUN_ON_PLATFORM";
    private static final String POPOVER_MENU_CARD_MANAGER = "CARD_MANAGER";
    private static final String POPOVER_MENU_SHARE = "SHARE";
    private static final String CARD_MANAGER_CP_REMOVE = "REMOVE";
    private static final String CARD_MANAGER_CP_ADD = "ADD";
    protected static final String CACHE_SHARE_VALUE = "CACHE_SHARE_VALUE";
    protected static final String NO_DATA_TAG = "datatag";
    protected static final String BTN_DETAIL = "btn_detail";

    public abstract void loadData(ParameterCardDTO var1);

    protected void btnDetail() {
    }

    protected void onlyRead() {
    }

    protected boolean canAddHome() {
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DETAIL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ParameterCardDTO cardDTO = this.getParameter();
        Long shareUserid = cardDTO.getShareUserid();
        if (shareUserid != null) {
            long currUserId = RequestContext.get().getCurrUserId();
            if (!String.valueOf(shareUserid).equals(String.valueOf(currUserId))) {
                this.onlyRead();
            }
        }
        AmountHelper.cacheAmountConvert((AmountConvertDTO)cardDTO.getConvertDTO());
        try {
            this.loadData(cardDTO);
        }
        catch (ErMobiNoExchangeRateException ex) {
            this.setNoExchangeRateTips(ex.getAbsentCurrencies());
        }
        catch (ErMobiException ex) {
            this.setNoData(ex.getMessage());
        }
    }

    public void callNoExchangeRate(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ErMobiNoExchangeRateException ex) {
            this.setNoExchangeRateTips(ex.getAbsentCurrencies());
        }
        catch (ErMobiException ex) {
            this.setNoData(ex.getMessage());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)BTN_DETAIL, (CharSequence)key)) {
            this.btnDetail();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        if (CONTROLID_CC_POPOVER.equals(key) && "click".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            Map popoverInfo = JsonUtils.fromJsonToMap((String)eventArgs);
            String id = popoverInfo.getOrDefault("id", "");
            if (id.equals(POPOVER_MENU_CARD_MANAGER)) {
                String params = popoverInfo.getOrDefault("customer_params", "");
                if (CARD_MANAGER_CP_ADD.equals(params)) {
                    this.addCard(this.getView().getFormShowParameter().getFormId());
                } else if (CARD_MANAGER_CP_REMOVE.equals(params)) {
                    this.removeCard(this.getView().getFormShowParameter().getFormId());
                }
            } else if (id.equals(POPOVER_MENU_SHARE)) {
                this.shareTo();
            }
        } else if (CONTROLID_CC_POPOVER.equals(key) && "PlatformInfo".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            Map platformInfo = JsonUtils.fromJsonToMap((String)eventArgs);
            String platformId = platformInfo.getOrDefault("platformId", "");
            this.getPageCache().put(RUN_ON_PLATFORM, platformId);
            this.customPopoverMenu(platformId, null);
        }
    }

    protected void setNoData(int dataTag, String tip) {
        this.getModel().setValue(NO_DATA_TAG, (Object)dataTag);
        if (tip != null) {
            Label defaultlabel = (Label)this.getControl("defaultlabel");
            defaultlabel.setText(tip);
        }
    }

    protected void setNoData(int dataTag) {
        this.setNoData(dataTag, null);
    }

    protected void setNoData(String tip) {
        this.setNoData(0, tip);
    }

    protected void setNoExchangeRateTips(List<String> absentCurrencies) {
        this.setNoData(CommonUtils.createNoExchangeRateTips(absentCurrencies));
    }

    protected void customPopoverMenu(String platformId, String customCards) {
        ArrayList<LinkedHashMap<String, String>> menus = new ArrayList<LinkedHashMap<String, String>>();
        Object isShare = this.getView().getFormShowParameter().getCustomParam("CARD_IS_SHARE");
        if (!"true".equals(isShare)) {
            if ("yzj".equals(platformId)) {
                menus.add(this.createMenu(POPOVER_MENU_SHARE, ResManager.loadKDString((String)"\u5206\u4eab", (String)"CardTemplatePlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), "cp"));
            }
            if (this.canAddHome()) {
                if (customCards == null) {
                    customCards = UserParameterHelper.getCustomCard();
                }
                if (customCards != null && customCards.contains(this.getView().getFormShowParameter().getFormId())) {
                    menus.add(this.createMenu(POPOVER_MENU_CARD_MANAGER, ResManager.loadKDString((String)"\u79fb\u51fa\u9996\u9875", (String)"CardTemplatePlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), CARD_MANAGER_CP_REMOVE));
                } else {
                    menus.add(this.createMenu(POPOVER_MENU_CARD_MANAGER, ResManager.loadKDString((String)"\u653e\u5230\u9996\u9875", (String)"CardTemplatePlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), CARD_MANAGER_CP_ADD));
                }
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menus", menus);
        data.put("datetime", String.valueOf(new Date().getTime()));
        CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), CONTROLID_CC_POPOVER, data, Boolean.FALSE);
    }

    private LinkedHashMap<String, String> createMenu(String id, String name, String cp) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", id);
        map.put("name", name);
        map.put("customer_params", cp);
        return map;
    }

    private void addCard(String formId) {
        String customCards = UserParameterHelper.getCustomCard();
        if (StringUtils.isBlank((CharSequence)customCards)) {
            UserParameterHelper.saveCustomCard((String)formId);
            this.refreshCustomPopover(formId);
        } else {
            String[] split = customCards.split(",");
            List strings = Arrays.stream(split).collect(Collectors.toList());
            strings.add(formId);
            LinkedHashSet linkedHashSet = new LinkedHashSet(strings);
            String userCards = String.join((CharSequence)",", linkedHashSet);
            UserParameterHelper.saveCustomCard((String)userCards);
            this.refreshCustomPopover(userCards);
        }
        this.refreshIndex();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u5230\u9996\u9875", (String)"CardTemplatePlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
    }

    private void removeCard(String cardFormId) {
        String customCards = UserParameterHelper.getCustomCard();
        if (StringUtils.isNotBlank((CharSequence)customCards)) {
            String[] split = customCards.split(",");
            String userCards = Arrays.stream(split).filter(s -> !s.equals(cardFormId)).collect(Collectors.joining(","));
            UserParameterHelper.saveCustomCard((String)userCards);
            this.refreshCustomPopover(userCards);
            this.refreshIndex();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u4ece\u9996\u9875\u79fb\u51fa", (String)"CardTemplatePlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
    }

    private void refreshIndex() {
        IFormView targetPageView = PageUtils.getTargetPageView(this.getView(), "em_m_index");
        if (targetPageView != null) {
            targetPageView.invokeOperation("refresh");
            this.getView().sendFormAction(targetPageView);
        }
    }

    private void refreshCustomPopover(String cards) {
        String platformId = this.getPageCache().get(RUN_ON_PLATFORM);
        this.customPopoverMenu(platformId, cards);
    }

    private void shareTo() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("event", "share");
        args.put("shareType", "4");
        args.put("appName", ResManager.loadKDString((String)"\u8d39\u7528\u5206\u6790", (String)"CardTemplatePlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        args.put("title", "title");
        args.put("content", "content");
        args.put("cellContent", "cellContent");
        args.put("sharedObject", "all");
        args.put("datetime", new Date().getTime());
        this.fillSscCardShareParam(args);
        String yzjAppId = SystemParameterHelper.getYZJAppId();
        if (StringUtils.isBlank((CharSequence)yzjAppId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u4e91\u4e4b\u5bb6\u8f7b\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\u7cfb\u7edf\u53c2\u6570", (String)"CardTemplatePlugin_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        args.put("appId", yzjAppId);
        args.put("lightAppId", yzjAppId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "share");
        map.put("args", args);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
        logger.info("[\u5206\u4eab\u5361\u7247]\u5206\u4eab\u5361\u7247\u6210\u529f");
    }

    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        args.put("webpageUrl", this.getWebpageUrl());
    }

    protected String getShareContent(String format) {
        String shareValue = this.getPageCache().get(CACHE_SHARE_VALUE);
        if (StringUtils.isBlank((CharSequence)shareValue)) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"CardTemplatePlugin_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        return String.format(format, shareValue);
    }

    protected void setShareValue(String shareValue) {
        this.getPageCache().put(CACHE_SHARE_VALUE, shareValue);
    }

    protected String getShareContentMultiValue(String format) {
        String shareValue = this.getPageCache().get(CACHE_SHARE_VALUE);
        if (StringUtils.isBlank((CharSequence)shareValue)) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"CardTemplatePlugin_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        }
        String[] strings = shareValue.split("#");
        Object[] objects = Arrays.stream(strings).toArray();
        return String.format(format, objects);
    }

    protected void setMultiShareValue(String ... shareValue) {
        String join = String.join((CharSequence)"#", shareValue);
        this.getPageCache().put(CACHE_SHARE_VALUE, join);
    }

    protected String getWebpageUrl() {
        String accountId = RequestContext.get().getAccountId();
        String shareId = this.getParameterId();
        return String.format("%s/mobile.html?accountId=%s&form=em_m_share_card_m&%s=%s", UrlService.getDomainContextUrl(), accountId, "shareid", shareId);
    }

    protected String getParameterId() {
        ParameterCardDTO cardDTO = this.getParameter();
        ShareParameterCardDTO parameter = new ShareParameterCardDTO();
        parameter.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        parameter.setConvertDTO(AmountHelper.getConvertDTO());
        parameter.setFormIds(this.getView().getFormShowParameter().getFormId());
        parameter.setOrgIds(this.getOrgIds());
        parameter.setDateRange(cardDTO.getDateRange());
        String json = JsonUtils.toJson((Object)parameter);
        return UserShareLogDao.saveYzjShareRetrunId((String)json) + "";
    }

    public ParameterCardDTO getParameter() {
        String parameterJson = this.getParameterJson();
        if (parameterJson != null) {
            return (ParameterCardDTO)JsonUtils.fromJson((String)parameterJson, ParameterCardDTO.class);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"CardTemplatePlugin_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
    }

    public String getParameterJson() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (String)parameter.getCustomParam("unionparameter");
    }

    private List<Long> getOrgIds() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel model = this.getView().getParentView().getModel();
            MainEntityType type = model.getDataEntityType();
            DynamicProperty orgf7 = type.getProperty("orgf7");
            if (orgf7 != null) {
                DynamicObjectCollection orgRefs = (DynamicObjectCollection)model.getValue("orgf7");
                return orgRefs.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        return this.getParameter().getOrgIds();
    }
}

