/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.RefreshResultType;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.form.MobileFormView;
import kd.fi.er.mobile.basedata.org.FillOrgBuilder;
import kd.fi.er.mobile.common.CommonQueryHelper;
import kd.fi.er.mobile.common.CustomCtrlPropHelper;
import kd.fi.er.mobile.common.UserParameterHelper;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.IDateRange;
import kd.fi.er.mobile.datarange.UseSingleDateRangeMobPlugin;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.service.index.IndexServiceHelper;
import kd.fi.er.mobile.util.JsonUtils;

public class FilterTemplatePlugin
extends UseSingleDateRangeMobPlugin {
    public static final Log logger = LogFactory.getLog(FilterTemplatePlugin.class);
    protected static final String CTRL_ORGF7 = "orgf7";
    protected static final String CTRL_CARD_COMTAINER = "cardcontainer";
    protected static final String CACHE_FORM_IDS = "CACHE_FORM_IDS";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_ORGF7});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(CTRL_ORGF7);
        orgF7.addBeforeF7SelectListener(evt -> {
            List filters = IndexServiceHelper.getPermAcountingOrgsQFilters();
            evt.getCustomQFilters().addAll(filters);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.skipCheck() || this.checkIndexFormRight()) {
            this.initFilter();
            this.initBuildCard();
        }
    }

    private void initFilter() {
        Set permOrgs = IndexServiceHelper.getPermAcountingOrgs();
        if (permOrgs.isEmpty() && !this.skipCheck()) {
            this.showMessageAndExit(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FilterTemplatePlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> initFilterOrgIds = this.getInitFilterOrgIds();
        if (initFilterOrgIds != null && !initFilterOrgIds.isEmpty()) {
            permOrgs.retainAll(initFilterOrgIds);
            if (permOrgs.isEmpty()) {
                permOrgs.add(IndexServiceHelper.getMainOrgId());
            }
            this.getModel().setValue(CTRL_ORGF7, (Object)permOrgs.toArray());
        } else {
            long mainOrgId = IndexServiceHelper.getMainOrgId((Collection)permOrgs);
            this.getModel().setValue(CTRL_ORGF7, (Object)new Long[]{mainOrgId});
        }
    }

    private List<Long> getInitFilterOrgIds() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String ids = (String)parameter.getCustomParam("orgIds");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            return Stream.of(ids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        return UserParameterHelper.getCacheFilterOrgIds();
    }

    @Override
    protected DateRange getInitDateRange() {
        return super.getInitDateRange();
    }

    protected boolean skipCheck() {
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (CTRL_ORGF7.equalsIgnoreCase(propertyName)) {
            List<Long> orgIds = this.getOrgIds();
            UserParameterHelper.putFilterOrgIdsToCache(orgIds);
            this.rebuildCard();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("actionid_page403")) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (!"jump".equals(returnData)) {
                this.getView().getParentView().close();
            }
        } else {
            super.closedCallBack(closedCallBackEvent);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("exitCallback")) {
            this.getView().close();
        }
    }

    @Override
    protected void dateRangeChange(IDateRange dateRange) {
        this.rebuildCard();
    }

    public void refreshData() {
        super.refreshData();
        this.rebuildCard();
        this.setRefreshSuccess();
    }

    protected void setRefreshSuccess() {
        ((MobileFormView)this.getView()).setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"FilterTemplatePlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), Integer.valueOf(200), RefreshResultType.Success);
    }

    protected void showMessageAndExit(String msg) {
        this.getView().showConfirm(msg, MessageBoxOptions.OK, new ConfirmCallBackListener("exitCallback", (IFormPlugin)this));
    }

    public boolean checkIndexFormRight() {
        boolean hasSpecificPerm = IndexServiceHelper.hasSpecificPerm();
        if (!hasSpecificPerm) {
            PageUtils.jump403(this.getView(), this.getPluginName());
        }
        return hasSpecificPerm;
    }

    public void initBuildCard() {
        this.buildCard(this.getFormIds());
    }

    protected void buildCard(String cards) {
        this.buildCard(cards, JsonUtils.toJson((Object)this.getParameterCardDTO()));
    }

    protected void buildCard(String cards, String parameterDto) {
        Container cardcontainer = (Container)this.getView().getControl(CTRL_CARD_COMTAINER);
        Set<String> cardSet = this.getCardSet();
        String cacheCards = this.getCacheFormIds();
        if (cacheCards != null) {
            String[] cacheFormIds = cacheCards.split(",");
            cardSet.addAll(Arrays.asList(cacheFormIds));
        }
        cardcontainer.deleteControls(cardSet.toArray(new String[0]));
        if (StringUtils.isNotEmpty((CharSequence)cards)) {
            String[] formIds = cards.split(",");
            LinkedHashSet<String> strings = new LinkedHashSet<String>(Arrays.asList(formIds));
            strings.remove("");
            StringJoiner stringJoiner = new StringJoiner(",");
            FlexPanelAp flex = new FlexPanelAp();
            flex.setGrow(0);
            flex.setShrink(0);
            flex.setRadius("8px");
            for (String formId : strings) {
                if (!cardSet.contains(formId)) continue;
                flex.setKey(formId);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.addControls(list);
                boolean addCard = this.addCard(formId, parameterDto);
                if (!addCard) continue;
                stringJoiner.add(formId);
            }
            String addCards = stringJoiner.toString();
            if (this.isIndex() && !StringUtils.equals((CharSequence)cards, (CharSequence)addCards)) {
                UserParameterHelper.saveCustomCard((String)addCards);
            }
        }
        this.cacheFormIds(cards);
    }

    protected boolean addCard(String formId, String parameterDto) {
        try {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(formId);
            showParameter.setCustomParam("unionparameter", (Object)parameterDto);
            this.getView().showForm((FormShowParameter)showParameter);
            return true;
        }
        catch (KDException ignore) {
            logger.info("\u6dfb\u52a0\u5361\u7247\u53d1\u751f\u5f02\u5e38: %s", (Object)formId);
            return false;
        }
    }

    protected boolean isIndex() {
        return false;
    }

    protected void rebuildCard() {
        this.buildCard(this.getCacheFormIds());
    }

    protected String getCacheFormIds() {
        return this.getPageCache().get(CACHE_FORM_IDS);
    }

    protected void cacheFormIds(String cards) {
        this.getPageCache().put(CACHE_FORM_IDS, cards);
    }

    protected String getFormIds() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String formIds = (String)parameter.getCustomParam("formIds");
        if (StringUtils.isNotBlank((CharSequence)formIds)) {
            return formIds;
        }
        return this.getCacheFormIds();
    }

    protected ParameterCardDTO getParameterCardDTO() {
        ParameterCardDTO parameterCardDTO = new ParameterCardDTO();
        List<Long> orgIds = this.getOrgIds();
        if (orgIds.size() == 1) {
            parameterCardDTO.setOrgLabelText(CommonQueryHelper.getOrgName((Long)orgIds.get(0)));
        } else {
            parameterCardDTO.setOrgLabelText(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u7ec4\u7ec7", (String)"FilterTemplatePlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), orgIds.size()));
        }
        this.setOrgLabel(parameterCardDTO.getOrgLabelText());
        FillOrgBuilder fillOrgBuilder = new FillOrgBuilder(orgIds);
        parameterCardDTO.setOrgIds(fillOrgBuilder.getFillpermAcountingOrgs());
        parameterCardDTO.setDateRange(this.getDateRange());
        return parameterCardDTO;
    }

    private void setOrgLabel(String text) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("text", text);
        CustomCtrlPropHelper.setCustomCtrlProp(this.getView(), "cc_text_inject", data, Boolean.FALSE);
    }

    protected List<Long> getOrgIds() {
        DynamicObjectCollection orgRefs = (DynamicObjectCollection)this.getModel().getValue(CTRL_ORGF7);
        return orgRefs.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    protected Set<String> getCardSet() {
        return CardEnum.toSet();
    }
}

