/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.fi.er.mobile.basedata.org.FillOrgBuilder;
import kd.fi.er.mobile.common.CommonQueryHelper;
import kd.fi.er.mobile.common.UserShareLogDao;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.ShareParameterCardDTO;
import kd.fi.er.mobile.formplugin.index.IndexPlugin;
import kd.fi.er.mobile.formplugin.template.FilterTemplatePlugin;
import kd.fi.er.mobile.util.JsonUtils;

public class ShareCardPlugin
extends AbstractMobFormPlugin {
    public static final Log logger = LogFactory.getLog(FilterTemplatePlugin.class);
    private static final String CONDITION_ORG = "orgf7";
    private static final String CONDITION_TIME_RANGE = "date_range_panel";
    protected static final String CTRL_CARD_COMTAINER = "cardcontainer";
    protected static final String TAG_IS_SELF = "showtag";
    private static final String CTRL_BTN_BACK_INDEX = "btnbackindex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_BACK_INDEX});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_BACK_INDEX, (CharSequence)optKey)) {
            this.btnBackIndex();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String shareId = (String)parameter.getCustomParam("shareid");
        String shareJson = UserShareLogDao.getShareParamter((String)shareId);
        if (shareJson == null) {
            this.getModel().setValue(TAG_IS_SELF, (Object)2);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u5df2\u8fc7\u671f", (String)"ShareCardPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return;
        }
        ShareParameterCardDTO shareDto = (ShareParameterCardDTO)JsonUtils.fromJson((String)shareJson, ShareParameterCardDTO.class);
        Label label_org = (Label)this.getView().getControl(CONDITION_ORG);
        Label label_date = (Label)this.getView().getControl(CONDITION_TIME_RANGE);
        List orgIds = shareDto.getOrgIds();
        if (orgIds != null && orgIds.size() > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            if (orgIds.size() == 1) {
                label_org.setText(CommonQueryHelper.getOrgName((Long)((Long)orgIds.get(0))));
            } else {
                label_org.setText(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u7ec4\u7ec7", (String)"ShareCardPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), orgIds.size()));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        label_date.setText(shareDto.getDateRange().getSpanDesc());
        ParameterCardDTO cardDTO = this.convertTo(shareDto);
        Long userid = shareDto.getUserId();
        cardDTO.setShareUserid(userid);
        if (userid != null) {
            long currUserId = RequestContext.get().getCurrUserId();
            if (String.valueOf(userid).equals(String.valueOf(currUserId))) {
                this.getModel().setValue(TAG_IS_SELF, (Object)1);
            }
        }
        cardDTO.setConvertDTO(shareDto.getConvertDTO());
        this.buildCard(shareDto.getFormIds(), JsonUtils.toJson((Object)cardDTO));
    }

    protected ParameterCardDTO convertTo(ShareParameterCardDTO shareDto) {
        ParameterCardDTO parameterCardDTO = new ParameterCardDTO();
        List orgIds = shareDto.getOrgIds();
        if (orgIds.size() == 1) {
            parameterCardDTO.setOrgLabelText(CommonQueryHelper.getOrgName((Long)((Long)orgIds.get(0))));
        } else {
            parameterCardDTO.setOrgLabelText(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u7ec4\u7ec7", (String)"ShareCardPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), orgIds.size()));
        }
        FillOrgBuilder fillOrgBuilder = new FillOrgBuilder((Collection)orgIds);
        parameterCardDTO.setOrgIds(fillOrgBuilder.getFillpermAcountingOrgs());
        parameterCardDTO.setDateRange(shareDto.getDateRange());
        return parameterCardDTO;
    }

    protected void buildCard(String cards, String parameterDto) {
        Container cardcontainer = (Container)this.getView().getControl(CTRL_CARD_COMTAINER);
        if (StringUtils.isNotEmpty((CharSequence)cards)) {
            String[] cardsArr = cards.split(",");
            cardcontainer.deleteControls(cardsArr);
            FlexPanelAp flex = new FlexPanelAp();
            flex.setGrow(0);
            flex.setShrink(0);
            flex.setRadius("8px");
            for (String formId : cardsArr) {
                flex.setKey(formId);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.addControls(list);
                this.addCard(formId, parameterDto);
            }
        }
    }

    protected void addCard(String formId, String parameterDto) {
        try {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(formId);
            showParameter.setCustomParam("unionparameter", (Object)parameterDto);
            Object value = this.getModel().getValue(TAG_IS_SELF);
            if (!Objects.equals(value, 1)) {
                showParameter.setCustomParam("onlyRead", (Object)"true");
            }
            showParameter.setCustomParam("CARD_IS_SHARE", (Object)"true");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        catch (KDException ignore) {
            logger.info("\u6dfb\u52a0\u5361\u7247\u53d1\u751f\u5f02\u5e38: %s", (Object)formId);
        }
    }

    private void btnBackIndex() {
        IndexPlugin.backToIndex(this.getView());
    }
}

