/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.dto.AirlinesRelationshipAnalysisDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.trader.AirlinesRelationshipAnalysisCardHelper;
import kd.fi.er.mobile.util.JsonUtils;

public class AirlinesRelationshipAnalysisCardPlugin
extends CardTemplatePlugin {
    public static final Log logger = LogFactory.getLog(AirlinesRelationshipAnalysisCardPlugin.class);
    private static final String TYPE_SYSTEM = "fi-er-mb-formplugin";
    private static final String LABEL_ANALYSIS = "btn_detail";
    private static final String LABEL_LEGEND_DISCOUNT_RATE = "legendfp1";
    private static final String LABEL_LEGEND_AIRLINES = "legendfp2";
    private static final String LABEL_LEGEND_ORDER_COUNT = "legendfp3";
    private static final String FROM_ID = "em_m_airlines_rs_card";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u822a\u53f8\u5173\u7cfb\u5206\u6790", (String)"AirlinesRelationshipAnalysisCardPlugin_0", (String)TYPE_SYSTEM, (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u5404\u822a\u53f8\u7684\u8ba2\u5355\u91cf\u548c\u6298\u6263\u7387\u5206\u5e03\u60c5\u51b5", (String)"AirlinesRelationshipAnalysisCardPlugin_1", (String)TYPE_SYSTEM, (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LABEL_ANALYSIS});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)LABEL_ANALYSIS, (CharSequence)optKey)) {
            ParameterCardDTO parameterDTO = this.getParameter();
            AirlinesRelationshipAnalysisDTO dto = AirlinesRelationshipAnalysisCardHelper.loadData((ParameterCardDTO)parameterDTO);
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId("em_m_airlines_rs_d_card");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCustomParam("unionparameter", (Object)JsonUtils.toJson((Object)parameterDTO));
            parameter.setCustomParam("data", (Object)JsonUtils.toJson((Object)dto));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        AirlinesRelationshipAnalysisDTO dto = AirlinesRelationshipAnalysisCardHelper.loadData((ParameterCardDTO)parameterDTO);
        logger.info(String.format("AirlinesRelationshipAnalysisCardPlugin -- start rendering data, dto:%s", JsonUtils.toJson((Object)dto)));
        IFormView view = this.getView();
        if (ObjectUtils.isEmpty((Object)dto) || ObjectUtils.isEmpty((Object)dto.getAirlinesDTOs())) {
            view.setVisible(Boolean.FALSE, new String[]{LABEL_LEGEND_AIRLINES, LABEL_LEGEND_DISCOUNT_RATE, LABEL_LEGEND_ORDER_COUNT});
            this.setNoData(0, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u53d1\u73b0\u673a\u7968\u8ba2\u5355,\u8bf7\u7a0d\u540e\u67e5\u8be2", (String)"AirlinesRelationshipAnalysisCardPlugin_2", (String)TYPE_SYSTEM, (Object[])new Object[0]));
            return;
        }
        ThreadCache.put((Object)FROM_ID, (Object)dto);
    }

    public void afterBindData(EventObject e) {
        AirlinesRelationshipAnalysisDTO dto = (AirlinesRelationshipAnalysisDTO)ThreadCache.get((Object)FROM_ID);
        if (ObjectUtils.isEmpty((Object)dto) || CollectionUtils.isEmpty((Collection)dto.getAirlinesDTOs())) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_LEGEND_AIRLINES, LABEL_LEGEND_DISCOUNT_RATE, LABEL_LEGEND_ORDER_COUNT});
        this.createScatterChart(dto);
    }

    private void createScatterChart(AirlinesRelationshipAnalysisDTO dto) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty("efficiencyscatterchart", "data", (Object)AirlinesRelationshipAnalysisCardHelper.getScatterChartData((AirlinesRelationshipAnalysisDTO)dto, (String)"area1"));
    }
}

