/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.dto.AirlinesDTO;
import kd.fi.er.mobile.dto.AirlinesRelationshipAnalysisDTO;
import kd.fi.er.mobile.service.trader.AirlinesRelationshipAnalysisCardHelper;
import kd.fi.er.mobile.util.JsonUtils;

public class AirlinesRelationshipAnalysisDetailCardPlugin
extends AbstractMobFormPlugin
implements TabSelectListener {
    public static final Log logger = LogFactory.getLog(AirlinesRelationshipAnalysisDetailCardPlugin.class);
    private static final String DEFAULT_QUADRANT = "area1";
    private static final String KEY_ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(KEY_ENTRY, "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        String subTabKey = tabSelectEvent.getTabKey();
        this.renderDataList(subTabKey);
    }

    private void renderDataList(String subTabKey) {
        AirlinesRelationshipAnalysisDTO data = this.getData();
        this.createScatterChart(data, subTabKey);
        this.renderData(subTabKey, data);
    }

    private void renderData(String subTabKey, AirlinesRelationshipAnalysisDTO data) {
        Map map = AirlinesRelationshipAnalysisCardHelper.loadDetailData((AirlinesRelationshipAnalysisDTO)data);
        logger.info(String.format("AirlinesRelationshipAnalysisDetailCardPlugin -- start rendering detail data, result:%s", map));
        List dtos = (List)map.get(subTabKey);
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        if (dtos.isEmpty()) {
            return;
        }
        dtos.sort((o1, o2) -> -o1.getOrderCount().compareTo(o2.getOrderCount()));
        model.beginInit();
        model.batchCreateNewEntryRow(KEY_ENTRY, dtos.size());
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty colorProp = entryEntity.getDynamicObjectType().getProperty("color");
        DynamicProperty airlineNameProp = entryEntity.getDynamicObjectType().getProperty("airlineName");
        DynamicProperty orderCountProp = entryEntity.getDynamicObjectType().getProperty("orderCount");
        DynamicProperty discountRateProp = entryEntity.getDynamicObjectType().getProperty("discountRate");
        for (int i = 0; i < dtos.size(); ++i) {
            AirlinesDTO dto = (AirlinesDTO)dtos.get(i);
            DynamicObject dy = (DynamicObject)entryEntity.get(i);
            colorProp.setValueFast((Object)dy, (Object)dto.getColor());
            airlineNameProp.setValueFast((Object)dy, (Object)dto.getAirlineName());
            orderCountProp.setValueFast((Object)dy, (Object)dto.getOrderCount());
            discountRateProp.setValueFast((Object)dy, (Object)(dto.getDiscountRate() + "%"));
        }
        model.endInit();
        IFormView view = this.getView();
        view.updateView(KEY_ENTRY);
    }

    private AirlinesRelationshipAnalysisDTO getData() {
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        return (AirlinesRelationshipAnalysisDTO)JsonUtils.fromJson((String)data, AirlinesRelationshipAnalysisDTO.class);
    }

    public void afterBindData(EventObject e) {
        this.renderDataList(DEFAULT_QUADRANT);
    }

    private void createScatterChart(AirlinesRelationshipAnalysisDTO dto, String subTabKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            logger.error("occur an error , " + e);
            Thread.currentThread().interrupt();
        }
        clientViewProxy.setFieldProperty("efficiencyscatterchart", "data", (Object)AirlinesRelationshipAnalysisCardHelper.getScatterChartData((AirlinesRelationshipAnalysisDTO)dto, (String)subTabKey));
    }
}

