/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.analyse.MultiTabTemplatePlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.analyse.data.TransferData;
import kd.fi.er.mobile.service.trader.AirplaneDiscountAnalyseDataProcessImpl;
import kd.fi.er.mobile.service.trader.AirplaneDiscountDataHelper;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;
import kd.fi.er.mobile.vo.IChartTextFormatter;

public class AirplaneDiscountPlugin
extends CardTemplatePlugin {
    private static final String CTRL_CHART_AP = "echart";
    private static final String LABEL_DAY = "labelday";
    private static final String LABEL_DISCOUNT = "labeldiscount";
    private static final String CTRL_LABEL_TIPS1 = "labeltip1";
    private static final String CTRL_LABEL_TIPS2 = "labeltip2";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u63d0\u524d\u8ba2\u7968\u5929\u6570\u4e0e\u6298\u6263\u5206\u6790", (String)"AirplaneDiscountPlugin_9", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = this.getShareContentMultiValue(ResManager.loadKDString((String)"\u5e73\u5747\u63d0\u524d\u8ba2\u7968\u5929\u6570\uff1a%1$s\uff0c\u5e73\u5747\u6298\u6263\uff1a%2$s", (String)"AirplaneDiscountPlugin_10", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    protected void btnDetail() {
        TransferData tData = new TransferData();
        tData.setCardParameter(this.getParameter());
        tData.setProcessClassName(AirplaneDiscountAnalyseDataProcessImpl.class.getName());
        MultiTabTemplatePlugin.jumpMeBy(this.getView(), ResManager.loadKDString((String)"\u63d0\u524d\u9884\u8ba2\u5929\u6570\u4e0e\u6298\u6263\u8be6\u60c5", (String)"AirplaneDiscountPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), tData);
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        DataChartListVO data = AirplaneDiscountDataHelper.loadData((ParameterCardDTO)dto);
        String avgDaysStr = data.getExt("avgDaysStr") + "";
        String avgDiscountStr = data.getExt("avgDiscountStr") + "";
        this.setMultiShareValue(avgDaysStr, avgDiscountStr);
        this.setHeaderPanel(avgDaysStr, avgDiscountStr);
        this.setDataVo(data);
    }

    private void setHeaderPanel(String avgDaysStr, String avgDiscountStr) {
        Label l_days = (Label)this.getControl(LABEL_DAY);
        Label l_discount = (Label)this.getControl(LABEL_DISCOUNT);
        l_days.setText(avgDaysStr);
        l_discount.setText(avgDiscountStr);
    }

    protected void setDataVo(DataChartListVO data) {
        List vos = data.getDatas();
        if (this.allEmpty(vos)) {
            this.setNoData(0, this.getNoDataTip());
            return;
        }
        this.setNoData(1);
        this.setTipsLabel((DataListVO)data);
        this.setChart(data);
    }

    private void setChart(DataChartListVO data) {
        List vos = data.getDatas();
        Chart chart = this.getChart();
        this.setChartMargin(chart);
        this.setLegend(chart);
        this.setTooltip(chart);
        this.setXAxis(chart, vos);
        this.setYAxis(chart);
        Series series = this.createLeftSeries(chart, vos, data.getFormatter());
        this.createMarkLine(series, data);
        chart.refresh();
    }

    private void createMarkLine(Series series, DataChartListVO data) {
        BigDecimal avgDiscount = (BigDecimal)data.getExt("avgDiscount");
        String avgDiscountStr = data.getExt("avgDiscountStr") + "";
        series.setPropValue("markLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", (Object)"dashed").kv("color", (Object)"rgba(255,153,28,1)")).kv("label", map -> map.kv("position", (Object)"middle").kv("formatter", (Object)avgDiscountStr)).list("data", new Object[]{M.map().kv("yAxis", (Object)avgDiscount).kv("symbol", (Object)"none")}).kv("silent", (Object)"true"));
        series.addFuncPath(M.arraylist((Object[])new Object[]{"markLine", "label", "formatter"}));
    }

    protected boolean allEmpty(List<DataVO> models) {
        for (DataVO model : models) {
            if (model.getCount() <= 0L) continue;
            return false;
        }
        return true;
    }

    private Series createLeftSeries(Chart chart, List<DataVO> models, IChartTextFormatter formatter) {
        LineSeries series = chart.createLineSeries(ResManager.loadKDString((String)"\u5e73\u5747\u6298\u6263", (String)"AirplaneDiscountPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        series.setPropValue("areaStyle", (Object)M.map().kv("color", (Object)"rgba(192, 197, 251, 1)"));
        series.setPropValue("label", (Object)M.map().kv("show", (Object)Boolean.FALSE));
        series.setPropValue("showSymbol", (Object)Boolean.FALSE);
        series.setPropValue("lineStyle", (Object)M.map().kv("color", (Object)"rgba(192, 197, 251, 1)"));
        ArrayList list = new ArrayList(models.size());
        for (int i = 0; i < models.size(); ++i) {
            DataVO vo = models.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("text", formatter.formatTip(vo));
            map.put("value", new Object[]{i, vo.getValue()});
            list.add(map);
        }
        series.setPropValue("data", list);
        return series;
    }

    protected void setTipsLabel(DataListVO data) {
        String tips1 = data.getSuggest();
        if (StringUtils.isNotEmpty((CharSequence)tips1)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CTRL_LABEL_TIPS1});
            Label label_tip1 = (Label)this.getControl(CTRL_LABEL_TIPS1);
            label_tip1.setText(tips1);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_LABEL_TIPS1});
        }
        String tips2 = this.getTips2(data);
        if (StringUtils.isNotEmpty((CharSequence)tips2)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CTRL_LABEL_TIPS2});
            Label label_tip1 = (Label)this.getControl(CTRL_LABEL_TIPS2);
            label_tip1.setText(tips2);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_LABEL_TIPS2});
        }
    }

    private String getTips2(DataListVO data) {
        List datas = data.getDatas();
        String content = datas.stream().filter(vo -> vo.getCount() == 0L).map(DataVO::getItemname).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            return String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u63d0\u524d%s\u9884\u8ba2\u7684\u673a\u7968\u8ba2\u5355", (String)"AirplaneDiscountPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), content);
        }
        return "";
    }

    private String getNoDataTip() {
        return ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u673a\u7968\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"AirplaneDiscountPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
    }

    protected Chart getChart() {
        Chart chart = (Chart)this.getControl(CTRL_CHART_AP);
        chart.clearData();
        return chart;
    }

    protected void setChartMargin(Chart chart) {
        chart.setMargin(Position.top, "40px");
        chart.setMargin(Position.right, "15px");
    }

    protected void setLegend(Chart chart) {
        chart.setShowLegend(false);
    }

    protected void setTooltip(Chart chart) {
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"axis");
        chart.addTooltip("axisPointer ", (Object)M.map().kv("label", (Object)M.map((String)"show", (Object)Boolean.FALSE)));
        chart.addTooltip("formatter", (Object)"function(params){ var arr = params[0].data; return arr.text; }");
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"tooltip", "formatter"}));
    }

    protected void setXAxis(Chart chart, List<DataVO> vos) {
        Axis axis = chart.createXAxis("", AxisType.value);
        axis.setPropValue("boundaryGap", (Object)Boolean.FALSE);
        axis.setPropValue("min", (Object)0);
        axis.setPropValue("max", (Object)30);
        axis.setPropValue("interval", (Object)5);
        axis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999999"));
        axis.setPropValue("splitLine", (Object)M.map().kv("show", (Object)Boolean.FALSE));
        axis.setPropValue("axisLine", (Object)M.map().kv("show", (Object)Boolean.FALSE));
        axis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        axis.setPropValue("nameTextStyle", (Object)M.map().kv("fontSize", (Object)12).kv("color", (Object)"#999999"));
        String formatter = String.format(ResManager.loadKDString((String)"%1$s\u5f53\u5929%2$s\u5929%3$s", (String)"AirplaneDiscountPlugin_12", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), "function(value){ if(value===0){ return '", "' }else{ return value + '", "';}}");
        axis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("formatter", (Object)formatter));
        chart.addFuncPath(M.arraylist((Object[])new Object[]{"xAxis", 0, "axisLabel", "formatter"}));
        List collect = vos.stream().map(DataVO::getValue0).collect(Collectors.toList());
        axis.setPropValue("data", collect);
    }

    protected void setYAxis(Chart chart) {
        Axis yAxis = chart.createYAxis(ResManager.loadKDString((String)"\u5e73\u5747\u6298\u6263(%)", (String)"AirplaneDiscountPlugin_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12).kv("align", (Object)"left").list("padding", new Object[]{0, 0, 0, -10}));
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", (Object)"#999").kv("fontSize", (Object)12));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", (Object)"dashed").kv("color", (Object)"#e8e8e8")));
        yAxis.setPropValue("axisLine", (Object)M.map((String)"show", (Object)Boolean.FALSE));
        yAxis.setPropValue("axisTick", (Object)M.map((String)"show", (Object)Boolean.FALSE));
    }
}

