/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.exception.ErMobiNoExchangeRateException;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.formplugin.trader.graph.ExistAndRebookAnalysisGraphHelper;
import kd.fi.er.mobile.formplugin.trader.vo.ExistAndRebookAnalysisVO;
import kd.fi.er.mobile.util.JsonUtils;

public class ExistAndRebookAnalysisDetailFormPlugin
extends CardTemplatePlugin {
    public static final String FORMID = "em_m_existrebook_detail";

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue("radiogroupfield", parentView.getModel().getValue("radiogroupfield"));
        }
        ExistAndRebookAnalysisGraphHelper.initAnalysisGraph(this.getView(), this.getParameter());
        this.initialEntryData();
    }

    private void initialEntryData() {
        List<ExistAndRebookAnalysisVO> existAndRebookAnalysisVOs = ExistAndRebookAnalysisGraphHelper.getSeriesDataList(this.getView(), this.getParameter());
        if (CollectionUtils.isEmpty(existAndRebookAnalysisVOs)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        int size = existAndRebookAnalysisVOs.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty date = dynamicObjects.getDynamicObjectType().getProperty("date");
        DynamicProperty percent = dynamicObjects.getDynamicObjectType().getProperty("percent");
        DynamicProperty rebookCost = dynamicObjects.getDynamicObjectType().getProperty("rebookcost");
        DynamicProperty existCost = dynamicObjects.getDynamicObjectType().getProperty("existcost");
        for (int i = 0; i < size; ++i) {
            ExistAndRebookAnalysisVO existAndRebookAnalysisVO = existAndRebookAnalysisVOs.get(i);
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            date.setValueFast((Object)entry, (Object)existAndRebookAnalysisVO.getOrderDateStr());
            percent.setValueFast((Object)entry, (Object)String.format(ResManager.loadKDString((String)"\u9000\u6539\u7b7e\u5360\u6bd4\uff1a%1$s%%", (String)"ExistAndRebookAnalysisDetailFormPlugin_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), existAndRebookAnalysisVO.isEmpty() ? "-" : existAndRebookAnalysisVO.getExistAndRebookPercent()));
            rebookCost.setValueFast((Object)entry, (Object)String.format(ResManager.loadKDString((String)"\u6539\u7b7e\u635f\u5931\uff1a%1$s", (String)"ExistAndRebookAnalysisDetailFormPlugin_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AmountHelper.text((BigDecimal)existAndRebookAnalysisVO.getRebookCost())));
            rebookCost.setValueFast((Object)entry, (Object)String.format(ResManager.loadKDString((String)"\u9000\u7968\u635f\u5931\uff1a%1$s", (String)"ExistAndRebookAnalysisDetailFormPlugin_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AmountHelper.text((BigDecimal)existAndRebookAnalysisVO.getExistCost())));
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        if ("radiogroupfield".equals(keyName)) {
            try {
                ExistAndRebookAnalysisGraphHelper.initAnalysisGraph(this.getView(), this.getParameter());
                this.initialEntryData();
            }
            catch (ErMobiNoExchangeRateException ex) {
                this.setNoExchangeRateTips(ex.getAbsentCurrencies());
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            }
        }
    }

    @Override
    public ParameterCardDTO getParameter() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return (ParameterCardDTO)JsonUtils.fromJson((String)((String)parameter.getCustomParam("unionparameter")), ParameterCardDTO.class);
    }

    public static void jumpMeBy(IFormView view, String caption, ParameterCardDTO parameter) {
        IFormView targetPageView;
        if (caption == null && (targetPageView = PageUtils.getTargetPageView(view, FORMID)) != null) {
            caption = targetPageView.getFormShowParameter().getCaption();
        }
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(FORMID);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("unionparameter", (Object)JsonUtils.toJson((Object)parameter));
        view.showForm((FormShowParameter)formShowParameter);
    }
}

