/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.PageUtils;
import kd.fi.er.mobile.formplugin.analyse.DynamicTabTemplatePlugin;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.service.analyse.data.NextListTransferData;
import kd.fi.er.mobile.service.trader.TraderBillAnalyseDataProcessImpl;
import kd.fi.er.mobile.service.trader.TraderBillOverallDataHelper;
import kd.fi.er.mobile.vo.CompareRateVO;
import kd.fi.er.mobile.vo.TraderOverallVO;

public class TraderBillOverallPlugin
extends CardTemplatePlugin {
    private static final String LABEL_ITEM_AMOUNT = "labelamount";
    private static final String FIELD_ITEM_AMOUNT = "amount";
    private static final String FLEX_ITEM_PREVIOUS = "flexprevious";
    private static final String LABEL_ITEM_PREVIOUS = "labelprevious";
    private static final String FLEX_ITEM_LINK = "flexlink";
    private static final String LABEL_ITEM_LINK = "labellink";
    private static final String PBAR_ITEM_PROPORTION = "progressbarap";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", ResManager.loadKDString((String)"\u5546\u65c5\u6574\u4f53\u6982\u51b5", (String)"TraderBillOverallPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5546\u65c5\u6d88\u8d39\u91d1\u989d\uff1a%s\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"TraderBillOverallPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    public void loadData(ParameterCardDTO dto) {
        TraderOverallVO vo = TraderBillOverallDataHelper.loadData((ParameterCardDTO)dto);
        this.setPanelData(vo);
    }

    @Override
    protected void btnDetail() {
        NextListTransferData transferData = new NextListTransferData();
        transferData.setFilter("all");
        transferData.setCardParameter(this.getParameter());
        transferData.setProcessClassName(TraderBillAnalyseDataProcessImpl.class.getName());
        DynamicTabTemplatePlugin.jumpMeBy(this.getView(), ResManager.loadKDString((String)"\u5546\u65c5\u6574\u4f53\u6982\u51b5\u5206\u6790", (String)"TraderBillOverallPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), transferData);
    }

    private void setPanelData(TraderOverallVO vo) {
        CompareRateVO totalBillVO = vo.getTotalBillVO();
        this.setShareValue(totalBillVO.getCurrSignAmount().getText());
        this.setItemPanelData(totalBillVO, "");
        this.setItemPanelData(vo.getPlaneBillItemVO(), "item1");
        this.setItemPanelData(vo.getHotelBillItemVO(), "item2");
        this.setItemPanelData(vo.getTrainBillItemVO(), "item3");
        this.setItemPanelData(vo.getVehicBillItemVO(), "item4");
    }

    private void setItemPanelData(CompareRateVO vo, String index) {
        Label l_amount = (Label)this.getControl(LABEL_ITEM_AMOUNT + index);
        l_amount.setText(vo.getCurrSignAmount().getText());
        if (vo.getPreviousSignAmount() != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ITEM_PREVIOUS + index});
            PageUtils.setLabel(this.getView(), LABEL_ITEM_PREVIOUS + index, vo.comparePreviousRatio());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ITEM_PREVIOUS + index});
        }
        if (vo.getLinkSignAmount() != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ITEM_LINK + index});
            PageUtils.setLabel(this.getView(), LABEL_ITEM_LINK + index, vo.compareLinkRatio());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ITEM_LINK + index});
        }
        if (StringUtils.isNotBlank((CharSequence)index)) {
            ProgressBar pb_proportion = (ProgressBar)this.getControl(PBAR_ITEM_PROPORTION + index);
            pb_proportion.setPercent(vo.getPercent().multiply(new BigDecimal("100")).intValue());
            this.getModel().setValue(FIELD_ITEM_AMOUNT + index, (Object)vo.getCurrSignAmount().getValue());
        }
    }
}

