/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.TripTailRankCardDTO;
import kd.fi.er.mobile.formplugin.template.AbstractDetailTemplatelugin;
import kd.fi.er.mobile.service.trader.TripTailRankCardHelper;

public class TripTailRankDetailFormPlugin
extends AbstractDetailTemplatelugin {
    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.initializeTripTailRankList(parameterDTO);
    }

    private void initializeTripTailRankList(ParameterCardDTO parameterDTO) {
        List tripTailRankCardDTOs = TripTailRankCardHelper.getTripTailRankCardDTOs((ParameterCardDTO)parameterDTO);
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int size = tripTailRankCardDTOs.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
            DynamicProperty rankLabel = dynamicObjects.getDynamicObjectType().getProperty("rank_label");
            DynamicProperty tail = dynamicObjects.getDynamicObjectType().getProperty("tail");
            DynamicProperty number = dynamicObjects.getDynamicObjectType().getProperty("number");
            DynamicProperty rankValue = dynamicObjects.getDynamicObjectType().getProperty("rank_value");
            for (int i = 0; i < size; ++i) {
                TripTailRankCardDTO tripTailRankCardDTO = (TripTailRankCardDTO)tripTailRankCardDTOs.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                rankLabel.setValueFast((Object)entry, (Object)("No." + tripTailRankCardDTO.getRank()));
                tail.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getTail());
                number.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getNumber());
                rankValue.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getRank());
            }
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    public static void jumpMeBy(IFormView formView, String caption, String parameterJson) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("em_m_triptail_detail");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(caption);
        parameter.setCustomParam("unionparameter", (Object)parameterJson);
        formView.showForm((FormShowParameter)parameter);
    }
}

