/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.TripTailRankCardDTO;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.formplugin.template.CardTemplatePlugin;
import kd.fi.er.mobile.formplugin.trader.TripTailRankDetailFormPlugin;
import kd.fi.er.mobile.service.trader.TripTailRankCardHelper;

public class TripTailRankFormPlugin
extends CardTemplatePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_detail"});
    }

    @Override
    public void loadData(ParameterCardDTO parameterDTO) {
        this.initializeTripTailRankList(parameterDTO);
    }

    private void initializeTripTailRankList(ParameterCardDTO parameterDTO) {
        List tripTailRankCardDTOs = TripTailRankCardHelper.getTripTailRankCardDTOs((ParameterCardDTO)parameterDTO).stream().limit(5L).collect(Collectors.toList());
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int size = tripTailRankCardDTOs.size();
        if (size == 0) {
            this.setNoData(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5546\u65c5\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"TripTailRankFormPlugin_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        } else {
            this.setNoData(1);
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
            DynamicProperty rankLabel = dynamicObjects.getDynamicObjectType().getProperty("rank_label");
            DynamicProperty tail = dynamicObjects.getDynamicObjectType().getProperty("tail");
            DynamicProperty number = dynamicObjects.getDynamicObjectType().getProperty("number");
            DynamicProperty rankValue = dynamicObjects.getDynamicObjectType().getProperty("rank_value");
            for (int i = 0; i < size; ++i) {
                TripTailRankCardDTO tripTailRankCardDTO = (TripTailRankCardDTO)tripTailRankCardDTOs.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                rankLabel.setValueFast((Object)entry, (Object)("No." + tripTailRankCardDTO.getRank()));
                tail.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getTail());
                number.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getNumber());
                rankValue.setValueFast((Object)entry, (Object)tripTailRankCardDTO.getRank());
            }
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    @Override
    protected void btnDetail() {
        TripTailRankDetailFormPlugin.jumpMeBy(this.getView(), ResManager.loadKDString((String)"\u5dee\u65c5\u8def\u7ebf\u6392\u884c\u8be6\u60c5", (String)"TripTailRankFormPlugin_1", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), this.getParameterJson());
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.TRIP_TAIL_RANK.getCaption());
        String content = ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u5dee\u65c5\u8def\u7ebf\u6392\u884c", (String)"TripTailRankFormPlugin_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]);
        args.put("content", content);
        args.put("cellContent", content);
    }
}

