/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader.graph;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.AirExpenseAnalysisCardDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.formplugin.trader.vo.AnalysisVO;
import kd.fi.er.mobile.service.trader.AirExpenseAnalysisDataHelper;

public class AirExpenseAnalysisLineGraphHelper {
    public static void initAnalysisGraph(IFormView view, ParameterCardDTO parameterDTO) {
        PointLineChart pointLineChart = (PointLineChart)view.getControl("pointlinechartap");
        pointLineChart.clearData();
        List seriesDataList = AirExpenseAnalysisDataHelper.getAirExpenseAnalysisCardDTOLastSixMonth((ParameterCardDTO)parameterDTO);
        boolean isEmptySixMonthRecently = AirExpenseAnalysisLineGraphHelper.setEmptyDataMessage(view, seriesDataList);
        if (isEmptySixMonthRecently) {
            return;
        }
        AirExpenseAnalysisLineGraphHelper.setToolTip(pointLineChart);
        AirExpenseAnalysisLineGraphHelper.setGrid(pointLineChart);
        AirExpenseAnalysisLineGraphHelper.setLegend(pointLineChart);
        AirExpenseAnalysisLineGraphHelper.setXAxis(pointLineChart);
        AirExpenseAnalysisLineGraphHelper.setYAxis(pointLineChart);
        AirExpenseAnalysisLineGraphHelper.setSeries(pointLineChart, seriesDataList);
        view.updateView("pointlinechartap");
    }

    private static boolean setEmptyDataMessage(IFormView view, List<AirExpenseAnalysisCardDTO> seriesDataList) {
        List notEmptyDTOs = seriesDataList.stream().filter(dto -> dto.getNumber() == 0).collect(Collectors.toList());
        int emptyCount = notEmptyDTOs.size();
        if (emptyCount == 6) {
            view.getModel().setValue("datatag", (Object)0);
            Label defaultlabel = (Label)view.getControl("defaultlabel");
            defaultlabel.setText(ResManager.loadKDString((String)"\u8fd16\u4e2a\u6708\u672a\u53d1\u73b0\u673a\u7968\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"AirExpenseAnalysisLineGraphHelper_0", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        } else if (notEmptyDTOs.size() == 0) {
            view.getModel().setValue("datatag", (Object)1);
            view.setVisible(Boolean.FALSE, new String[]{"tip_panel"});
        } else {
            view.getModel().setValue("datatag", (Object)1);
            view.setVisible(Boolean.TRUE, new String[]{"tip_panel"});
            List emptyMonthStrList = notEmptyDTOs.stream().map(dto -> String.format(ResManager.loadKDString((String)"%s\u6708", (String)"AirExpenseAnalysisLineGraphHelper_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), dto.getOrderDate().getMonthValue())).collect(Collectors.toList());
            Label tipLabel = (Label)view.getControl("tip_label");
            tipLabel.setText(String.format(ResManager.loadKDString((String)"%s\u672a\u67e5\u8be2\u5230\u673a\u7968\u8ba2\u5355", (String)"AirExpenseAnalysisLineGraphHelper_2", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", emptyMonthStrList)));
        }
        return emptyCount == 6;
    }

    private static void setToolTip(PointLineChart pointLineChart) {
        pointLineChart.setShowTooltip(true);
        pointLineChart.addTooltip("trigger", (Object)"axis");
        pointLineChart.addTooltip("formatter", (Object)"function(params){return params[0].name + '<br/>' + params[2].seriesName+' : ' + params[2].data.text+ '<br/>' + params[1].seriesName+' : ' + params[1].data.text+ '<br/>' + params[0].seriesName+' : ' + params[0].data.text;}");
        ArrayList<String> formatterPathList = new ArrayList<String>();
        formatterPathList.add("tooltip");
        formatterPathList.add("formatter");
        pointLineChart.addFuncPath(formatterPathList);
    }

    private static void setGrid(PointLineChart pointLineChart) {
        pointLineChart.setMargin(Position.top, "12%");
        pointLineChart.setMargin(Position.bottom, "12%");
        pointLineChart.setMargin(Position.left, "7%");
    }

    private static void setLegend(PointLineChart pointLineChart) {
        pointLineChart.setShowLegend(true);
        pointLineChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        pointLineChart.setLegendPropValue("bottom", (Object)1);
        pointLineChart.setLegendPropValue("data", (Object)M.arraylist((Object[])new Object[]{ResManager.loadKDString((String)"\u6807\u51c6\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u9645\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0])}));
    }

    private static void setXAxis(PointLineChart pointLineChart) {
        LocalDate now = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        xAxis.setPropValue("axisPointer", (Object)M.map((String)"type", (Object)"shadow"));
        xAxis.setPropValue("axisLabel", (Object)M.map((String)"textStyle", (Object)M.map((String)"fontSize", (Object)8)));
        xAxis.setPropValue("inverse", (Object)Boolean.TRUE);
        xAxis.setPropValue("data", (Object)M.arraylist((Object[])new Object[]{dateTimeFormatter.format(now), dateTimeFormatter.format(now.minusMonths(1L)), dateTimeFormatter.format(now.minusMonths(2L)), dateTimeFormatter.format(now.minusMonths(3L)), dateTimeFormatter.format(now.minusMonths(4L)), dateTimeFormatter.format(now.minusMonths(5L))}));
    }

    private static void setYAxis(PointLineChart pointLineChart) {
        Axis amountYAxis = pointLineChart.createYAxis(ResManager.loadKDString((String)"\u5143", (String)"AirExpenseAnalysisLineGraphHelper_6", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AxisType.value);
        amountYAxis.setPropValue("splitLine", (Object)M.map().kv("fontSize", (Object)8));
    }

    private static void setSeries(PointLineChart pointLineChart, List<AirExpenseAnalysisCardDTO> seriesDataList) {
        LineSeries lowestPriceSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        lowestPriceSeries.setPropValue("stack", (Object)"price");
        lowestPriceSeries.setPropValue("areaStyle", (Object)M.map((String)"color", (Object)"#9AFF9A"));
        lowestPriceSeries.setPropValue("itemStyle", (Object)M.map().kv("color", (Object)"#9AFF9A").kv("lineStyle", (Object)M.map((String)"color", (Object)"#9AFF9A")));
        lowestPriceSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        lowestPriceSeries.setPropValue("data", AirExpenseAnalysisLineGraphHelper.getLowestPriceLineVO(seriesDataList));
        LineSeries ticketPriceSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u5b9e\u9645\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_4", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        ticketPriceSeries.setPropValue("stack", (Object)"price");
        ticketPriceSeries.setPropValue("areaStyle", (Object)M.map((String)"color", (Object)"#FFCC99"));
        ticketPriceSeries.setPropValue("itemStyle", (Object)M.map().kv("color", (Object)"#FFCC99").kv("lineStyle", (Object)M.map((String)"color", (Object)"#FFCC99")));
        ticketPriceSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        ticketPriceSeries.setPropValue("data", AirExpenseAnalysisLineGraphHelper.getTicketPriceLineVO(seriesDataList));
        LineSeries standardPriceSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6807\u51c6\u4ef7\u683c", (String)"AirExpenseAnalysisLineGraphHelper_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        standardPriceSeries.setPropValue("stack", (Object)"price");
        standardPriceSeries.setPropValue("areaStyle", (Object)M.map((String)"color", (Object)"#33CCFF"));
        standardPriceSeries.setPropValue("itemStyle", (Object)M.map().kv("color", (Object)"#33CCFF").kv("lineStyle", (Object)M.map((String)"color", (Object)"#33CCFF")));
        standardPriceSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        standardPriceSeries.setPropValue("data", AirExpenseAnalysisLineGraphHelper.getStandardPriceLineVO(seriesDataList));
    }

    private static List<AnalysisVO> getStandardPriceLineVO(List<AirExpenseAnalysisCardDTO> seriesDataList) {
        AmountHandler handler = AmountHelper.get();
        return seriesDataList.stream().map(airExpenseAnalysisCardDTO -> {
            AnalysisVO analysisVO = new AnalysisVO();
            String sign = handler.getCurrency().getString("sign");
            int number = airExpenseAnalysisCardDTO.getNumber();
            BigDecimal standardPrice = airExpenseAnalysisCardDTO.getStandardPrice();
            BigDecimal ticketPrice = airExpenseAnalysisCardDTO.getTicketPrice();
            if (number == 0) {
                analysisVO.setValue(BigDecimal.ZERO);
                analysisVO.setText(sign + BigDecimal.ZERO);
            } else {
                analysisVO.setValue(standardPrice.subtract(ticketPrice).divide(new BigDecimal(number), 1, 4));
                analysisVO.setText(sign + standardPrice.divide(new BigDecimal(number), 1, 4));
            }
            return analysisVO;
        }).collect(Collectors.toList());
    }

    private static List<AnalysisVO> getTicketPriceLineVO(List<AirExpenseAnalysisCardDTO> seriesDataList) {
        AmountHandler handler = AmountHelper.get();
        return seriesDataList.stream().map(airExpenseAnalysisCardDTO -> {
            AnalysisVO analysisVO = new AnalysisVO();
            String sign = handler.getCurrency().getString("sign");
            int number = airExpenseAnalysisCardDTO.getNumber();
            BigDecimal ticketPrice = airExpenseAnalysisCardDTO.getTicketPrice();
            BigDecimal lowestPrice = airExpenseAnalysisCardDTO.getLowestPrice();
            if (number == 0) {
                analysisVO.setValue(BigDecimal.ZERO);
                analysisVO.setText(sign + BigDecimal.ZERO);
            } else {
                analysisVO.setValue(ticketPrice.subtract(lowestPrice).divide(new BigDecimal(number), 1, 4));
                analysisVO.setText(sign + ticketPrice.divide(new BigDecimal(number), 1, 4));
            }
            return analysisVO;
        }).collect(Collectors.toList());
    }

    private static List<AnalysisVO> getLowestPriceLineVO(List<AirExpenseAnalysisCardDTO> seriesDataList) {
        AmountHandler handler = AmountHelper.get();
        return seriesDataList.stream().map(airExpenseAnalysisCardDTO -> {
            AnalysisVO analysisVO = new AnalysisVO();
            String sign = handler.getCurrency().getString("sign");
            int number = airExpenseAnalysisCardDTO.getNumber();
            BigDecimal lowestPrice = airExpenseAnalysisCardDTO.getLowestPrice();
            if (number == 0) {
                analysisVO.setValue(BigDecimal.ZERO);
                analysisVO.setText(sign + BigDecimal.ZERO);
            } else {
                BigDecimal averageLowestPrice = lowestPrice.divide(new BigDecimal(number), 1, 4);
                analysisVO.setValue(averageLowestPrice);
                analysisVO.setText(sign + averageLowestPrice);
            }
            return analysisVO;
        }).collect(Collectors.toList());
    }
}

