/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.formplugin.trader.graph;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.dto.ExistAndRebookCardDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.UnitEnum;
import kd.fi.er.mobile.formplugin.trader.vo.AnalysisVO;
import kd.fi.er.mobile.formplugin.trader.vo.ExistAndRebookAnalysisVO;
import kd.fi.er.mobile.service.trader.ExistAndRebookAnalysisDataHelperService;

public class ExistAndRebookAnalysisGraphHelper {
    public static void initAnalysisGraph(IFormView view, ParameterCardDTO parameterDTO) {
        AmountHelper.cacheAmountConvert((AmountConvertDTO)parameterDTO.getConvertDTO());
        CustomChart customChart = (CustomChart)view.getControl("customchartap");
        customChart.clearData();
        List<ExistAndRebookAnalysisVO> seriesDataList = ExistAndRebookAnalysisGraphHelper.getSeriesDataList(view, parameterDTO);
        boolean isEmptySixMonthRecently = ExistAndRebookAnalysisGraphHelper.setEmptyDataMessage(view, seriesDataList);
        if (isEmptySixMonthRecently) {
            return;
        }
        ExistAndRebookAnalysisGraphHelper.setToolTip(customChart);
        ExistAndRebookAnalysisGraphHelper.setGrid(customChart);
        ExistAndRebookAnalysisGraphHelper.setLegend(customChart);
        ExistAndRebookAnalysisGraphHelper.setXAxis(customChart);
        ExistAndRebookAnalysisGraphHelper.setYAxis(customChart, seriesDataList);
        ExistAndRebookAnalysisGraphHelper.setSeries(customChart, seriesDataList);
        view.updateView("customchartap");
    }

    private static boolean setEmptyDataMessage(IFormView view, List<ExistAndRebookAnalysisVO> seriesDataList) {
        List sixMonthRecentlyVOs = seriesDataList.stream().limit(6L).collect(Collectors.toList());
        if (sixMonthRecentlyVOs.stream().filter(ExistAndRebookAnalysisVO::isEmpty).count() == 6L) {
            ExistAndRebookAnalysisGraphHelper.setNoData(view, 0, ResManager.loadKDString((String)"\u8fd16\u4e2a\u6708\u672a\u53d1\u751f\u5dee\u65c5\u8ba2\u7968\u884c\u4e3a\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u67e5\u8be2\u6761\u4ef6", (String)"ExistAndRebookAnalysisGraphHelper_3", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
            return true;
        }
        ExistAndRebookAnalysisGraphHelper.setNoData(view, 2, null);
        if (seriesDataList.stream().limit(6L).anyMatch(ExistAndRebookAnalysisVO::isEmpty)) {
            view.setVisible(Boolean.TRUE, new String[]{"tip_panel"});
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            List emptyMonthStrList = sixMonthRecentlyVOs.stream().filter(ExistAndRebookAnalysisVO::isEmpty).map(vo -> String.format(ResManager.loadKDString((String)"%s\u6708", (String)"ExistAndRebookAnalysisGraphHelper_12", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), LocalDate.parse(vo.getOrderDateStr() + "-01", formatter).getMonthValue())).collect(Collectors.toList());
            Label tipLabel = (Label)view.getControl("tip_label");
            tipLabel.setText(String.format(ResManager.loadKDString((String)"%s\u672a\u53d1\u751f\u5dee\u65c5\u8ba2\u7968\u884c\u4e3a", (String)"ExistAndRebookAnalysisGraphHelper_5", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", emptyMonthStrList)));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tip_panel"});
        }
        return false;
    }

    public static List<ExistAndRebookAnalysisVO> getSeriesDataList(IFormView view, ParameterCardDTO parameterDTO) {
        AmountHelper.cacheAmountConvert((AmountConvertDTO)parameterDTO.getConvertDTO());
        Collection existAndRebookCardDTOS = ExistAndRebookAnalysisDataHelperService.getExistAndRebookCardDTOs((ParameterCardDTO)parameterDTO, null, (String)((String)view.getModel().getValue("radiogroupfield")));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        Map<String, List<ExistAndRebookCardDTO>> dtoGroupByDate = existAndRebookCardDTOS.stream().collect(Collectors.groupingBy(dto -> dateTimeFormatter.format(dto.getOrderDate())));
        ArrayList<ExistAndRebookAnalysisVO> existAndRebookAnalysisVOS = new ArrayList<ExistAndRebookAnalysisVO>(dtoGroupByDate.size());
        LocalDate date = LocalDate.now();
        String dateStr = dateTimeFormatter.format(date);
        String minDateStr = dtoGroupByDate.keySet().stream().min(String::compareTo).orElseGet(() -> dateTimeFormatter.format(LocalDate.now()));
        while (existAndRebookAnalysisVOS.size() < 6 || dateStr.compareTo(minDateStr) >= 0) {
            List<ExistAndRebookCardDTO> dtos = dtoGroupByDate.get(dateStr);
            ExistAndRebookAnalysisVO existAndRebookAnalysisVO = new ExistAndRebookAnalysisVO();
            existAndRebookAnalysisVO.setOrderDateStr(dateStr);
            if (!CollectionUtils.isEmpty(dtos)) {
                existAndRebookAnalysisVO.setRebookCost(dtos.stream().map(ExistAndRebookCardDTO::getRebookCost).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO));
                existAndRebookAnalysisVO.setExistCost(dtos.stream().map(ExistAndRebookCardDTO::getExistCost).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.ZERO));
                long countOfExistOrRebook = dtos.stream().filter(ExistAndRebookCardDTO::isExistOrRebook).count();
                existAndRebookAnalysisVO.setExistAndRebookPercent(new BigDecimal(countOfExistOrRebook).multiply(new BigDecimal("100")).divide(new BigDecimal(dtos.size()), 0, 4));
            } else {
                existAndRebookAnalysisVO.setEmpty(true);
            }
            existAndRebookAnalysisVOS.add(existAndRebookAnalysisVO);
            date = date.minusMonths(1L);
            dateStr = dateTimeFormatter.format(date);
        }
        existAndRebookAnalysisVOS.sort((vo1, vo2) -> vo2.getOrderDateStr().compareTo(vo1.getOrderDateStr()));
        if (view.getPageCache().get("CACHE_SHARE_VALUE") == null) {
            BigDecimal currentMonthCost = ((ExistAndRebookAnalysisVO)existAndRebookAnalysisVOS.get(0)).getRebookCost().add(((ExistAndRebookAnalysisVO)existAndRebookAnalysisVOS.get(0)).getExistCost());
            String currentMonthPercent = ((ExistAndRebookAnalysisVO)existAndRebookAnalysisVOS.get(0)).isEmpty() ? "-" : ((ExistAndRebookAnalysisVO)existAndRebookAnalysisVOS.get(0)).getExistAndRebookPercent() + "%";
            String shareValue = String.format(ResManager.loadKDString((String)"\u5f53\u6708\u9000\u6539\u7b7e\u635f\u5931\u91d1\u989d\uff1a%1$s\uff0c\u9000\u6539\u7b7e\u5360\u6bd4\uff1a%2$s\uff0c\u70b9\u51fb\u67e5\u770b\u8d8b\u52bf", (String)"ExistAndRebookAnalysisGraphHelper_13", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AmountHelper.text((BigDecimal)currentMonthCost), currentMonthPercent);
            view.getPageCache().put("CACHE_SHARE_VALUE", shareValue);
        }
        return existAndRebookAnalysisVOS;
    }

    private static void setToolTip(CustomChart customChart) {
        customChart.setShowTooltip(true);
        customChart.addTooltip("trigger", (Object)"axis");
        customChart.addTooltip("formatter", (Object)"function(params){return params[0].name + '<br/>' + params[0].seriesName+' : ' + params[0].data.text+ '<br/>' + params[1].seriesName+' : ' + params[1].data.text+ '<br/>' + params[2].seriesName+' : ' + params[2].data.text;}");
        ArrayList<String> formatterPathList = new ArrayList<String>();
        formatterPathList.add("tooltip");
        formatterPathList.add("formatter");
        customChart.addFuncPath(formatterPathList);
    }

    private static void setGrid(CustomChart customChart) {
        customChart.setMargin(Position.top, "12%");
        customChart.setMargin(Position.bottom, "12%");
        customChart.setMargin(Position.left, "7%");
    }

    private static void setLegend(CustomChart customChart) {
        customChart.setShowLegend(true);
        customChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        customChart.setLegendPropValue("bottom", (Object)1);
        customChart.setLegendPropValue("data", (Object)M.arraylist((Object[])new Object[]{ResManager.loadKDString((String)"\u6539\u7b7e\u635f\u5931", (String)"ExistAndRebookAnalysisGraphHelper_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9000\u7968\u635f\u5931", (String)"ExistAndRebookAnalysisGraphHelper_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9000\u6539\u7b7e\u5360\u6bd4", (String)"ExistAndRebookAnalysisGraphHelper_9", (String)"fi-er-mb-formplugin", (Object[])new Object[0])}));
    }

    private static void setXAxis(CustomChart customChart) {
        LocalDate now = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        Axis xAxis = customChart.createXAxis("", AxisType.category);
        xAxis.setPropValue("axisPointer", (Object)M.map((String)"type", (Object)"shadow"));
        xAxis.setPropValue("axisLabel", (Object)M.map((String)"textStyle", (Object)M.map((String)"fontSize", (Object)8)));
        xAxis.setPropValue("inverse", (Object)Boolean.TRUE);
        xAxis.setPropValue("data", (Object)M.arraylist((Object[])new Object[]{dateTimeFormatter.format(now), dateTimeFormatter.format(now.minusMonths(1L)), dateTimeFormatter.format(now.minusMonths(2L)), dateTimeFormatter.format(now.minusMonths(3L)), dateTimeFormatter.format(now.minusMonths(4L)), dateTimeFormatter.format(now.minusMonths(5L))}));
    }

    private static void setYAxis(CustomChart customChart, List<ExistAndRebookAnalysisVO> seriesDataList) {
        UnitEnum yAxisUnit = ExistAndRebookAnalysisGraphHelper.getYAxisUnit(seriesDataList);
        Axis amountYAxis = customChart.createYAxis(String.format(ResManager.loadKDString((String)"\u635f\u5931\u91d1\u989d : %1$s", (String)"ExistAndRebookAnalysisGraphHelper_14", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), yAxisUnit.getDesc()), AxisType.value);
        amountYAxis.setPropValue("splitLine", (Object)M.map().kv("fontSize", (Object)8));
        Axis percentYAxis = customChart.createYAxis(ResManager.loadKDString((String)"\u5360\u6bd4\uff1a%", (String)"ExistAndRebookAnalysisGraphHelper_11", (String)"fi-er-mb-formplugin", (Object[])new Object[0]), AxisType.value);
        percentYAxis.setMin((Number)0);
        percentYAxis.setMax((Number)100);
        percentYAxis.setPropValue("splitLine", (Object)M.map().kv("show", (Object)Boolean.FALSE).kv("fontSize", (Object)8));
        percentYAxis.setPropValue("axisLabel", (Object)M.map((String)"formatter", (Object)"{value}"));
    }

    private static void setSeries(CustomChart customChart, List<ExistAndRebookAnalysisVO> seriesDataList) {
        UnitEnum yAxisUnit = ExistAndRebookAnalysisGraphHelper.getYAxisUnit(seriesDataList);
        BarSeries rebookCostSeries = customChart.createBarSeries(ResManager.loadKDString((String)"\u6539\u7b7e\u635f\u5931", (String)"ExistAndRebookAnalysisGraphHelper_7", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        rebookCostSeries.setStack("cost");
        rebookCostSeries.setBarWidth("15");
        rebookCostSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        rebookCostSeries.setPropValue("data", ExistAndRebookAnalysisGraphHelper.getRebookEChartVO(seriesDataList, yAxisUnit));
        rebookCostSeries.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#505BF9")));
        BarSeries existCostSeries = customChart.createBarSeries(ResManager.loadKDString((String)"\u9000\u7968\u635f\u5931", (String)"ExistAndRebookAnalysisGraphHelper_8", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        existCostSeries.setStack("cost");
        existCostSeries.setBarWidth("15");
        existCostSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        existCostSeries.setPropValue("data", ExistAndRebookAnalysisGraphHelper.getExistEChartVO(seriesDataList, yAxisUnit));
        existCostSeries.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#45DAD1")));
        LineSeries percentSeries = customChart.createLineSeries(ResManager.loadKDString((String)"\u9000\u6539\u7b7e\u5360\u6bd4", (String)"ExistAndRebookAnalysisGraphHelper_9", (String)"fi-er-mb-formplugin", (Object[])new Object[0]));
        percentSeries.setYAxisIndex(1);
        percentSeries.setPropValue("data", ExistAndRebookAnalysisGraphHelper.getPercentEChartVO(seriesDataList));
        percentSeries.setPropValue("label", (Object)M.map().kv("normal", (Object)M.map().kv("show", (Object)Boolean.FALSE)));
        percentSeries.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", (Object)"#FFC13F")));
    }

    private static List<AnalysisVO> getRebookEChartVO(List<ExistAndRebookAnalysisVO> seriesDataList, UnitEnum yAxisUnit) {
        return seriesDataList.stream().map(data -> {
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setValue(ExistAndRebookAnalysisGraphHelper.getCostAmountByUnit(data.getRebookCost(), yAxisUnit));
            analysisVO.setText(AmountHelper.text((BigDecimal)data.getRebookCost()));
            return analysisVO;
        }).collect(Collectors.toList());
    }

    private static List<AnalysisVO> getExistEChartVO(List<ExistAndRebookAnalysisVO> seriesDataList, UnitEnum yAxisUnit) {
        return seriesDataList.stream().map(data -> {
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setValue(ExistAndRebookAnalysisGraphHelper.getCostAmountByUnit(data.getExistCost(), yAxisUnit));
            analysisVO.setText(AmountHelper.text((BigDecimal)data.getExistCost()));
            return analysisVO;
        }).collect(Collectors.toList());
    }

    private static List<AnalysisVO> getPercentEChartVO(List<ExistAndRebookAnalysisVO> seriesDataList) {
        return seriesDataList.stream().limit(6L).map(data -> {
            AnalysisVO analysisVO = new AnalysisVO();
            analysisVO.setValue(data.isEmpty() ? null : data.getExistAndRebookPercent());
            analysisVO.setText(data.isEmpty() ? "-" : data.getExistAndRebookPercent() + "%");
            return analysisVO;
        }).collect(Collectors.toList());
    }

    private static UnitEnum getYAxisUnit(List<ExistAndRebookAnalysisVO> seriesDataList) {
        BigDecimal maxCost = seriesDataList.stream().map(data -> data.getExistCost().add(data.getRebookCost())).max(BigDecimal::compareTo).orElseGet(() -> BigDecimal.ZERO);
        return AmountHelper.getUnitEnum((BigDecimal)maxCost);
    }

    private static BigDecimal getCostAmountByUnit(BigDecimal costAmount, UnitEnum unitEnum) {
        return costAmount.divide(unitEnum.getScale(), AmountHelper.getAmtPrecision(), 4);
    }

    private static void setNoData(IFormView view, int dataTag, String tip) {
        view.getModel().setValue("datatag", (Object)dataTag);
        if (tip != null) {
            Label defaultlabel = (Label)view.getControl("defaultlabel");
            defaultlabel.setText(tip);
        }
    }
}

