/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.formplugin.budget;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;

public class BillShowBudgetEAS
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(BillShowBudgetEAS.class);
    private static final String BAR_VIEW_EAS_BUDGET = "bar_vieweasbudget";
    private static final String ER_SHOW_EAS_BUDGET = "er_showeasbudget";
    private static final String BUDGETAMOUNT = "budgetamount:";

    public void registerListener(EventObject e) {
        EntryGrid expenseEntry;
        super.registerListener(e);
        EntryGrid tripEntry = (EntryGrid)this.getView().getControl("tripentry");
        if (tripEntry != null) {
            tripEntry.addRowClickListener((RowClickEventListener)this);
        }
        if ((expenseEntry = (EntryGrid)this.getView().getControl("expenseentryentity")) != null) {
            expenseEntry.addRowClickListener((RowClickEventListener)this);
        }
        this.addItemClickListeners(new String[]{"bar_reim"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BAR_VIEW_EAS_BUDGET});
        BudgetCommonUtil.setIsTripReqShowExpenseitemFlag(this.getPageCache(), true);
        if (Boolean.parseBoolean(IscHelper.getISCSettingValue((String)"is_query_eas_budget_now"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"budgetamount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"budgetmsg"});
            BudgetCommonUtil.setIsQueryEASBudgetFlag(this.getPageCache(), true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
            BudgetCommonUtil.setIsQueryEASBudgetFlag(this.getPageCache(), false);
        }
        this.inEASBgExcludeOrgs();
    }

    private void inEASBgExcludeOrgs() {
        Long company = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        Set<Long> easBgExcludeOrg = BudgetCommonUtil.getEASBgExcludeOrg();
        if (easBgExcludeOrg != null && easBgExcludeOrg.contains(company)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"budgetamount"});
            BudgetCommonUtil.setIsQueryEASBudgetFlag(this.getPageCache(), false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.mobSecondPageBindData();
        this.budgeMsgControlBindData();
    }

    private void budgeMsgControlBindData() {
        String budgeMsgValue;
        Long company;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object companyObj = model.getValue("company");
        if (companyObj == null) {
            companyObj = this.getView().getParentView().getModel().getValue("company");
        }
        if ((company = ErCommonUtils.getPk((Object)companyObj)) == null || company.compareTo(0L) == 0) {
            company = RequestContext.get().getOrgId();
        }
        if ("0".equals(budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)company, (String)"budgeMsgControl"))) {
            view.setVisible(Boolean.TRUE, new String[]{"budgetamount"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetmsg"});
        } else if ("1".equals(budgeMsgValue)) {
            view.setVisible(Boolean.TRUE, new String[]{"budgetmsg"});
            view.setVisible(Boolean.FALSE, new String[]{"budgetamount"});
        }
    }

    private void mobSecondPageBindData() {
        if (!BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
            return;
        }
        boolean isMob = this.getView() instanceof IMobileView;
        if (!isMob) {
            return;
        }
        if (this.getView().getParentView() == null || this.getView().getParentView().getModel() == null) {
            return;
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        if (parentModel.getProperty("formid") == null || parentModel.getValue("formid") == null) {
            return;
        }
        this.buildBudgetAmountField(BUDGETAMOUNT, 0);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String msg = this.showShareBgTipMsg();
        if (msg != null) {
            this.getView().showTipNotification(msg);
            return;
        }
        if (BAR_VIEW_EAS_BUDGET.equals(key)) {
            this.showEASBg();
        }
    }

    private boolean getIsBeforeShareValue(DynamicObject dynamicObject) {
        return dynamicObject.getDynamicObjectType().getProperties().get((Object)"isbeforeshare") == null || dynamicObject.getBoolean("isbeforeshare");
    }

    private boolean getBillStatusValue(DynamicObject dynamicObject) {
        return dynamicObject.getDynamicObjectType().getProperties().get((Object)"billstatus") == null || dynamicObject.getString("billstatus").equals("A");
    }

    private Boolean isQueryShareBg() {
        DynamicObject parentDO;
        DynamicObject currentDO = this.getModel().getDataEntity();
        if (this.getIsBeforeShareValue(currentDO) || this.getBillStatusValue(currentDO)) {
            return false;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (this.getIsBeforeShareValue(parentDO = parentView.getModel().getDataEntity()) || this.getBillStatusValue(parentDO))) {
            return false;
        }
        IPageCache pageCache = this.getPageCache();
        Object isQueryEASBgByShare = BudgetCommonUtil.getIsQueryEASBgByShare(pageCache);
        if (isQueryEASBgByShare == null) {
            if (IscHelper.getEasShareBgIscNumber((DynamicObject)currentDO) == null) {
                BudgetCommonUtil.setIsQueryEASBgByShare(pageCache, false);
                return false;
            }
            BudgetCommonUtil.setIsQueryEASBgByShare(pageCache, true);
            return true;
        }
        return (Boolean)isQueryEASBgByShare;
    }

    private String showShareBgTipMsg() {
        if (this.isQueryShareBg().booleanValue()) {
            return ResManager.loadKDString((String)"\u4e8b\u524d\u5206\u644a\u4ec5\u63d0\u4ea4\u540e\u53ef\u67e5\u770b\u9884\u7b97\u3002", (String)"BillShowBudgetEAS_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void showEASBg() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId(ER_SHOW_EAS_BUDGET);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u67e5\u8be2", (String)"BillShowBudgetEAS_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        formShowParameter.setParentPageId(this.getView().getPageId());
        this.getView().showForm(formShowParameter);
    }

    public void entryRowClick(RowClickEvent arg0) {
        if (!BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
            return;
        }
        boolean isMob = this.getView() instanceof IMobileView;
        if (isMob) {
            return;
        }
        EntryGrid source = (EntryGrid)arg0.getSource();
        String key = source.getKey();
        int rowIndex = arg0.getRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        switch (key) {
            case "tripentry": 
            case "expenseentryentity": {
                DynamicObject rowEntry;
                DynamicObjectCollection rowEntrys = this.getModel().getEntryEntity(key);
                if (rowEntrys == null || rowEntrys.isEmpty() || (rowEntry = (DynamicObject)rowEntrys.get(rowIndex)).getDynamicObjectType().getProperties().get((Object)"expenseitem") != null && rowEntry.get("expenseitem") == null || rowEntry.getDynamicObjectType().getProperties().get((Object)"tripexpenseitem") != null && rowEntry.get("tripexpenseitem") == null || this.isQueryShareBg().booleanValue()) break;
                this.buildBudgetAmountField(BUDGETAMOUNT, rowIndex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
            return;
        }
        if (this.isQueryShareBg().booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if (propValue == null) {
            return;
        }
        boolean notQueryBgFlag = true;
        if ("expenseitem".equalsIgnoreCase(propName) || "std_project".equalsIgnoreCase(propName) || "tripexpenseitem".equalsIgnoreCase(propName)) {
            notQueryBgFlag = false;
        }
        if (notQueryBgFlag) {
            return;
        }
        IFormView view = this.getView();
        boolean isPc = !(view instanceof IMobileView);
        IDataModel model = this.getModel();
        boolean isDailyBill = false;
        if (model.getProperty("expenseitem") != null && "expenseentryentity".equalsIgnoreCase(model.getProperty("expenseitem").getParent().getName())) {
            isDailyBill = true;
        }
        if (isPc && !"er_tripentryedit".equalsIgnoreCase(view.getEntityId()) && !isDailyBill) {
            return;
        }
        int rowIndex = valueSet[0].getRowIndex();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        this.buildBudgetAmountField(BUDGETAMOUNT, rowIndex);
    }

    private void buildBudgetAmountField(String key, int rowIndex) {
        this.getView().addClientCallBack(key.concat(String.valueOf(rowIndex)));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        this.budgetCallBack(e);
    }

    private void budgetCallBack(ClientCallBackEvent event) {
        int rowIndex = -1;
        DynamicObject bgDO = null;
        String name = event.getName();
        if (!name.startsWith(BUDGETAMOUNT)) {
            return;
        }
        rowIndex = Integer.parseInt(name.replace(BUDGETAMOUNT, ""));
        bgDO = BudgetCommonUtil.genBgDynamicObject(this.getView(), rowIndex);
        if (bgDO == null) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String iscNumber = IscHelper.getEasBgIscNumber((DynamicObject)bgDO);
        String notification = this.showShareBgTipMsg();
        Object bgJson = null;
        try {
            String flowNumber = IscHelper.getISCSettingValue((String)"eas_query_bg_flownum");
            bgJson = StringUtils.isNotBlank((CharSequence)flowNumber) ? IscHelper.execBudgetService((String)flowNumber, (String)"queryEASBillBudget", (String)IscHelper.buildTargetBillJson((DynamicObject)bgDO, (String)iscNumber)) : IscHelper.doEASFacade((String)"queryEASBillBudget", (Object)IscHelper.buildTargetBillJson((DynamicObject)bgDO, (String)iscNumber));
        }
        catch (KDBizException kdExcepetion) {
            logger.info("EAS\u96c6\u6210,\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u96c6\u6210\u5e73\u53f0\u8f6c\u6362\u5355\u636e\u6570\u636e\u51fa\u9519 \u6216\u8005 \u96c6\u6210\u4e91\u8bbe\u7f6e-\u8fde\u63a5\u914d\u7f6e\u7f16\u7801\u4e0d\u5b58\u5728:" + kdExcepetion.getMessage());
            view.showErrorNotification(notification != null ? notification : ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u5931\u8d25\u3002\u539f\u56e0\u53ef\u80fd\u662f\u96c6\u6210\u5e73\u53f0\u8f6c\u6362\u5355\u636e\u6570\u636e\u51fa\u9519\u6216\u8005\u201c\u96c6\u6210\u4e91\u8bbe\u7f6e>\u8fde\u63a5\u914d\u7f6e\u201d\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillShowBudgetEAS_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        catch (Exception e) {
            logger.error("EAS\u96c6\u6210,\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!\u8be6\u7ec6\u4fe1\u606f:", (Throwable)e);
            String detail = ErExceptionServiceHelper.getStackTrace((Throwable)e);
            int start = detail.lastIndexOf("BgControlException:");
            if (start == -1) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-774784", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
            } else {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u8be6\u7ec6\u4fe1\u606f:%s", (String)"BillShowBudgetEAS_2", (String)"fi-er-formplugin", (Object[])new Object[0]), IscHelper.getExceptionDescription((String)detail)));
            }
            return;
        }
        if (bgJson == null || String.valueOf(bgJson).isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u9884\u7b97\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u96c6\u6210\u65b9\u6848\u3002", (String)"BillShowBudgetEAS_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Map bgJsonMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(bgJson), Map.class);
        if (bgJsonMap == null || bgJsonMap.size() < 1 || bgJsonMap.get("budgetdata") == null) {
            model.setValue("budgetamount", (Object)BudgetCommonUtil.getMsgNoBudgetControlStr(), rowIndex);
            return;
        }
        List bgList = (List)bgJsonMap.get("budgetdata");
        if (bgList == null || bgList.isEmpty()) {
            model.setValue("budgetamount", (Object)BudgetCommonUtil.getMsgNoBudgetControlStr(), rowIndex);
            return;
        }
        Map bgMap = (Map)bgList.get(0);
        if (bgMap == null || bgMap.size() < 1) {
            model.setValue("budgetamount", (Object)BudgetCommonUtil.getMsgNoBudgetControlStr(), rowIndex);
            return;
        }
        logger.info("BillShowBudgetEAS>>>budgetCallBack:\n" + bgMap.toString());
        if (((Boolean)bgMap.get("success")).booleanValue()) {
            Object bgAmount = bgMap.get("budgetamount");
            if (bgAmount == null) {
                model.setValue("budgetamount", (Object)BudgetCommonUtil.getMsgNoBudgetControlStr(), rowIndex);
                return;
            }
            String currencySign = "";
            if ("CNY".equalsIgnoreCase(String.valueOf(bgMap.get("currencyNumber")))) {
                currencySign = "\uffe5";
            } else {
                currencySign = String.valueOf(bgMap.get("currency"));
                if (StringUtils.isBlank((CharSequence)currencySign)) {
                    currencySign = String.valueOf(bgMap.get("currencyName"));
                }
            }
            String labelAmountAfterFormat = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)this.convertToBigDecimal(bgAmount), (int)2);
            model.setValue("budgetamount", (Object)labelAmountAfterFormat, rowIndex);
            BigDecimal budget = bgMap.getOrDefault("budget", BigDecimal.ZERO);
            String budgetStr = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u6570\uff1a%1$s ", (String)"BillShowBudgetEAS_5", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)this.convertToBigDecimal(budget), (int)2));
            BigDecimal actual = bgMap.getOrDefault("actual", BigDecimal.ZERO);
            String actualStr = String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\uff1a%1$s ", (String)"BillShowBudgetEAS_6", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)this.convertToBigDecimal(actual), (int)2));
            BigDecimal balance = bgMap.getOrDefault("balance", BigDecimal.ZERO);
            String balanceStr = String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\uff1a%1$s ", (String)"BillShowBudgetEAS_7", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)this.convertToBigDecimal(balance), (int)2));
            logger.info("BillShowBudgetEAS>>>budgetCallBack:budget {},actual {}, balance {}", new Object[]{budget.getClass(), actual.getClass(), balance.getClass()});
            model.setValue("budgetmsg", (Object)(budgetStr + actualStr + balanceStr), rowIndex);
        }
    }

    private BigDecimal convertToBigDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        return BigDecimal.ZERO;
    }
}

