/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.amount.control;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;

public class FeeStandardSelectMob
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fillbill"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("fillbill".equals(((Control)evt.getSource()).getKey())) {
            IFormView view = this.getView();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = entryGrid.getSelectRows();
            if (selectedRows.length == 0) {
                view.showMessage(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u6761\u8d39\u7528\u6807\u51c6\u3002", (String)"FeeStandardSelect_please_sel", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            if (parentView != null) {
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])this.getPks(selectedRows), (String)"er_standard");
                List headPropDimensions = FeeStandardHelper.getHeadPropDimensions((IFormView)parentView);
                if (selectedRows.length > 1 && FeeStandardHelper.existHeadProp((IDataModel)parentView.getModel()) && this.dimensionConflict(loadFromCache, headPropDimensions)) {
                    view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u6807\u51c6\u7684\u4e1a\u52a1\u4fe1\u606f\u4e0d\u5b8c\u5168\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FeeStandardSelect_please_resel", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.needConfirm(loadFromCache, headPropDimensions, parentView)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u6807\u51c6\u7684\u4e1a\u52a1\u4fe1\u606f\u4e0e\u5355\u636e\u73b0\u6709\u4e1a\u52a1\u4fe1\u606f\u51b2\u7a81\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"FeeStandardSelect_confirm_cover", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cover", (IFormPlugin)this));
                    return;
                }
            }
            view.returnDataToParent((Object)this.getPks(selectedRows));
            view.close();
        }
    }

    private Object[] getPks(int[] selectedRows) {
        Object[] pks = new Object[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            pks[i] = this.getModel().getValue("feestandid", selectedRows[i]);
        }
        return pks;
    }

    private boolean needConfirm(Map<Object, DynamicObject> loadFromCache, List<String> headPropDimensions, IFormView parentView) {
        DynamicObject feeStand = loadFromCache.values().iterator().next();
        for (String dimension : headPropDimensions) {
            Object value = parentView.getModel().getValue(dimension);
            if (value == null || FeeStandardHelper.equals((Object)feeStand.get(dimension), (Object)value)) continue;
            return true;
        }
        return FeeStandardHelper.existHeadProp((IDataModel)parentView.getModel());
    }

    private boolean dimensionConflict(Map<Object, DynamicObject> loadFromCache, List<String> headPropDimensions) {
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)loadFromCache.size());
        for (DynamicObject feeStand : loadFromCache.values()) {
            for (String dimension : headPropDimensions) {
                Object value = feeStand.get(dimension);
                dimensionMap.putIfAbsent(dimension, value);
                if (FeeStandardHelper.equals(dimensionMap.get(dimension), (Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        this.paintEntry();
    }

    private void paintEntry() {
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            DynamicObject company = (DynamicObject)parentView.getModel().getValue("company");
            DynamicObject bizitem = (DynamicObject)parentView.getModel().getValue("bizitem");
            Collection myFeeStandard = FeeStandardHelper.queryFeeStandard((DynamicObject)company, (DynamicObject)bizitem);
            Iterator iterator = myFeeStandard.iterator();
            if (!myFeeStandard.isEmpty()) {
                this.getModel().beginInit();
                int[] rowIndexs = this.getModel().batchCreateNewEntryRow("entryentity", myFeeStandard.size());
                int i = 0;
                while (iterator.hasNext()) {
                    DynamicObject feeStand = (DynamicObject)iterator.next();
                    this.getModel().setValue("feestandid", feeStand.getPkValue(), rowIndexs[i]);
                    this.getModel().setValue("stardardtype", feeStand.get("stardardtype"), rowIndexs[i]);
                    this.getModel().setValue("dimension", feeStand.get("dimension"), rowIndexs[i]);
                    this.getModel().setValue("feestandstr", (Object)FeeStandardHelper.getDesc((DynamicObject)feeStand), rowIndexs[i]);
                    this.getModel().setValue("expenseitem", feeStand.get("expenseitem"), rowIndexs[i]);
                    if (feeStand.getBoolean("otherstand")) {
                        this.getModel().setValue("otherstand", (Object)true, rowIndexs[i]);
                        this.getModel().setValue("otherfeestandstr", (Object)FeeStandardHelper.getOtherDesc((DynamicObject)feeStand), rowIndexs[i]);
                    }
                    ++i;
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            } else {
                this.getModel().setValue("datatag", (Object)0);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("cover".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectedRows = entryGrid.getSelectRows();
            IFormView view = this.getView();
            view.returnDataToParent((Object)this.getPks(selectedRows));
            view.close();
        }
    }
}

