/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.billingpool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.billingpool.IBillingPoolPlugin;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import kd.fi.er.formplugin.util.FormOperateUtil;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolPlugin
extends AbstractBillPlugIn
implements IBillingPoolPlugin {
    private static final Log logger = LogFactory.getLog(BillingPoolPlugin.class);
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String BILL_TYPE = "billtype";
    private static final String ENTRY_TAX_RATE = "invoiceitembasetaxrate";
    private static final String ENTRY_TAX_AMOUNT = "invoiceitemtaxamount";
    private static final String ENTRY_NO_TAX_AMOUNT = "excludeamount";
    private static final String DEDUCT_AMOUNT = "offsetamount";
    private static final String TAX_AMOUNT = "taxamount_invoice";
    private static final String TOTAL_AMOUNT = "totalamount";
    private static final String TAX_RATE = "basealltaxrate";
    private static final String NO_TAX_AMOUNT = "invoicenotaxamount";
    private static final String USED_AMOUNT = "oriusedamount";
    private static final String SOURCE = "invoicefrom";
    private static final String ORICURRENCY = "invoicecurrency";
    private static final String BTN_AUDIT = "bar_audit";
    private static final String ACTION = "actionType";
    private static final String DEFAULT_LAYOUT = "er_billingpool_BT_GENERIC";
    private static final String DB_BILLTYPE = "bos_billtype";
    private static final String IS_GEN_VOUCHER = "hasvoucher";
    private static final String SHOW_DETAIL = "showdetail";
    private static final String TRACKDOWN = "trackdown";
    private static final String UNAUDIT = "bar_unaudit";
    private static final String INVOICE_NO = "invoiceno";
    public static final int PRECISION = 4;
    public static final long DIVISIOR = 100L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"addnewrow"});
        this.addClickListeners(new String[]{"btnok"});
        this.initF7Filter();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        model.beginInit();
        this.initType(parameter);
        model.endInit();
        IFormView view = this.getView();
        model.setValue("formid", (Object)view.getEntityId());
        ShowUserInfoUtils.initUserInfo((IDataModel)model, (IFormView)view);
        this.initNewData(parameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        if (null != applier) {
            String applierStr = applier.getLocaleString("name").getLocaleValue();
            ((Label)this.getView().getControl("applierv")).setText(applierStr);
        }
        ((EntryGrid)this.getView().getControl("entryentity")).setMustInput("entryamount", ((Boolean)this.getModel().getValue(SHOW_DETAIL)).booleanValue());
        if (FormOperateUtil.isCopyOperate((EventObject)e)) {
            // empty if block
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setFromStatus((AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        this.setValidateOrg(propName);
        switch (propName) {
            case "billpooltype": {
                this.toggleBillingPoolType(null);
                break;
            }
            case "costdept": {
                if (newValue == null) {
                    newValue = valueSet[0].getOldValue();
                    model.setValue("costdept", ((DynamicObject)newValue).getPkValue());
                }
                this.costDeptChange(propName, (DynamicObject)newValue);
                break;
            }
            case "costcompany": {
                Object company = this.getModel().getValue("company");
                Long companyID = ErCommonUtils.getPk((Object)company);
                DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyID, (Object)ErCommonUtils.getPk((Object)newValue));
                if (currency == null) break;
                model.setValue("currency", (Object)currency);
                break;
            }
            case "projecttype": {
                DynamicObject basedataDOFromCache;
                List numbers;
                DynamicObject costCompany;
                Object expenseItem = this.getModel().getValue("headexpenseitem");
                if (null == expenseItem || newValue == null) break;
                QFilter qf = QFilter.of((String)"id=?", (Object[])new Object[]{ErCommonUtils.getPk((Object)expenseItem)}).and(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE})).and("enable", "=", (Object)Boolean.TRUE);
                QFilter relBillFilter = ExpenseItemServiceHelper.getRelBillFilter((String)model.getDataEntityType().getName());
                qf = qf.and(relBillFilter);
                Long deptID = ErCommonUtils.getPk((Object)this.getModel().getValue("costdept"));
                if (null != deptID) {
                    QFilter relDeptFilter = ExpenseItemServiceHelper.getRelDeptFilter((Long)deptID);
                    qf = qf.and(relDeptFilter);
                }
                if (null != (costCompany = (DynamicObject)model.getValue("costcompany"))) {
                    qf = qf.and(BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)((Long)costCompany.getPkValue())));
                }
                if (!(numbers = ((DynamicObject)newValue).getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).isEmpty()) {
                    QFilter qFilter = new QFilter("id", "in", numbers);
                    qf = qf.and(qFilter);
                }
                if (null != (basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"id,offset", (QFilter[])new QFilter[]{qf}))) break;
                model.setValue("headexpenseitem", null);
                break;
            }
            case "entryamount": {
                this.refreshTaxAndNoTax(rowIndex, "entryamount", ENTRY_TAX_RATE, ENTRY_NO_TAX_AMOUNT, ENTRY_TAX_AMOUNT, true);
                this.getView().updateView();
                break;
            }
            case "invoiceitembasetaxrate": {
                if (null == newValue) {
                    this.setValNoLink(ENTRY_TAX_AMOUNT, null, rowIndex);
                    this.setValUpdateView(TAX_RATE, null, -1);
                }
                this.refreshTaxAndNoTax(rowIndex, "entryamount", ENTRY_TAX_RATE, ENTRY_NO_TAX_AMOUNT, ENTRY_TAX_AMOUNT, true);
                this.getView().updateView();
                break;
            }
            case "invoiceitemtaxamount": {
                this.refreshNoTax(rowIndex, "entryamount", ENTRY_NO_TAX_AMOUNT, ENTRY_TAX_AMOUNT, true);
                this.getView().updateView();
                break;
            }
            case "totalamount": {
                BigDecimal usedAmount;
                this.refreshTaxAndNoTax(-1, TOTAL_AMOUNT, TAX_RATE, NO_TAX_AMOUNT, TAX_AMOUNT, false);
                this.getView().updateView();
                BigDecimal totalAmount = (BigDecimal)this.getModel().getValue(TOTAL_AMOUNT);
                if (null == totalAmount) {
                    totalAmount = BigDecimal.ZERO;
                }
                if (null == (usedAmount = (BigDecimal)this.getModel().getValue(USED_AMOUNT))) {
                    usedAmount = BigDecimal.ZERO;
                }
                totalAmount = totalAmount.subtract(usedAmount);
                this.getModel().setValue("oribalanceamount", (Object)totalAmount);
                break;
            }
            case "basealltaxrate": {
                if (null == newValue) {
                    this.setValNoLink(TAX_AMOUNT, null, -1);
                }
                this.refreshTaxAndNoTax(-1, TOTAL_AMOUNT, TAX_RATE, NO_TAX_AMOUNT, TAX_AMOUNT, false);
                this.getView().updateView();
                break;
            }
            case "taxamount_invoice": {
                this.refreshNoTax(rowIndex, TOTAL_AMOUNT, NO_TAX_AMOUNT, TAX_AMOUNT, false);
                this.getView().updateView();
                break;
            }
            case "hasvoucher": {
                Control voucherno = this.getView().getControl("voucherno");
                if (null == voucherno) break;
                ((FieldEdit)voucherno).setMustInput("1".equals(newValue));
                break;
            }
            case "showdetail": {
                boolean isTrue = (Boolean)newValue;
                EntryGrid entityGrid = (EntryGrid)this.getView().getControl("entryentity");
                if (isTrue) {
                    entityGrid.setMustInput("entryamount", true);
                    model.beginInit();
                    this.getModel().setValue(TOTAL_AMOUNT, null);
                    this.getModel().setValue(TAX_RATE, null);
                    this.getModel().setValue(TAX_AMOUNT, null);
                    this.getModel().setValue(NO_TAX_AMOUNT, null);
                    model.endInit();
                    this.getView().updateView();
                    break;
                }
                entityGrid.setMustInput("entryamount", false);
                DynamicObjectCollection entities = model.getEntryEntity("entryentity");
                if (!CollectionUtils.isNotEmpty((Collection)entities)) break;
                int[] indexs = IntStream.range(0, entities.size()).toArray();
                this.getModel().deleteEntryRows("entryentity", indexs);
                break;
            }
            case "num": 
            case "unitprice": {
                break;
            }
            case "invoicetype": {
                String invoiceType;
                boolean isTaxPaymentCert = false;
                if (newValue != null && StringUtils.equals((CharSequence)(invoiceType = ((DynamicObject)newValue).getString("number")), (CharSequence)InvoiceTypeEnum.key_19.getValue())) {
                    isTaxPaymentCert = true;
                }
                ((FieldEdit)this.getView().getControl(INVOICE_NO)).setMustInput(isTaxPaymentCert);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addnewrow": {
                DynamicObject invoiceType = (DynamicObject)this.getModel().getValue(INVOICE_TYPE);
                if (null != invoiceType) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968\u7c7b\u578b\u3002", (String)"BillPoolPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "bar_unaudit": {
                this.unAudit(this.getModel().getDataEntity(true), this.getView(), evt);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_audit": {
                this.setFromStatus((AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctl;
        String key;
        Object source = evt.getSource();
        if (source instanceof Control && StringUtils.equals((CharSequence)(key = (ctl = (Control)source).getKey()), (CharSequence)"btnok")) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            this.getView().returnDataToParent((Object)obj);
            this.getView().close();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        Boolean isCopy = Boolean.valueOf(this.getPageCache().get("isentrycopy"));
        this.getPageCache().remove("isentrycopy");
        this.setValUpdateView(TAX_RATE, null, -1);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            this.sumTotalAmount();
            this.getView().updateView();
        }
    }

    private void sumTotalAmount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntities = model.getEntryEntity("entryentity");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal deductibleTax = BigDecimal.ZERO;
        HashSet<Long> taxRateSet = new HashSet<Long>(1);
        model.beginInit();
        if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
            for (DynamicObject item : entryEntities) {
                BigDecimal entryTax = item.getBigDecimal(ENTRY_TAX_AMOUNT);
                BigDecimal entryTotal = item.getBigDecimal("entryamount");
                Long taxRate = ErCommonUtils.getPk((Object)item.getDynamicObject(ENTRY_TAX_RATE));
                if (null == entryTax) {
                    entryTax = BigDecimal.ZERO;
                }
                if (null == entryTotal) {
                    entryTotal = BigDecimal.ZERO;
                }
                taxRateSet.add(taxRate);
                totalAmount = totalAmount.add(entryTotal);
                taxAmount = taxAmount.add(entryTax);
            }
        } else {
            model.setValue(TAX_RATE, null);
        }
        this.getModel().setValue(TAX_AMOUNT, (Object)taxAmount);
        this.getModel().setValue(TOTAL_AMOUNT, (Object)totalAmount);
        this.getModel().setValue(DEDUCT_AMOUNT, (Object)deductibleTax);
        this.getModel().setValue(NO_TAX_AMOUNT, (Object)totalAmount.subtract(taxAmount));
        if (CollectionUtils.isEmpty(taxRateSet) || taxRateSet.stream().allMatch(Objects::isNull) || taxRateSet.size() > 1) {
            model.setValue(TAX_RATE, null);
        } else {
            model.setValue(TAX_RATE, taxRateSet.stream().findFirst().orElse(null));
        }
        model.endInit();
    }

    private void initType(BillShowParameter parameter) {
        QFilter qFilter;
        String billTypeId = parameter.getBillTypeId();
        String action = (String)parameter.getCustomParam(ACTION);
        this.getPageCache().put(ACTION, action);
        if (StringUtils.isBlank((CharSequence)billTypeId)) {
            qFilter = new QFilter("billformid", "=", (Object)"er_billingpool");
            qFilter.and(new QFilter("enable", "=", (Object)true));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("number", "=", (Object)DEFAULT_LAYOUT));
            DynamicObject layout = BusinessDataServiceHelper.loadSingleFromCache((String)DB_BILLTYPE, (QFilter[])new QFilter[]{qFilter});
            billTypeId = ErCommonUtils.getPk((Object)layout).toString();
        }
        this.getModel().setValue(BILL_TYPE, (Object)billTypeId);
        qFilter = null;
        Long typeId = (Long)parameter.getCustomParam("billpooltype");
        qFilter = null == typeId ? new QFilter("billtype.id", "=", (Object)Long.parseLong(billTypeId)) : new QFilter("id", "=", (Object)typeId);
        DynamicObject billPoolType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_billingpool_type", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("billpooltype", (Object)billPoolType);
        this.toggleBillingPoolType(billPoolType);
    }

    private void initNewData(BillShowParameter parameter) {
        Object company = this.getModel().getValue("company");
        if (null != company) {
            String costCompanyScope = SystemParamterUtil.enableCostCompanyEdit((Long)ErCommonUtils.getPk((Object)company));
            this.getModel().setValue("enablecostcompanyedit", (Object)costCompanyScope);
        }
        Object costCompany = this.getModel().getValue("costcompany");
        this.getModel().setValue("buyerorg", costCompany);
        this.setValidateOrg("costcompany");
        Long companyID = ErCommonUtils.getPk((Object)company);
        DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyID, (Object)ErCommonUtils.getPk((Object)costCompany));
        if (currency != null) {
            this.getModel().setValue("currency", (Object)currency);
        }
        this.getModel().setValue(ORICURRENCY, this.getModel().getValue("currency"));
        this.getModel().setValue(SOURCE, (Object)"0");
        this.getModel().setValue("invoicedate", null);
        this.getModel().setValue("receiptdate", null);
        this.getModel().setValue("expirypaydate", null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BILL_TYPE});
        String isModal = (String)parameter.getCustomParam("isModal");
        this.getModel().setValue("ismodal", (Object)isModal);
        this.toggleBillingPoolType(null);
    }

    private void toggleBillingPoolType(DynamicObject billPoolType) {
        if (null == billPoolType) {
            billPoolType = (DynamicObject)this.getModel().getValue("billpooltype");
        }
        if (null == billPoolType) {
            return;
        }
        if (billPoolType.getBoolean("isinvoice")) {
            ((FieldEdit)this.getView().getControl(INVOICE_TYPE)).setMustInput(true);
        } else {
            this.getModel().setValue(INVOICE_TYPE, null);
        }
    }

    private void initF7Filter() {
        BasedataEdit entryexpenseitemF7;
        boolean isNotRelated;
        BasedataEdit buyerorg = (BasedataEdit)this.getControl("buyerorg");
        BasedataEdit seller = (BasedataEdit)this.getControl("sellerorg");
        Function<String, BeforeF7SelectListener> makeFilter = entity -> beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Long pk = ErCommonUtils.getPk((Object)this.getModel().getValue("costcompany"));
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)pk);
            listShowParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
        };
        if (null != buyerorg) {
            buyerorg.addBeforeF7SelectListener(makeFilter.apply("bos_org"));
        }
        if (null != seller) {
            seller.addBeforeF7SelectListener(makeFilter.apply("bd_supplier"));
        }
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
        if (costDeptF7 != null) {
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
        Object company = this.getModel().getValue("company");
        Long companyID = ErCommonUtils.getPk((Object)company);
        int showType = 1;
        if (companyID != null) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyID);
        }
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated) {
            Long deptID = ErCommonUtils.getPk((Object)this.getModel().getValue("costdept"));
            BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
            if (costCompanyF7 != null && deptID != null && company != null) {
                BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(deptID, ErCommonUtils.getPk((Object)company));
                costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
            }
        }
        if (null != (entryexpenseitemF7 = (BasedataEdit)this.getControl("headexpenseitem"))) {
            String number = this.getModel().getDataEntityType().getName();
            entryexpenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "costdept"));
        }
    }

    private void setValidateOrg(String changeField) {
        String field = ErStdConfig.get((String)"billingpool.validateorg.field");
        if (StringUtils.isBlank((CharSequence)field) || this.getModel().getProperty(field) == null) {
            field = "costcompany";
        }
        if (StringUtils.isNotBlank((CharSequence)changeField) && !field.equals(changeField)) {
            return;
        }
        this.getModel().setValue("validateorg", this.getModel().getValue(field));
    }

    protected void costDeptChange(String propName, DynamicObject costDept) {
        boolean isNotRelated;
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        int showType = 1;
        boolean isModeOne = true;
        if (company != null) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue())));
        }
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated && isModeOne && showType != 3) {
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("costcompany", (Object)costCompanyId);
            if (costCompanyId == null || costCompanyId.compareTo(Long.valueOf("0")) == 0) {
                return;
            }
        }
    }

    private void refreshTaxAndNoTax(int rowIndex, String totalField, String rateField, String noTaxField, String taxField, boolean isSum) {
        IDataModel model = this.getModel();
        if (this.isLink()) {
            model.beginInit();
            int precision = 4;
            BigDecimal totalAmount = (BigDecimal)this.getModel().getValue(totalField, rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue(taxField, rowIndex);
            DynamicObject taxRateObj = (DynamicObject)this.getModel().getValue(rateField, rowIndex);
            if (null == totalAmount || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue(noTaxField, null, rowIndex);
                this.getModel().setValue(taxField, null, rowIndex);
            } else if (null == taxRateObj) {
                if (null == taxAmount || taxAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue(noTaxField, (Object)totalAmount, rowIndex);
                } else {
                    this.getModel().setValue(noTaxField, (Object)totalAmount.subtract(taxAmount), rowIndex);
                }
            } else {
                BigDecimal taxRate = taxRateObj.getBigDecimal("taxrate");
                DynamicObject oriCurrencyDo = (DynamicObject)this.getModel().getValue(ORICURRENCY);
                if (null != oriCurrencyDo) {
                    precision = oriCurrencyDo.getInt("amtprecision");
                }
                taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
                taxAmount = totalAmount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN);
                this.getModel().setValue(noTaxField, (Object)totalAmount.subtract(taxAmount), rowIndex);
                this.getModel().setValue(taxField, (Object)taxAmount, rowIndex);
                model.endInit();
            }
        }
        if (isSum) {
            this.sumTotalAmount();
        }
    }

    private void refreshNoTax(int rowIndex, String totalField, String noTaxField, String taxField, boolean isSum) {
        IDataModel model = this.getModel();
        if (this.isLink()) {
            model.beginInit();
            BigDecimal totalAmount = (BigDecimal)this.getModel().getValue(totalField, rowIndex);
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue(taxField, rowIndex);
            if (null != totalAmount && totalAmount.compareTo(BigDecimal.ZERO) > 0) {
                if (null == taxAmount || taxAmount.equals(BigDecimal.ZERO)) {
                    this.getModel().setValue(noTaxField, (Object)totalAmount, rowIndex);
                } else {
                    this.getModel().setValue(noTaxField, (Object)totalAmount.subtract(taxAmount), rowIndex);
                }
            }
            model.endInit();
        }
        if (isSum) {
            this.sumTotalAmount();
        }
    }

    private void setValNoLink(String field, Object val, int index) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(field, val, index);
        model.endInit();
    }

    private void setValUpdateView(String field, Object val, int index) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(field, val, index);
        model.endInit();
        this.getView().updateView();
    }

    private boolean isLink() {
        Object company;
        Long companyId;
        String source = (String)this.getModel().getValue(SOURCE);
        Object isExpenseSync = this.getModel().getValue("isexpensesync");
        boolean isBillSync = isExpenseSync != null && Boolean.parseBoolean(isExpenseSync.toString());
        boolean isProcessLinked = false;
        if (StringUtils.isNotBlank((CharSequence)source) && source.equals("1") && null != (companyId = ErCommonUtils.getPk((Object)(company = this.getModel().getValue("company"))))) {
            isProcessLinked = ErCommonUtils.isAllowEditTaxAndTaxrate((Long)ErCommonUtils.getPk((Object)company));
        }
        return StringUtils.isNotBlank((CharSequence)source) && (source.equals("0") || isBillSync || isProcessLinked);
    }

    private void setFromStatus(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("billstatus");
        if (property != null && !BillOperationStatus.ADDNEW.equals((Object)showParameter.getBillStatus()) && !BillOperationStatus.VIEW.equals((Object)showParameter.getBillStatus())) {
            String billStatus = (String)model.getValue("billstatus");
            if (ErBillStatusEnum.A.toString().equalsIgnoreCase(billStatus)) {
                ((IBillView)view).setBillStatus(BillOperationStatus.EDIT);
                showParameter.setBillStatus(BillOperationStatus.EDIT);
                view.cacheFormShowParameter();
            } else if (ErBillStatusEnum.B.toString().equals(billStatus)) {
                ((IBillView)view).setBillStatus(BillOperationStatus.SUBMIT);
                showParameter.setBillStatus(BillOperationStatus.SUBMIT);
                view.cacheFormShowParameter();
            } else if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus) || "JKL".contains(billStatus)) {
                if (BillOperationStatus.EDIT.equals((Object)showParameter.getBillStatus()) && !ErBillStatusEnum.E.toString().equals(billStatus)) {
                    ((IBillView)view).setBillStatus(BillOperationStatus.VIEW);
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                } else {
                    ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
                    showParameter.setBillStatus(BillOperationStatus.AUDIT);
                }
                view.cacheFormShowParameter();
            }
            if (ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TRACKDOWN});
            }
        }
    }
}

