/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.billnewcheck;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.CheckExchangerateUtil;

public class CheckExchangeratePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(CheckExchangeratePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView view = this.getView();
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            return;
        }
        IDataModel dataModel = null;
        if ("er_tripentryedit".equals(view.getFormShowParameter().getFormId()) || view instanceof IMobileView) {
            if (this.getView() != null && this.getView().getParentView() != null) {
                dataModel = this.getView().getParentView().getModel();
            }
        } else {
            dataModel = this.getModel();
        }
        if (dataModel == null) {
            return;
        }
        DataEntityPropertyCollection dataEntityProperties = dataModel.getDataEntity().getDataEntityType().getProperties();
        if (dataEntityProperties.containsKey((Object)"currency") && dataEntityProperties.containsKey((Object)"company") && dataEntityProperties.containsKey((Object)"costcompany")) {
            final DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
            final DynamicObject company = (DynamicObject)dataModel.getValue("company");
            final DynamicObject costCompany = (DynamicObject)dataModel.getValue("costcompany");
            AfterF7SelectListener listener = new AfterF7SelectListener(){

                public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                    boolean check;
                    Object id;
                    ListSelectedRow selectedRow = afterF7SelectEvent.getListSelectedRow();
                    Object entryCurrency = null;
                    if (selectedRow != null) {
                        entryCurrency = selectedRow.getPrimaryKeyValue();
                    } else if (afterF7SelectEvent.getInputValues() != null && afterF7SelectEvent.getInputValues().size() > 0 && (id = afterF7SelectEvent.getInputValues().get(0)) != null) {
                        entryCurrency = Long.valueOf(id.toString());
                    }
                    if (entryCurrency != null && (check = CheckExchangerateUtil.checkExchangerate((DynamicObject)company, (DynamicObject)costCompany, (DynamicObject)currency, (Object)entryCurrency))) {
                        if (view instanceof IMobileView) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u4fee\u6539\u6c47\u7387\u3002", (String)"CheckExchangeratePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        } else {
                            view.showMessage(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u4fee\u6539\u6c47\u7387\u3002", (String)"CheckExchangeratePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                        }
                    }
                }
            };
            List<String> currencyList = Arrays.asList("accountcurrency", "entrycurrency", "reccurrency", "tripcurrency", "assetcurrency", "feestandcurrency");
            for (String c : currencyList) {
                Control accountcurrency = this.getView().getControl(c);
                if (!(accountcurrency instanceof BasedataEdit)) continue;
                ((BasedataEdit)accountcurrency).addAfterF7SelectListener(listener);
            }
        }
    }
}

