/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class ErDailyBotpCurrencyHandler
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        DynamicObjectCollection loanDetail;
        DynamicObject loanBill;
        Long exchangeRateTableId;
        DynamicObject costCompany;
        DynamicObject company;
        DynamicObject currency;
        boolean iscurrency;
        super.afterFieldMapping(e);
        ConvertRuleElement rule = this.getRule();
        FieldMapPolicy fieldMapPolicy = rule.getFieldMapPolicy();
        List fieldMaps = fieldMapPolicy.getFieldMaps();
        HashMap<String, FieldMapItem> mappedKeys = new HashMap<String, FieldMapItem>(10);
        for (FieldMapItem fieldItem : fieldMaps) {
            mappedKeys.put(fieldItem.getTargetFieldKey(), fieldItem);
        }
        BillEntityType entityType = this.getTgtMainType();
        String entityId = entityType.getName();
        ExtendedDataEntity[] dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(entityId);
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject reimBill = dataEntity.getDataEntity();
                iscurrency = reimBill.getBoolean("iscurrency");
                currency = reimBill.getDynamicObject("currency");
                company = reimBill.getDynamicObject("company");
                costCompany = reimBill.getDynamicObject("costcompany");
                if (!iscurrency || currency == null || company == null || costCompany == null) continue;
                exchangeRateTableId = BaseCurrencyServiceHelper.getExrateTableId((Object)company, (Object)costCompany);
                if (mappedKeys.get("exchangerate") == null && mappedKeys.get("entrycurrency") != null) {
                    DynamicObjectCollection expenseEntry = reimBill.getDynamicObjectCollection("expenseentryentity");
                    this.updateEntryCurrency(expenseEntry, currency, company, "entrycurrency", "exchangerate", "expquotetype", exchangeRateTableId);
                }
                if (mappedKeys.get("loanexchangerate") == null && mappedKeys.get("loancurrency") != null) {
                    DynamicObjectCollection loanEntry = reimBill.getDynamicObjectCollection("writeoffmoney");
                    this.updateEntryCurrency(loanEntry, currency, company, "loancurrency", "loanexchangerate", "writeoffquotetype", exchangeRateTableId);
                }
                if (mappedKeys.get("applyexchangerate") == null && mappedKeys.get("applycurrency") != null) {
                    DynamicObjectCollection applyEntry = reimBill.getDynamicObjectCollection("writeoffapply");
                    this.updateEntryCurrency(applyEntry, currency, company, "applycurrency", "applyexchangerate", "writeoffapplyquotetype", exchangeRateTableId);
                }
                if (mappedKeys.get("whexchangerate") != null || mappedKeys.get("whcurrency") == null) continue;
                DynamicObjectCollection withholdingentry = reimBill.getDynamicObjectCollection("withholdingentry");
                this.updateEntryCurrency(withholdingentry, currency, company, "whcurrency", "whexchangerate", "whquotetype", exchangeRateTableId);
            }
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                loanBill = dataEntity.getDataEntity();
                iscurrency = loanBill.getBoolean("iscurrency");
                currency = loanBill.getDynamicObject("currency");
                company = loanBill.getDynamicObject("company");
                costCompany = loanBill.getDynamicObject("costcompany");
                if (!iscurrency || currency == null || company == null || costCompany == null) continue;
                exchangeRateTableId = BaseCurrencyServiceHelper.getExrateTableId((Object)company, (Object)costCompany);
                if (mappedKeys.get("exchangerate") != null || mappedKeys.get("entrycurrency") == null) continue;
                loanDetail = loanBill.getDynamicObjectCollection("expenseentryentity");
                this.updateEntryCurrency(loanDetail, currency, company, "entrycurrency", "exchangerate", "expquotetype", exchangeRateTableId);
            }
        }
        if (ErEntityTypeUtils.isRepaymentBill((String)entityId)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                loanBill = dataEntity.getDataEntity();
                iscurrency = loanBill.getBoolean("iscurrency");
                currency = loanBill.getDynamicObject("currency");
                company = loanBill.getDynamicObject("company");
                costCompany = loanBill.getDynamicObject("costcompany");
                if (!iscurrency || currency == null || company == null || costCompany == null) continue;
                exchangeRateTableId = BaseCurrencyServiceHelper.getExrateTableId((Object)company, (Object)costCompany);
                if (mappedKeys.get("repayexchangerate") != null || mappedKeys.get("accountcurrency") == null) continue;
                loanDetail = loanBill.getDynamicObjectCollection("repaymententry");
                this.updateEntryCurrency(loanDetail, currency, company, "accountcurrency", "repayexchangerate", "detailquotetype", exchangeRateTableId);
            }
        }
    }

    private void updateEntryCurrency(DynamicObjectCollection detailEntry, DynamicObject currency, DynamicObject company, String entryCurrencyProp, String entryExchangeRateProp, String quotetype, Long exchangeRateTableId) {
        Long currencyId = ErCommonUtils.getPk((Object)currency);
        for (DynamicObject detail : detailEntry) {
            DynamicObject entryCurrency = detail.getDynamicObject(entryCurrencyProp);
            Long entryCurrencyId = ErCommonUtils.getPk((Object)entryCurrency);
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)entryCurrencyId, (Long)currencyId, (Long)exchangeRateTableId, (Date)new Date());
            if (exchangeRateMap.get("quoteType") == null || !((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
                detail.set(quotetype, (Object)"0");
            } else {
                detail.set(quotetype, (Object)"1");
            }
            if (exchangeRateMap.get("exchangeRate") == null) {
                detail.set(entryExchangeRateProp, (Object)BigDecimal.ONE);
                exchangeRateMap.put("exchangeRate", BigDecimal.ONE);
                continue;
            }
            detail.set(entryExchangeRateProp, exchangeRateMap.get("exchangeRate"));
        }
    }
}

