/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class ErTripBotpCurrencyHandler
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        ConvertRuleElement rule = this.getRule();
        FieldMapPolicy fieldMapPolicy = rule.getFieldMapPolicy();
        List fieldMaps = fieldMapPolicy.getFieldMaps();
        HashMap<String, FieldMapItem> mappedKeys = new HashMap<String, FieldMapItem>(10);
        for (FieldMapItem fieldItem : fieldMaps) {
            mappedKeys.put(fieldItem.getTargetFieldKey(), fieldItem);
        }
        BillEntityType entityType = this.getTgtMainType();
        String entityId = entityType.getName();
        ExtendedDataEntity[] dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(entityId);
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject reimBill = dataEntity.getDataEntity();
                boolean iscurrency = reimBill.getBoolean("iscurrency");
                DynamicObject currency = reimBill.getDynamicObject("currency");
                DynamicObject company = reimBill.getDynamicObject("company");
                DynamicObject costCompany = reimBill.getDynamicObject("costcompany");
                if (!iscurrency || currency == null || company == null || costCompany == null || mappedKeys.get("tripexchangerate") != null || mappedKeys.get("tripcurrency") == null) continue;
                DynamicObjectCollection expenseEntry = reimBill.getDynamicObjectCollection("tripentry");
                Long exchangeRateTableId = BaseCurrencyServiceHelper.getExrateTableId((Object)company, (Object)costCompany);
                this.updateEntryCurrency(expenseEntry, currency, company, "tripcurrency", "tripexchangerate", exchangeRateTableId);
            }
        }
    }

    private void updateEntryCurrency(DynamicObjectCollection detailEntry, DynamicObject currency, DynamicObject company, String entryCurrencyProp, String entryExchangeRateProp, Long exchangeRateTableId) {
        Date date = new Date();
        for (DynamicObject detail : detailEntry) {
            DynamicObject entryCurrency = detail.getDynamicObject(entryCurrencyProp);
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)entryCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)date);
            detail.set(entryExchangeRateProp, (Object)exchangeRate);
        }
    }
}

