/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class TripReqLoanToTirpReimburseConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(TripReqLoanToTirpReimburseConvertPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("from");
        e.addSrcField("to");
        e.addSrcField("vehicle");
        e.addSrcField("tripcurrency");
        e.addSrcField("tripday");
        e.addSrcField("currency");
        e.addSrcField("company");
        e.addSrcField("mulwayto");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        BillEntityType targetEntityType = this.getTgtMainType();
        String targetEntityNumber = targetEntityType.getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map srcfldPro = e.getFldProperties();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List sourceBillRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow0 = (DynamicObject)sourceBillRows.get(0);
            Long userId = (Long)((DynamicProperty)srcfldPro.get("applier")).getValue((Object)srcRow0);
            BillRelateUtils.setDefaultAccount((Long)userId, (DynamicObject)targetBill, (ExtendedDataEntity)billDataEntity);
            DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
            if (targetTripEntrys.size() > 1) {
                BigDecimal amount = BigDecimal.ZERO;
                for (DynamicObject targetTripEntry : targetTripEntrys) {
                    BigDecimal tripAmount = targetTripEntry.getBigDecimal("tripamount");
                    if (tripAmount == null) continue;
                    amount = amount.add(tripAmount);
                }
                targetBill.set("amount", (Object)amount);
            }
            Long compayId = (Long)((DynamicProperty)srcfldPro.get("company")).getValue((Object)srcRow0);
            targetBill.set("ismulwayto", (Object)SystemParamterUtil.getTripEntryMulWayTo((long)compayId));
        }
    }
}

