/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.push;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class loanBillToRepayBillSelectBillPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        ArrayList allBillList = new ArrayList();
        DynamicObject[] loanBills = this.getBillMap("exp", "er_dailyloanbill");
        DynamicObject[] applyBills = this.getBillMap("tra", "er_tripreqbill");
        DynamicObject[] perpayBills = this.getBillMap("cexp", "er_prepaybill");
        Collections.addAll(allBillList, loanBills);
        Collections.addAll(allBillList, applyBills);
        Collections.addAll(allBillList, perpayBills);
        if (allBillList.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", allBillList.size());
        }
        for (int i = 0; i < allBillList.size(); ++i) {
            DynamicObject item = (DynamicObject)allBillList.get(i);
            this.getModel().setValue("id", item.get("id"), i);
            this.getModel().setValue("billno", item.get("billno"), i);
            this.getModel().setValue("description", item.get("description"), i);
            this.getModel().setValue("currency", item.get("currency"), i);
            this.getModel().setValue("balanceamount", item.get("balanceamount"), i);
            this.getModel().setValue("payamount", item.get("payamount"), i);
            this.getModel().setValue("loanamount", item.get("loanamount"), i);
            this.getModel().setValue("billtype", (Object)this.getBillType(item.getDataEntityType().getName()), i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_ok": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] rowIndexs = entryGrid.getSelectRows();
                ArrayList<ListSelectedRow> loanBills = new ArrayList<ListSelectedRow>();
                ArrayList<ListSelectedRow> applyBills = new ArrayList<ListSelectedRow>();
                ArrayList<ListSelectedRow> prepayBills = new ArrayList<ListSelectedRow>();
                DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                for (int i = 0; i < rowIndexs.length; ++i) {
                    DynamicObject row = (DynamicObject)entryentity.get(rowIndexs[i]);
                    String billType = row.getString("billtype");
                    Long billId = Long.valueOf(row.getString("id"));
                    ListSelectedRow listSelectedRow = new ListSelectedRow((Object)billId);
                    if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"loanBillToRepayBillSelectBillPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), (CharSequence)billType)) {
                        loanBills.add(listSelectedRow);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\uff08\u501f\uff09", (String)"loanBillToRepayBillSelectBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), (CharSequence)billType)) {
                        applyBills.add(listSelectedRow);
                        continue;
                    }
                    prepayBills.add(listSelectedRow);
                }
                HashMap<String, ArrayList<ListSelectedRow>> returnData = new HashMap<String, ArrayList<ListSelectedRow>>();
                if (loanBills.size() > 0 && applyBills.size() > 0 || loanBills.size() > 0 && prepayBills.size() > 0 || applyBills.size() > 0 && prepayBills.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u4e86\u4e24\u79cd\u5355\u636e\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u7c7b\u578b\u7684\u5355\u636e\u8fdb\u884c\u4e0b\u63a8\u3002", (String)"loanBillToRepayBillSelectBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (loanBills.size() == 0 && applyBills.size() == 0 && prepayBills.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5355\u636e\u8fdb\u884c\u4e0b\u63a8\u3002", (String)"loanBillToRepayBillSelectBillPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                returnData.put("er_dailyloanbill", loanBills);
                returnData.put("er_tripreqbill", applyBills);
                returnData.put("er_prepaybill", prepayBills);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private DynamicObject[] getBillMap(String appId, String entityNumber) {
        QFilter[] qFilters;
        DynamicObject[] load;
        QFilter specialDataPermissionFilter;
        String selectFieds = "id, billno, description, currency, balanceamount, payamount, loanamount";
        Set appSet = Stream.of("exp", "tra", "cexp").collect(Collectors.toSet());
        long userId = RequestContext.get().getCurrUserId();
        if (appSet.contains(appId)) {
            specialDataPermissionFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)entityNumber, (String)"view", (ITimeService)((ITimeService)this.getView().getService(ITimeService.class)), (IUserService)((IUserService)this.getView().getService(IUserService.class)));
        } else {
            specialDataPermissionFilter = new QFilter("creator", "=", (Object)userId);
            specialDataPermissionFilter.or(new QFilter("applier", "=", (Object)userId));
        }
        QFilter qFilter = new QFilter("projectower.fbasedataid.id", "in", (Object)userId);
        if (specialDataPermissionFilter != null) {
            specialDataPermissionFilter.or(qFilter);
        }
        return (load = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFieds, (QFilter[])(qFilters = new QFilter[]{new QFilter("billstatus", "=", (Object)"G"), new QFilter("balanceamount", ">", (Object)0), specialDataPermissionFilter}))) != null ? load : new DynamicObject[]{};
    }

    private String getBillType(String entityNumber) {
        String billType = "";
        switch (entityNumber) {
            case "er_dailyloanbill": {
                billType = ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"loanBillToRepayBillSelectBillPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
            case "er_tripreqbill": {
                billType = ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\uff08\u501f\uff09", (String)"loanBillToRepayBillSelectBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                break;
            }
            case "er_prepaybill": {
                billType = ResManager.loadKDString((String)"\u9884\u4ed8\u5355", (String)"loanBillToRepayBillSelectBillPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
        }
        return billType;
    }
}

