/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.tripbill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.up.TripReqToTripReimburseSelectBillPlugin;

public abstract class AbstractTripBillToReimburseBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(AbstractTripBillToReimburseBotpPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("applier");
        e.addSrcField("id");
        e.addSrcField("company");
        e.addSrcField("vehicles");
        e.addSrcField("tripcurrency");
        e.addSrcField("tripday");
        e.addSrcField("currency");
        e.addSrcField("mulwayto");
        e.addSrcField("tripentry.id");
        e.addSrcField("tripquotetype");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        Long time = System.currentTimeMillis();
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] writeOffEntry = e.getTargetExtDataEntitySet().FindByEntityKey("writeoffapply");
        long[] PKs = DBServiceHelper.genLongIds((String)"t_er_reimbclearapplyentry", (int)writeOffEntry.length);
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map srcfldPro = e.getFldProperties();
        for (int index = 0; index < PKs.length; ++index) {
            writeOffEntry[index].setValue("id", (Object)PKs[index]);
        }
        String srcMainType = this.getSrcMainType().getName();
        DynamicProperty headIdProp = (DynamicProperty)srcfldPro.get("id");
        HashSet allHeadIds = new HashSet(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List convertSourceBillRows = (List)billDataEntity.getValue("ConvertSource");
            Set headIds = convertSourceBillRows.stream().map(v -> headIdProp.getValue(v)).collect(Collectors.toSet());
            allHeadIds.addAll(headIds);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", allHeadIds)};
        String selectFields = "id" + "," + "istravelers" + "," + "iscurrency";
        DynamicObjectCollection srcBills = QueryServiceHelper.query((String)srcMainType, (String)selectFields, (QFilter[])filters);
        Map<Object, List<DynamicObject>> srcBillMap = srcBills.stream().collect(Collectors.groupingBy(v -> v.get("id")));
        HashMap<String, Object> targetBillIdMap = new HashMap<String, Object>(2);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            targetBill.getDataEntityState().setPushChanged(true);
            List convertSourceBillRows = (List)billDataEntity.getValue("ConvertSource");
            this.initTargetHeaderFieldMappingInfo(targetBill, convertSourceBillRows, srcBillMap, headIdProp);
            DynamicObjectCollection writeOffApplyEntity = targetBill.getDynamicObjectCollection("writeoffapply");
            List<String> billNumbers = writeOffApplyEntity.stream().map(v -> v.getString("applybillno")).collect(Collectors.toList());
            TripReqToTripReimburseSelectBillPlugin.setMobShowData(writeOffApplyEntity, billNumbers);
            targetBillIdMap.put("writeOffEntryId", PKs);
            this.initDefaultTargetEntryData(targetBill, srcfldPro, convertSourceBillRows, targetBillIdMap);
        }
        logger.info("AbstractTripBillToReimburseBotpPlugin.afterFieldMapping \u51fa\u5dee\u7533\u8bf7\u5355\u4e0b\u63a8\u8017\u8d39 {}", (Object)(System.currentTimeMillis() - time));
    }

    private void initTargetHeaderFieldMappingInfo(DynamicObject targetBill, List<DynamicObject> convertSourceBillRows, Map<Object, List<DynamicObject>> srcBillMap, DynamicProperty headIdProp) {
        List<DynamicObject> srcBills2;
        Object headId;
        Long compayId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
        targetBill.set("ismulwayto", (Object)SystemParamterUtil.getTripEntryMulWayTo((long)compayId));
        targetBill.set("ismultravelers", (Object)SystemParamterUtil.getIsMulTravelers((long)compayId));
        for (DynamicObject row : convertSourceBillRows) {
            headId = headIdProp.getValue((Object)row);
            srcBills2 = srcBillMap.get(headId);
            boolean isTravelers = srcBills2.stream().anyMatch(v -> v.getBoolean("istravelers"));
            if (!isTravelers) continue;
            targetBill.set("istravelers", (Object)true);
            break;
        }
        for (DynamicObject row : convertSourceBillRows) {
            headId = headIdProp.getValue((Object)row);
            srcBills2 = srcBillMap.get(headId);
            boolean isCurrency = srcBills2.stream().anyMatch(v -> v.getBoolean("iscurrency"));
            if (!isCurrency) continue;
            targetBill.set("iscurrency", (Object)true);
            break;
        }
    }

    protected void initDefaultPayAccount(DynamicObject targetBill, ExtendedDataEntity billDataEntity) {
        Long userId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("applier"));
        BillRelateUtils.setDefaultAccount((Long)userId, (DynamicObject)targetBill, (ExtendedDataEntity)billDataEntity);
    }

    protected abstract void initDefaultTargetEntryData(DynamicObject var1, Map<String, DynamicProperty> var2, List<DynamicObject> var3, Map<String, Object> var4);
}

