/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEnhancedConvertReportUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;

public abstract class ErAbstractBotpUpPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String CLOSE_CALL_BACK = "selecebillback";
    private static final Log logger = LogFactory.getLog(ErAbstractBotpUpPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)source;
            String operateKey = newEntry.getOperateKey();
            if (this.getOperateKey().equalsIgnoreCase(operateKey)) {
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                boolean isOpen = true;
                if ("newaccentry".equals(operateKey) && ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && "2".equals(applyprojectbillRelated)) {
                    String detailtype = (String)this.getModel().getValue("detailtype");
                    if ("biztype_project".equals(detailtype)) {
                        isOpen = PublicBillUtil.checkProjectNo((IFormView)this.getView());
                    }
                } else if ("newclearloanentry".equals(operateKey) && ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) && "1".equals(this.getModel().getValue("billkind")) && CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u201c\u5dee\u65c5\u660e\u7ec6\u201d\u3002", (String)"EM-W-422248", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    isOpen = false;
                }
                args.setCancel(true);
                if (isOpen) {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("er_tripreimbure_botp");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK));
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCustomParam("filterbill", this.getFilterBill());
                    formShowParameter.setCustomParam("writeofftype", (Object)this.getWriteType());
                    formShowParameter.setCustomParam("company", (Object)this.getCompany());
                    formShowParameter.setCustomParam("applier", this.getApplier());
                    formShowParameter.setCustomParam("filterentity", this.getFilterEntity());
                    formShowParameter.setCustomParam("relatedbiz", (Object)this.getHandleRelatedBiz());
                    formShowParameter.setCustomParam("costcompany", (Object)this.getCostCompany());
                    if (this.getModel().getProperty("currency") != null) {
                        formShowParameter.setCustomParam("currency", (Object)ErCommonUtils.getPk((Object)this.getModel().getValue("currency")));
                    }
                    formShowParameter.setCustomParam("org", (Object)this.getDept());
                    this.getView().showForm(formShowParameter);
                }
            }
        } else if (source instanceof DeleteEntry) {
            this.handleDeleteEvt(args, source);
        }
    }

    private String getHandleRelatedBiz() {
        MainEntityType entityType = this.getModel().getDataEntityType();
        String entityId = entityType.getName();
        String relatedBiz = "relatedtype_other";
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            if ("biztype_contract".equalsIgnoreCase(this.getDetailType())) {
                relatedBiz = "relatedtype_contract";
            } else if ("biztype_project".equalsIgnoreCase(this.getDetailType())) {
                relatedBiz = "relatedtype_project";
            } else if ("biztype_other".equalsIgnoreCase(this.getDetailType())) {
                relatedBiz = "relatedtype_other";
            }
        }
        return relatedBiz;
    }

    protected void handleDeleteEvt(BeforeDoOperationEventArgs args, Object source) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)source;
            String operateKey = deleteEntry.getOperateKey();
            if (this.getDelelteOperateKey().equalsIgnoreCase(operateKey)) {
                this.recalculateAmount();
            }
        }
    }

    protected abstract String getDelelteOperateKey();

    protected abstract Object getApplier();

    protected abstract Long getCostCompany();

    protected abstract Long getCompany();

    protected abstract boolean getWriteType();

    protected abstract String getOperateKey();

    protected abstract Long getDept();

    protected abstract Map<Long, List<Long>> getFilterBill();

    protected List<String> getFilterEntity() {
        String[] entityArray = new String[]{"er_tripreqbill", "er_dailyloanbill"};
        return Arrays.asList(entityArray);
    }

    protected abstract String getDetailType();

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(CLOSE_CALL_BACK)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            boolean success = true;
            if (returnData != null) {
                IDataModel dataModel = this.getModel();
                IBillView billView = (IBillView)this.getView();
                ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
                ArrayList<ConvertOperationResult> convertResults = new ArrayList<ConvertOperationResult>(10);
                DrawArgs failArgs = new DrawArgs();
                for (Map.Entry bill : returnData.entrySet()) {
                    ListSelectedRowCollection rows = (ListSelectedRowCollection)bill.getValue();
                    String entityName = (String)bill.getKey();
                    DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)entityName, (String)dataModel.getDataEntityType().getName(), (IFormView)this.getView(), (ListSelectedRowCollection)rows, (String)this.getRuleId(entityName));
                    ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
                    convertResults.add(result);
                    if (result.isSuccess()) {
                        BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, resultList, (BillEntityType)((BillEntityType)this.getModel().getDataEntityType()));
                        continue;
                    }
                    success = false;
                    failArgs = args;
                }
                if (success) {
                    DynamicObject pushDyn = this.mergeResult(resultList);
                    DynamicObjectCollection accountEntry = this.getModel().getEntryEntity("accountentry");
                    ((IBillModel)billView.getModel()).push((Object)pushDyn);
                    if (this.getModel().getEntryRowCount("accountentry") == 0) {
                        DynamicObjectCollection entry = this.getModel().getEntryEntity("accountentry");
                        entry.addAll((Collection)accountEntry);
                    }
                    WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                    this.recalculateAmount();
                    IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                        public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                            BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                        }
                    };
                    RedisModelCache modelCache = new RedisModelCache(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()), billView.getPageId());
                    modelCache.release();
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
                        PublicBillUtil.refreshWriteOffInfo((IDataModel)dataModel);
                    }
                } else {
                    ErEnhancedConvertReportUtil.showEnhancedConvertReport(convertResults, (DrawArgs)failArgs, (IFormView)this.getView());
                }
                if (this.getModel().getProperty("writeoffapply") != null) {
                    this.getView().updateView("writeoffapply");
                    AdvContainer advContainer = (AdvContainer)this.getView().getControl("advconapoffapply");
                    if (advContainer != null) {
                        advContainer.setCollapse(false);
                    }
                }
                this.updateEntriesView();
            }
        }
    }

    protected void updateEntriesView() {
    }

    protected abstract DynamicObject mergeResult(List<DynamicObject> var1);

    protected abstract void recalculateAmount();

    protected abstract String getRuleId(String var1);

    protected String getOpenBillType(String openBillId) {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String billtype = null;
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)CommonServiceHelper.getEntityfromSSC((String)this.getView().getEntityId()), (Long[])new Long[]{pkValue});
        for (Map.Entry next : sourceBills.entrySet()) {
            if (!((HashSet)next.getValue()).contains(Long.valueOf(openBillId))) continue;
            billtype = (String)next.getKey();
            break;
        }
        return billtype;
    }

    protected void openLinkedForm(Object pkValue, String formId) {
        ShowPageUtils.openLinkedForm((Object)pkValue, (String)formId, (IFormView)this.getView());
    }
}

