/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.up.ErAbstractBotpUpPlugin;

public class ErTripReimburseBotpUpPlugin
extends ErAbstractBotpUpPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid clearLoanEntry = (AbstractGrid)this.getControl("clearloanentry");
        AbstractGrid writeOffApplyEntry = (AbstractGrid)this.getControl("writeoffapply");
        if (clearLoanEntry != null) {
            clearLoanEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (writeOffApplyEntry != null) {
            writeOffApplyEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    @Override
    protected Map<Long, List<Long>> getFilterBill() {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("clearloanentry");
        for (DynamicObject row : entryEntity) {
            long sourcebillid = row.getLong("loanbillid");
            ArrayList<Long> entryIds = (ArrayList<Long>)result.get(sourcebillid);
            if (entryIds == null) {
                entryIds = new ArrayList<Long>();
                result.put(sourcebillid, entryIds);
            }
            entryIds.add(row.getLong("reqaccountentryid"));
        }
        return result;
    }

    @Override
    protected String getDetailType() {
        return "";
    }

    @Override
    protected void handleDeleteEvt(BeforeDoOperationEventArgs args, Object source) {
        String entryId;
        EntryGrid entryGrid;
        int[] rowIndexs;
        DeleteEntry deleteEntry = (DeleteEntry)source;
        String operateKey = deleteEntry.getOperateKey();
        if (this.getDelelteOperateKey().equalsIgnoreCase(operateKey) && this.getView().getEntityId().contains("_ssc") && (rowIndexs = (entryGrid = (EntryGrid)this.getControl(entryId = (String)deleteEntry.getParameter().get("entryId"))).getSelectRows()) != null) {
            for (int index : rowIndexs) {
                Object value = this.getModel().getValue("snaploanclearoriamount", index);
                if (value == null || ((BigDecimal)value).compareTo(BigDecimal.ZERO) <= 0) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"ErTripReimburseBotpUpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51b2\u501f\u6b3e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ErTripReimburseBotpUpPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    @Override
    protected String getOperateKey() {
        return "newclearloanentry";
    }

    @Override
    protected void recalculateAmount() {
        IDataModel dataModel = this.getModel();
        boolean modify = true;
        String loanType = (String)this.getModel().getValue("loanchecktype");
        AmountChangeUtil.loanClearEntryChange((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        if (modify) {
            AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)dataModel, (String)loanType);
            AmountChangeUtil.showPayAmountLable((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
            BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"clearloanentry", (String)"loanclearamount");
            dataModel.setValue("checkloanamount", (Object)totalClearLoanAmount);
        }
        IBillView billView = (IBillView)this.getView();
        billView.updateView("advconap1");
        billView.updateView("advconap2");
    }

    @Override
    protected String getRuleId(String entityName) {
        if ("er_dailyloanbill".equals(entityName)) {
            return "514160845400318976";
        }
        return "514155471423153152";
    }

    @Override
    protected boolean getWriteType() {
        String loanType = (String)this.getModel().getValue("loanchecktype");
        return WriteOffTypeEnum.CURR_WO.getValue().equals(loanType);
    }

    @Override
    protected Long getCostCompany() {
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        return costCompany == null ? 0L : costCompany.getLong("id");
    }

    @Override
    protected Long getCompany() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        return company == null ? 0L : company.getLong("id");
    }

    @Override
    protected Long getDept() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        return dept == null ? 0L : dept.getLong("id");
    }

    @Override
    protected Object getApplier() {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        return applier == null ? null : applier.getPkValue();
    }

    @Override
    protected DynamicObject mergeResult(List<DynamicObject> dataEntitysDyn) {
        DynamicObject result = dataEntitysDyn.get(0);
        HashSet<String> contains = new HashSet<String>();
        DynamicObjectCollection clearLoanEntry = result.getDynamicObjectCollection("clearloanentry");
        for (DynamicObject clearRow : clearLoanEntry) {
            contains.add(clearRow.getString("reqaccountentryid") + clearRow.getString("loanbillid"));
        }
        for (int i = 1; i < dataEntitysDyn.size(); ++i) {
            DynamicObject temp = dataEntitysDyn.get(i);
            DynamicObjectCollection tempClearLoanEntry = temp.getDynamicObjectCollection("clearloanentry");
            for (DynamicObject tempClearRow : tempClearLoanEntry) {
                String conStr = tempClearRow.getString("reqaccountentryid") + tempClearRow.getString("loanbillid");
                if (contains.contains(conStr)) continue;
                clearLoanEntry.add((Object)tempClearRow);
            }
        }
        return result;
    }

    @Override
    protected String getDelelteOperateKey() {
        return "deleteClearLoanEntry";
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object openBillId = null;
        String openBillType = null;
        String srcbilltype = null;
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if ("loanbillno".equals(hyperLinkClickEvent.getFieldName())) {
            openBillId = this.getModel().getValue("loanbillid", rowIndex);
            srcbilltype = (String)this.getModel().getValue("srcbilltype", rowIndex);
        } else {
            if ("applybillno".equals(hyperLinkClickEvent.getFieldName())) {
                String billNumber = (String)this.getModel().getValue("applybillno", rowIndex);
                String srcBillIdStr = (String)this.getModel().getValue("sourceapplybillid", rowIndex);
                Long srcBillId = null;
                String billType = null;
                if (StringUtils.isNumeric((CharSequence)srcBillIdStr) && (billType = this.getOpenBillType(srcBillIdStr)) != null) {
                    srcBillId = Long.valueOf(srcBillIdStr);
                    this.openLinkedForm(srcBillId, billType);
                    return;
                }
                billType = "er_tripreqbill";
                DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNumber)});
                srcBillId = bill.getLong("id");
                this.openLinkedForm(srcBillId, billType);
                return;
            }
            if ("applyamount".equals(hyperLinkClickEvent.getFieldName())) {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("writeoffapply");
                String applybillNo = (String)this.getModel().getValue("applybillno", currentRowIndex);
                String srcBillIdStr = (String)this.getModel().getValue("sourceapplybillid", rowIndex);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("er_tripreqbilltravelroute");
                formShowParameter.setCustomParam("billno", (Object)applybillNo);
                formShowParameter.setCustomParam("id", (Object)srcBillIdStr);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
                return;
            }
        }
        if (openBillId != null) {
            openBillType = this.getOpenBillType(openBillId.toString());
        }
        if (openBillType != null) {
            this.openLinkedForm(openBillId, openBillType);
        } else if (srcbilltype != null) {
            this.openLinkedForm(openBillId, srcbilltype);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "costcompany": {
                this.clearLoanEntry();
            }
        }
    }

    private void clearLoanEntry() {
        Long companyId = this.getCompany();
        String loaRangeType = SystemParamterUtil.getLoanDrawRange((Long)companyId);
        if (StringUtils.equals((CharSequence)loaRangeType, (CharSequence)"1")) {
            this.getModel().deleteEntryData("clearloanentry");
        }
    }

    @Override
    protected void updateEntriesView() {
        String billKind = this.getModel().getDataEntity().getString("billkind");
        String entryName = "tripentry";
        if ("1".equals(billKind)) {
            entryName = "entryentity";
        }
        this.getView().updateView(entryName);
        this.getView().updateView("istravelers");
    }
}

