/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.botp.up.TripReqToTripReimburseSelectBillPlugin;
import org.apache.commons.lang.StringUtils;

public class TripReqToTripReimburseBillListMobPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener {
    private static Log logger = LogFactory.getLog(TripReqToTripReimburseBillListMobPlugin.class);
    private static final String entry = "entryentity";

    public void initialize() {
        super.initialize();
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "confrim", "cardentryflex_description"});
    }

    public void afterCreateNewData(EventObject e) {
        this.search(null);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control menuItem = (Control)evt.getSource();
        if (!StringUtils.equals((String)menuItem.getKey(), (String)"confrim")) {
            return;
        }
        String warningStr = this.getNotUsedOrderWarningStrByReq();
        if (StringUtils.isNotBlank((String)warningStr)) {
            evt.setCancel(true);
            this.getView().showTipNotification(warningStr);
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        super.click(evt);
        Control menuItem = (Control)evt.getSource();
        String key = menuItem.getKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
        int[] rowIndexs = entryGrid.getSelectRows();
        switch (key) {
            case "confrim": {
                ListSelectedRowCollection listSelectedRowCollection = this.getSelectRow(rowIndexs, entryEntity);
                IFormView pView = this.getView().getParentView();
                DynamicObjectCollection applyWriteOffEntry = pView.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffapply");
                if (applyWriteOffEntry.size() == 0) {
                    pView.setVisible(Boolean.FALSE, new String[]{"next"});
                    pView.setVisible(Boolean.TRUE, new String[]{"tbmain", "save", "submit", "tripentry", "flexpanel_mytrip", "listcard_tripentry", "listcardviewap", "btn_addsection"});
                }
                this.getView().sendFormAction(pView);
                this.getView().returnDataToParent((Object)listSelectedRowCollection);
                pView.updateView();
            }
            case "cancel": {
                this.getView().close();
                break;
            }
            case "cardentryflex_description": {
                int entryRow = this.getModel().getEntryCurrentRowIndex(entry);
                HashSet<String> billNoSet = new HashSet<String>(entryEntity.size());
                for (int index : rowIndexs) {
                    billNoSet.add(((DynamicObject)entryEntity.get(index)).getString("billno"));
                }
                Set indexSet = Arrays.stream(rowIndexs).boxed().collect(Collectors.toSet());
                if (!indexSet.contains(entryRow)) {
                    String currRowBillNo = ((DynamicObject)entryEntity.get(entryRow)).getString("billno");
                    billNoSet.remove(currRowBillNo);
                }
                ArrayList<Integer> selectIndexList = new ArrayList<Integer>(billNoSet.size());
                for (int i = 0; i < entryEntity.size(); ++i) {
                    if (!billNoSet.contains(((DynamicObject)entryEntity.get(i)).getString("billno"))) continue;
                    selectIndexList.add(i);
                }
                entryGrid.selectRows(selectIndexList.stream().mapToInt(Integer::intValue).toArray(), entryRow);
            }
        }
    }

    public void click(MobileSearchTextChangeEvent searchEvent) {
        String searchText = searchEvent.getText();
        this.search(searchText);
    }

    private String getNotUsedOrderWarningStrByReq() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
        int[] rowIndexs = entryGrid.getSelectRows();
        ListSelectedRowCollection selectBill = this.getSelectRow(rowIndexs, entryEntity);
        IDataModel pModel = this.getView().getParentView().getModel();
        Object company = pModel.getValue("company");
        int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)company), (String)"reqbilltoreimbursecount");
        if (reqbilltoreimbursecount > 0) {
            return "";
        }
        List ids = selectBill.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        StringBuilder orderWarningStr = new StringBuilder();
        ArrayList reqBillIds = new ArrayList();
        ArrayList reqBillNos = new ArrayList();
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id,billno,company,tripentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        reqBills.stream().forEach(v -> {
            reqBillIds.add(v.getLong("id"));
            reqBillNos.add(v.getString("billno"));
        });
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, (Long)ErCommonUtils.getPk((Object)company));
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return orderWarningStr.toString();
        }
        for (DynamicObject orderBill : notReimbursedOrderList) {
            if (TripNotReimbursedOrderUtil.checkAvailableOrder((DynamicObject)orderBill)) continue;
            orderWarningStr.append(orderBill.getString("oabillnum"));
            orderWarningStr.append(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u5b58\u5728\u672a\u4f7f\u7528\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u9500\uff1b\u5982\u5b9e\u9645\u5df2\u4f7f\u7528\uff0c\u72b6\u6001\u66f4\u65b0\u4f1a\u6709\u5ef6\u8fdf\uff1b", (String)"TripReqToTripReimburseBillListMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            orderWarningStr.append("\n");
            orderWarningStr.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u7b49\u5f853-5\u79d2\u540e\u5c1d\u8bd5\u91cd\u65b0\u62a5\u9500\uff1b\u82e5\u4ecd\u62a5\u9500\u5931\u8d25\uff0c\u8bf7\u7b49\u5f851-2\u5929\u540e\u91cd\u8bd5\u3002", (String)"TripReqToTripReimburseBillListMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            break;
        }
        return orderWarningStr.toString();
    }

    private ListSelectedRowCollection getSelectRow(int[] rowIndexs, DynamicObjectCollection entryEntity) {
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (rowIndexs == null) {
            return listSelectedRowCollection;
        }
        HashSet<Long> selectIds = new HashSet<Long>(3);
        for (int index : rowIndexs) {
            long billId = ((DynamicObject)entryEntity.get(index)).getLong("billid");
            if (selectIds.contains(billId)) continue;
            selectIds.add(billId);
            ListSelectedRow listSelectedRow = new ListSelectedRow((Object)billId, Boolean.TRUE);
            listSelectedRow.setBillNo(((DynamicObject)entryEntity.get(index)).getString("billno"));
            listSelectedRow.setFormID("er_tripreqbill");
            listSelectedRowCollection.add((Object)listSelectedRow);
        }
        return listSelectedRowCollection;
    }

    private void search(String searchText) {
        IDataModel model = this.getModel();
        IDataModel pModel = this.getView().getParentView().getModel();
        DynamicObject targetBill = pModel.getDataEntity(true);
        int index = 0;
        QFilter qFilter = TripReqToTripReimburseSelectBillPlugin.tripReqSelectBillSetFilter(targetBill);
        DynamicObject[] selectBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,billno, applier,org,company,description,tripentry.from,tripentry.to,tripentry.tripexpenseitem,tripentry.startdate,tripentry.enddate,tripentry.tripcurrency,tripentry.triporiaccappamount,tripentry.travelers", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
        LinkedList<DynamicObject> searchList = new LinkedList<DynamicObject>();
        if (StringUtils.isNotEmpty((String)searchText)) {
            for (DynamicObject bill : selectBills) {
                String description = bill.getString("description");
                String billNo = bill.getString("billno");
                if (bill.getDynamicObject("applier") == null || bill.getDynamicObject("company") == null) continue;
                String applierName = bill.getDynamicObject("applier").getString("name");
                String companyName = bill.getDynamicObject("company").getString("name");
                if (billNo.indexOf(searchText) == -1 && description.indexOf(searchText) == -1 && applierName.indexOf(searchText) == -1 && companyName.indexOf(searchText) == -1) continue;
                searchList.add(bill);
            }
            selectBills = searchList.toArray(new DynamicObject[searchList.size()]);
        }
        model.deleteEntryData(entry);
        Set idSet = Arrays.stream(selectBills).flatMap(b -> b.getDynamicObjectCollection("tripentry").stream().flatMap(t -> t.getDynamicObjectCollection("travelers").stream().map(v -> v.getLong("fbasedataid_id")))).collect(Collectors.toSet());
        Map travelersDyArr = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        Collection values = travelersDyArr.values();
        HashMap<Long, String> userNameMap = new HashMap<Long, String>(travelersDyArr.size());
        for (DynamicObject user : values) {
            userNameMap.put(user.getLong("id"), user.getString("name"));
        }
        for (DynamicObject bill : selectBills) {
            DynamicObjectCollection tripEntry = bill.getDynamicObjectCollection("tripentry");
            Object billno = bill.get("billno");
            Object billid = bill.get("id");
            Object description = bill.get("description");
            if (tripEntry.size() < 1) {
                logger.info("---------\u5173\u8054\u51fa\u5dee\u7533\u8bf7\u5355\u8fc7\u6ee4\uff1a{}", billno);
                continue;
            }
            if (tripEntry.size() == 0 || tripEntry.stream().anyMatch(row -> row.get("from") == null || row.get("to") == null)) continue;
            model.batchCreateNewEntryRow(entry, tripEntry.size());
            for (DynamicObject row2 : tripEntry) {
                DynamicObject expenseItem;
                model.setValue("billid", billid, index);
                model.setValue("billno", billno, index);
                model.setValue("description", description, index);
                model.setValue("from", (Object)((DynamicObject)row2.get("from")).getString("name"), index);
                model.setValue("to", (Object)((DynamicObject)row2.get("to")).getString("name"), index);
                model.setValue("startdate", row2.get("startdate"), index);
                model.setValue("enddate", row2.get("enddate"), index);
                model.setValue("triporiamount", row2.get("triporiaccappamount"), index);
                model.setValue("tripcurrency", row2.get("tripcurrency"), index);
                DynamicObjectCollection travelers = (DynamicObjectCollection)row2.get("travelers");
                if (travelers != null) {
                    Set travelersIdSet = travelers.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    StringBuilder names = new StringBuilder();
                    Iterator iterator = travelersIdSet.stream().iterator();
                    while (iterator.hasNext() && names.length() < 200) {
                        Long id = (Long)iterator.next();
                        names.append((String)userNameMap.get(id));
                        names.append(",");
                    }
                    if (names.length() > 0) {
                        model.setValue("travelers", (Object)names.deleteCharAt(names.length() - 1).toString(), index);
                    }
                }
                String expenseItemName = (expenseItem = (DynamicObject)row2.get("tripexpenseitem")) == null ? null : expenseItem.getString("name");
                model.setValue("tripexpenseitem", (Object)expenseItemName, index++);
            }
        }
        this.getView().updateView(entry);
    }
}

