/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily;

import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class IntelligentExpenseItemPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(IntelligentExpenseItemPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit expenseItemBE = (BasedataEdit)this.getControl("expenseitem");
        expenseItemBE.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent event) {
                DataSet invoiceItemEntryDS;
                Object billId;
                Date oneYearAgo;
                Long expenseItemId;
                IFormView view = IntelligentExpenseItemPlugin.this.getView();
                List inputValues = event.getInputValues();
                Long l = !inputValues.isEmpty() ? Long.valueOf(inputValues.get(0).toString()) : (expenseItemId = event.getListSelectedRow() != null ? (Long)event.getListSelectedRow().getPrimaryKeyValue() : null);
                if (expenseItemId == null) {
                    return;
                }
                int expenseEntryRowIndex = view.getModel().getEntryCurrentRowIndex("expenseentryentity");
                DynamicObject dataEntity = view.getModel().getDataEntity(true);
                String entityName = view.getModel().getDataEntityType().getName();
                DynamicObject companyDO = dataEntity.getDynamicObject("company");
                Long companyId = ErCommonUtils.getPk((Object)companyDO);
                if (!ErCommonUtils.isEnableIntelligentExpenseItem((Long)companyId)) {
                    log.info("companyId: " + companyId + ", \u672a\u542f\u7528\u667a\u80fd\u5dee\u65c5\u9879\u76ee");
                    return;
                }
                Long expenseEntryId = (Long)((DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(expenseEntryRowIndex)).getPkValue();
                List taxClassCodes = IntelligentExpenseItemPlugin.getTaxClassCodeByExpenseEntryId(view, expenseEntryId);
                if (taxClassCodes.isEmpty()) {
                    log.info("expenseEntryId: " + expenseEntryId + ", \u672a\u5173\u8054\u53d1\u7968");
                    return;
                }
                Long aplierId = ErCommonUtils.getPk((Object)dataEntity.getDynamicObject("applier"));
                QFilter billHeadQFilter = QFilter.of((String)"applier = ? and createtime > ? and id != ?", (Object[])new Object[]{aplierId, oneYearAgo = ErCommonUtils.getDateFromLocalDate((LocalDate)LocalDate.now().minusYears(1L)), billId = dataEntity.getPkValue()});
                boolean hasBillInOneYear = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{billHeadQFilter});
                if (!hasBillInOneYear) {
                    return;
                }
                DataSet expenseEntryDS = QueryServiceHelper.queryDataSet((String)"kd.fi.er.formplugin.daily.IntelligentExpenseItemPlugin", (String)entityName, (String)"id, expenseentryentity.id expenseEntryId", (QFilter[])new QFilter[]{billHeadQFilter, QFilter.of((String)"expenseentryentity.expenseitem.id=?", (Object[])new Object[]{expenseItemId}), QFilter.of((String)"applier.id=?", (Object[])new Object[]{aplierId})}, (String)"id");
                DataSet finalDs = expenseEntryDS.join(invoiceItemEntryDS = QueryServiceHelper.queryDataSet((String)"kd.fi.er.formplugin.daily.IntelligentExpenseItemPlugin", (String)entityName, (String)"invoiceitementry.itementryid expenseEntryIdInInvoice", (QFilter[])new QFilter[]{new QFilter("invoiceitementry.goodscode", "in", (Object)taxClassCodes)}, null)).on("expenseEntryId", "expenseEntryIdInInvoice").select(new String[]{"expenseEntryId"}).finish();
                boolean existExpenseItem = finalDs.hasNext();
                if (!existExpenseItem) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8fd1\u671f\u672a\u62a5\u9500\u8fc7\u8be5\u8d39\u7528\u9879\u76ee\uff0c\u8bf7\u786e\u8ba4\u9009\u62e9\u662f\u5426\u6b63\u786e\u3002", (String)"IntelligentExpenseItemPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                finalDs.close();
                expenseEntryDS.close();
                invoiceItemEntryDS.close();
            }
        });
    }

    private static List<String> getTaxClassCodeByExpenseEntryId(IFormView view, Long expenseEntryId) {
        IFormView pView;
        if (expenseEntryId == null || Objects.equals(expenseEntryId, 0L)) {
            return Collections.emptyList();
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceItemEntries = dataEntity.getDynamicObjectCollection("invoiceitementry");
        try {
            pView = view.getParentView();
        }
        catch (Exception e) {
            pView = null;
            log.error(e.getMessage());
        }
        if (invoiceItemEntries.isEmpty() && pView != null && pView.getModel().getProperty("invoiceitementry") != null) {
            invoiceItemEntries = view.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("invoiceitementry");
        }
        if (invoiceItemEntries.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> goodCodes = invoiceItemEntries.stream().filter(entry -> Objects.equals(entry.getLong("itementryid"), expenseEntryId)).map(entry -> entry.getString("goodscode")).collect(Collectors.toList());
        return goodCodes;
    }
}

